/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.appassembler;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class HelpMojo
extends AbstractMojo {
    private boolean detail;
    private String goal;
    private int lineLength;
    private int indentSize;

    public void execute() throws MojoExecutionException {
        if (this.lineLength <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'lineLength' should be positive, using '80' as default.");
            this.lineLength = 80;
        }
        if (this.indentSize <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'indentSize' should be positive, using '2' as default.");
            this.indentSize = 2;
        }
        StringBuffer sb = new StringBuffer();
        this.append(sb, "org.codehaus.mojo:appassembler-maven-plugin:1.1", 0);
        this.append(sb, "", 0);
        this.append(sb, "Appassembler :: Maven Plug-In", 0);
        this.append(sb, "A Mojo for generating bin scripts for Java applications.", 1);
        this.append(sb, "", 0);
        if (this.goal == null || this.goal.length() <= 0) {
            this.append(sb, "This plugin has 4 goals:", 0);
            this.append(sb, "", 0);
        }
        if (this.goal == null || this.goal.length() <= 0 || "assemble".equals(this.goal)) {
            this.append(sb, "appassembler:assemble", 0);
            this.append(sb, "Assembles the artifacts and generates bin scripts for the configured applications", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "assembleDirectory (Default: ${project.build.directory}/appassembler)", 2);
                this.append(sb, "The directory that will be used to assemble the artifacts in and place the bin scripts.", 3);
                this.append(sb, "", 0);
                this.append(sb, "binFileExtensions", 2);
                this.append(sb, "The file extensions to use for bin files. The file extensions are stored in a Map that uses the platform name as key. To change the file extension for Unix bin files to '.sh' use this configuration:\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<binFileExtensions>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0<unix>.sh</unix>\n\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0</binFileExtensions>\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "configurationDirectory (Default: etc)", 2);
                this.append(sb, "The name of the target directory for configuration files.", 3);
                this.append(sb, "", 0);
                this.append(sb, "configurationSourceDirectory (Default: src/main/config)", 2);
                this.append(sb, "The name of the source directory for configuration files.", 3);
                this.append(sb, "", 0);
                this.append(sb, "copyConfigurationDirectory (Default: false)", 2);
                this.append(sb, "If the source configuration directory should be copied to the configured configurationDirectory.", 3);
                this.append(sb, "", 0);
                this.append(sb, "environmentSetupFileName", 2);
                this.append(sb, "Setup file in $BASEDIR/bin to be called prior to execution.", 3);
                this.append(sb, "", 0);
                this.append(sb, "extraJvmArguments", 2);
                this.append(sb, "Extra arguments that will be given to the JVM verbatim.", 3);
                this.append(sb, "", 0);
                this.append(sb, "generateRepository (Default: true)", 2);
                this.append(sb, "Set to false to skip repository generation.", 3);
                this.append(sb, "", 0);
                this.append(sb, "includeConfigurationDirectoryInClasspath (Default: true)", 2);
                this.append(sb, "If the configurationDirectory (etc by default) should be included in the beginning of the classpath in the generated bin files.", 3);
                this.append(sb, "", 0);
                this.append(sb, "platforms", 2);
                this.append(sb, "The default platforms the plugin will generate bin files for. Configure with string values - 'all'(default/empty) | 'windows' | 'unix'.", 3);
                this.append(sb, "", 0);
                this.append(sb, "programs", 2);
                this.append(sb, "The set of Programs that bin files will be generated for.", 3);
                this.append(sb, "", 0);
                this.append(sb, "repositoryLayout (Default: default)", 2);
                this.append(sb, "The layout of the generated Maven repository. Supported types - 'default' (Maven2) | 'legacy' (Maven1) | 'flat' (flat lib/ style).", 3);
                this.append(sb, "", 0);
                this.append(sb, "repositoryName (Default: repo)", 2);
                this.append(sb, "Path (relative to assembleDirectory) of the desired output repository.", 3);
                this.append(sb, "", 0);
                this.append(sb, "showConsoleWindow (Default: true)", 2);
                this.append(sb, "Show console window when execute this application.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "create-repository".equals(this.goal)) {
            this.append(sb, "appassembler:create-repository", 0);
            this.append(sb, "Creates an appassembler repository. Note that this is deliberately a bit more specific than the assembly plugin version - if it can generate a flat layout and exclude JARs, it may be a suitable replacement.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "assembleDirectory", 2);
                this.append(sb, "The directory that will be used to assemble the artifacts in and place the bin scripts.", 3);
                this.append(sb, "", 0);
                this.append(sb, "installBooterArtifacts (Default: false)", 2);
                this.append(sb, "Whether to install the booter artifacts into the repository. This may be needed if you are using the Shell script generators.", 3);
                this.append(sb, "", 0);
                this.append(sb, "repoPath (Default: repo)", 2);
                this.append(sb, "The directory that will be used for the dependencies, relative to assembleDirectory.", 3);
                this.append(sb, "", 0);
                this.append(sb, "repositoryLayout (Default: default)", 2);
                this.append(sb, "The layout of the generated Maven repository. Supported types - 'default' (Maven2) | 'legacy' (Maven1) | 'flat' (flat lib/ style).", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "generate-daemons".equals(this.goal)) {
            this.append(sb, "appassembler:generate-daemons", 0);
            this.append(sb, "Generates JSW based daemon wrappers.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "basedir", 2);
                this.append(sb, "The base directory of the project.", 3);
                this.append(sb, "", 0);
                this.append(sb, "daemons", 2);
                this.append(sb, "Set of Daemons to generate.", 3);
                this.append(sb, "", 0);
                this.append(sb, "defaultJvmSettings", 2);
                this.append(sb, "JvmSettings describing min/max memory and stack size, system properties and extra arguments.", 3);
                this.append(sb, "", 0);
                this.append(sb, "project", 2);
                this.append(sb, "The maven project in question.", 3);
                this.append(sb, "", 0);
                this.append(sb, "repositoryLayout (Default: default)", 2);
                this.append(sb, "The layout of the generated Maven repository. Supported types - 'default' (Maven2) | 'legacy' (Maven1) | 'flat' (flat lib/ style).", 3);
                this.append(sb, "", 0);
                this.append(sb, "target", 2);
                this.append(sb, "Target directory for generated daemons.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "help".equals(this.goal)) {
            this.append(sb, "appassembler:help", 0);
            this.append(sb, "Display help information on appassembler-maven-plugin.\nCall\n\u00a0\u00a0mvn\u00a0appassembler:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "detail (Default: false)", 2);
                this.append(sb, "If true, display all settable properties for each goal.", 3);
                this.append(sb, "", 0);
                this.append(sb, "goal", 2);
                this.append(sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3);
                this.append(sb, "", 0);
                this.append(sb, "indentSize (Default: 2)", 2);
                this.append(sb, "The number of spaces per indentation level, should be positive.", 3);
                this.append(sb, "", 0);
                this.append(sb, "lineLength (Default: 80)", 2);
                this.append(sb, "The maximum length of a display line, should be positive.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)sb.toString());
        }
    }

    private static String repeat(String str, int repeat) {
        StringBuffer buffer = new StringBuffer(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    private void append(StringBuffer sb, String description, int indent) {
        Iterator it = HelpMojo.toLines(description, indent, this.indentSize, this.lineLength).iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append('\n');
        }
    }

    private static List toLines(String text, int indent, int indentSize, int lineLength) {
        ArrayList lines = new ArrayList();
        String ind = HelpMojo.repeat("\t", indent);
        String[] plainLines = text.split("(\r\n)|(\r)|(\n)");
        for (int i = 0; i < plainLines.length; ++i) {
            HelpMojo.toLines(lines, ind + plainLines[i], indentSize, lineLength);
        }
        return lines;
    }

    private static void toLines(List lines, String line, int indentSize, int lineLength) {
        int lineIndent = HelpMojo.getIndentLevel(line);
        StringBuffer buf = new StringBuffer(256);
        String[] tokens = line.split(" +");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (i > 0) {
                if (buf.length() + token.length() >= lineLength) {
                    lines.add(buf.toString());
                    buf.setLength(0);
                    buf.append(HelpMojo.repeat(" ", lineIndent * indentSize));
                } else {
                    buf.append(' ');
                }
            }
            for (int j = 0; j < token.length(); ++j) {
                char c = token.charAt(j);
                if (c == '\t') {
                    buf.append(HelpMojo.repeat(" ", indentSize - buf.length() % indentSize));
                    continue;
                }
                if (c == '\u00a0') {
                    buf.append(' ');
                    continue;
                }
                buf.append(c);
            }
        }
        lines.add(buf.toString());
    }

    private static int getIndentLevel(String line) {
        int i;
        int level = 0;
        for (i = 0; i < line.length() && line.charAt(i) == '\t'; ++i) {
            ++level;
        }
        for (i = level + 1; i <= level + 4 && i < line.length(); ++i) {
            if (line.charAt(i) != '\t') continue;
            ++level;
            break;
        }
        return level;
    }
}

