/**
 * The MIT License
 *
 * Copyright 2006-2011 The Codehaus.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of
 * this software and associated documentation files (the "Software"), to deal in
 * the Software without restriction, including without limitation the rights to
 * use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
 * of the Software, and to permit persons to whom the Software is furnished to do
 * so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
package org.codehaus.mojo.appassembler.repository;

import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;

/**
 * The code in this class is taken from DefaultRepositorylayout, located at:
 * http://svn.apache.org/viewvc/maven/components/trunk/maven-artifact/src/main/java/org/apache/maven/artifact/repository
 * /layout/DefaultRepositoryLayout.java
 * 
 * @version $Id: FlatRepositoryLayout.java 15699 2012-01-06 19:07:03Z khmarbaise $
 * @plexus.component role="org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout" role-hint="flat"
 */
public class FlatRepositoryLayout
        implements ArtifactRepositoryLayout
{
    private static final char ARTIFACT_SEPARATOR = '-';

    private static final char GROUP_SEPARATOR = '.';

    public String pathOf ( Artifact artifact )
    {
        ArtifactHandler artifactHandler = artifact.getArtifactHandler ( );

        StringBuffer path = new StringBuffer ( );

        path.append ( artifact.getArtifactId ( ) ).append ( ARTIFACT_SEPARATOR ).append ( artifact.getVersion ( ) );

        if ( artifact.hasClassifier ( ) )
        {
            path.append ( ARTIFACT_SEPARATOR ).append ( artifact.getClassifier ( ) );
        }

        if ( artifactHandler.getExtension ( ) != null && artifactHandler.getExtension ( ).length ( ) > 0 )
        {
            path.append ( GROUP_SEPARATOR ).append ( artifactHandler.getExtension ( ) );
        }

        return path.toString ( );
    }

    public String pathOfLocalRepositoryMetadata ( ArtifactMetadata metadata, ArtifactRepository repository )
    {
        return pathOfRepositoryMetadata ( metadata.getLocalFilename ( repository ) );
    }

    private String pathOfRepositoryMetadata ( String filename )
    {
        StringBuffer path = new StringBuffer ( );

        path.append ( filename );

        return path.toString ( );
    }

    public String pathOfRemoteRepositoryMetadata ( ArtifactMetadata metadata )
    {
        return pathOfRepositoryMetadata ( metadata.getRemoteFilename ( ) );
    }
}
