/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.appassembler;

import java.io.File;
import java.io.IOException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.plexus.util.FileUtils;

public abstract class AbstractAppAssemblerMojo
extends AbstractMojo {
    protected void installArtifact(Artifact artifact, ArtifactRepository artifactRepository, boolean useTimestampInSnapshotFileName) throws MojoExecutionException {
        if (artifact.getFile() != null) {
            try {
                artifact.isSnapshot();
                File source = artifact.getFile();
                String localPath = artifactRepository.pathOf(artifact);
                File destination = new File(artifactRepository.getBasedir(), localPath);
                if (!destination.getParentFile().exists()) {
                    destination.getParentFile().mkdirs();
                }
                if (artifact.isSnapshot() && !useTimestampInSnapshotFileName) {
                    destination = new File(destination.getParentFile(), source.getName());
                }
                FileUtils.copyFile((File)source, (File)destination);
                this.getLog().info((CharSequence)("Installing artifact " + source.getPath() + " to " + destination));
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to copy artifact.", (Exception)e);
            }
        }
    }

    protected void installArtifact(Artifact artifact, ArtifactRepository artifactRepository) throws MojoExecutionException {
        this.installArtifact(artifact, artifactRepository, true);
    }
}

