/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.appassembler.daemon.jsw;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.appassembler.daemon.DaemonGenerationRequest;
import org.codehaus.mojo.appassembler.daemon.DaemonGenerator;
import org.codehaus.mojo.appassembler.daemon.DaemonGeneratorException;
import org.codehaus.mojo.appassembler.model.Daemon;
import org.codehaus.mojo.appassembler.model.GeneratorConfiguration;
import org.codehaus.mojo.appassembler.util.DependencyFactory;
import org.codehaus.mojo.appassembler.util.FormattedProperties;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.InterpolationFilterReader;
import org.codehaus.plexus.util.StringInputStream;
import org.codehaus.plexus.util.StringOutputStream;
import org.codehaus.plexus.util.StringUtils;

public class JavaServiceWrapperDaemonGenerator
extends AbstractLogEnabled
implements DaemonGenerator {
    private static final Map JSW_PLATFORMS_MAP = new HashMap(){
        {
            this.put("aix-ppc-32-lib", "libwrapper-aix-ppc-32.a");
            this.put("aix-ppc-32-exec", "wrapper-aix-ppc-32");
            this.put("aix-ppc-64-lib", "libwrapper-aix-ppc-64.a");
            this.put("aix-ppc-64-exec", "wrapper-aix-ppc-64");
            this.put("hpux-parisc-64-lib", "libwrapper-hpux-parisc-64.sl");
            this.put("hpux-parisc-64-exec", "wrapper-hpux-parisc-64");
            this.put("linux-x86-32-lib", "libwrapper-linux-x86-32.so");
            this.put("linux-x86-32-exec", "wrapper-linux-x86-32");
            this.put("linux-x86-64-lib", "libwrapper-linux-x86-64.so");
            this.put("linux-x86-64-exec", "wrapper-linux-x86-64");
            this.put("linux-ppc-64-lib", "libwrapper-linux-ppc-64.so");
            this.put("linux-ppc-64-exec", "wrapper-linux-ppc-64");
            this.put("macosx-ppc-32-lib", "libwrapper-macosx-ppc-32.jnilib");
            this.put("macosx-ppc-32-exec", "wrapper-macosx-ppc-32");
            this.put("macosx-x86-universal-32-lib", "libwrapper-macosx-universal-32.jnilib");
            this.put("macosx-x86-universal-32-exec", "wrapper-macosx-universal-32");
            this.put("macosx-universal-32-lib", "libwrapper-macosx-universal-32.jnilib");
            this.put("macosx-universal-32-exec", "wrapper-macosx-universal-32");
            this.put("macosx-universal-64-lib", "libwrapper-macosx-universal-64.jnilib");
            this.put("macosx-universal-64-exec", "wrapper-macosx-universal-64");
            this.put("solaris-sparc-32-lib", "libwrapper-solaris-sparc-32.so");
            this.put("solaris-sparc-32-exec", "wrapper-solaris-sparc-32");
            this.put("solaris-sparc-64-lib", "libwrapper-solaris-sparc-64.so");
            this.put("solaris-sparc-64-exec", "wrapper-solaris-sparc-64");
            this.put("solaris-x86-32-lib", "libwrapper-solaris-x86-32.so");
            this.put("solaris-x86-32-exec", "wrapper-solaris-x86-32");
            this.put("solaris-x86-64-lib", "libwrapper-solaris-x86-64.so");
            this.put("solaris-x86-64-exec", "wrapper-solaris-x86-64");
            this.put("windows-x86-32-lib", "wrapper-windows-x86-32.dll");
            this.put("windows-x86-32-exec", "wrapper-windows-x86-32.exe");
            this.put("windows-x86-64-lib", "wrapper-windows-x86-64.dll");
            this.put("windows-x86-64-exec", "wrapper-windows-x86-64.exe");
        }
    };
    private static final String JSW_BIN_DIR = "bin";
    private static final String JSW_LIB_DIR = "lib";

    public void generate(DaemonGenerationRequest request) throws DaemonGeneratorException {
        Daemon daemon = request.getDaemon();
        File outputDirectory = new File(request.getOutputDirectory(), daemon.getId());
        Properties configuration = this.createConfiguration(daemon);
        String appBaseEnvVar = configuration.getProperty("app.base.envvar", "APP_BASE");
        configuration.remove("app.base.envvar");
        String runAsUserEnvVar = configuration.getProperty("run.as.user.envvar", "");
        if (!runAsUserEnvVar.equals("")) {
            runAsUserEnvVar = "RUN_AS_USER=" + runAsUserEnvVar;
            configuration.remove("run.as.user.envvar");
        }
        String pidFile = configuration.getProperty("wrapper.pidfile", "$BASEDIR/logs");
        String chkconfigStart = configuration.getProperty("chkconfig.start", "20");
        configuration.remove("chkconfig.start");
        String chkconfigStop = configuration.getProperty("chkconfig.stop", "80");
        configuration.remove("chkconfig.stop");
        Properties context = JavaServiceWrapperDaemonGenerator.createContext(request, daemon);
        context.setProperty("app.base.envvar", appBaseEnvVar);
        context.setProperty("wrapper.pidfile", pidFile);
        context.setProperty("run.as.user.envvar", runAsUserEnvVar);
        context.setProperty("wrapper.conf.directory", daemon.getConfigurationDirectory());
        context.setProperty("wrapper.conf.fileName", this.getWrapperConfigFileName(daemon));
        context.setProperty("chkconfig.start", chkconfigStart);
        context.setProperty("chkconfig.stop", chkconfigStop);
        this.writeWrapperConfFile(request, daemon, outputDirectory, context, configuration);
        this.writeScriptFiles(request, daemon, outputDirectory, context);
        List jswPlatformIncludes = this.getJswPlatformIncludes(daemon);
        this.writeLibraryFiles(outputDirectory, daemon, jswPlatformIncludes);
        this.writeExecutableFiles(outputDirectory, daemon, jswPlatformIncludes);
    }

    private void writeWrapperConfFile(DaemonGenerationRequest request, Daemon daemon, File outputDirectory, Properties context, Properties configuration) throws DaemonGeneratorException {
        InputStream in = this.getClass().getResourceAsStream("conf/wrapper.conf.in");
        if (in == null) {
            throw new DaemonGeneratorException("Could not load template.");
        }
        FormattedProperties confFile = new FormattedProperties();
        try {
            confFile.read(in);
        }
        catch (IOException e) {
            throw new DaemonGeneratorException("Error reading template: " + e.getMessage(), e);
        }
        finally {
            IOUtil.close((InputStream)in);
        }
        confFile.setPropertyAfter("wrapper.working.dir", "..", "wrapper.java.command");
        confFile.setProperty("wrapper.java.library.path.1", daemon.getRepositoryName());
        confFile.setPropertyAfter("set.default.REPO_DIR", daemon.getRepositoryName(), "wrapper.java.mainclass");
        confFile.setPropertyAfter("set." + context.getProperty("app.base.envvar"), ".", "wrapper.java.mainclass");
        if (daemon.getWrapperLogFile() == null) {
            confFile.setProperty("wrapper.logfile", "../logs/wrapper.log");
        } else {
            confFile.setProperty("wrapper.logfile", daemon.getWrapperLogFile());
        }
        if (daemon.getJvmSettings() != null && !StringUtils.isEmpty((String)daemon.getJvmSettings().getInitialMemorySize())) {
            confFile.setProperty("wrapper.java.initmemory", daemon.getJvmSettings().getInitialMemorySize());
        }
        if (daemon.getJvmSettings() != null && !StringUtils.isEmpty((String)daemon.getJvmSettings().getMaxMemorySize())) {
            confFile.setProperty("wrapper.java.maxmemory", daemon.getJvmSettings().getMaxMemorySize());
        }
        confFile.setProperty("wrapper.app.parameter.1", daemon.getMainClass());
        this.createClasspath(daemon, request, confFile, configuration);
        JavaServiceWrapperDaemonGenerator.createAdditional(daemon, confFile);
        JavaServiceWrapperDaemonGenerator.createParameters(daemon, confFile);
        Iterator<Map.Entry<Object, Object>> i = configuration.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<Object, Object> entry = i.next();
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (value.length() > 0) {
                confFile.setProperty(key, value);
                continue;
            }
            confFile.removeProperty(key);
        }
        StringOutputStream string = new StringOutputStream();
        confFile.save((OutputStream)string);
        InputStreamReader reader = new InputStreamReader((InputStream)new StringInputStream(string.toString()));
        JavaServiceWrapperDaemonGenerator.writeFilteredFile(request, daemon, reader, new File(outputDirectory, daemon.getConfigurationDirectory() + "/" + this.getWrapperConfigFileName(daemon)), context);
    }

    private String getWrapperConfigFileName(Daemon daemon) {
        String wrapperConfigFileName = "wrapper.conf";
        if (daemon.isUseDaemonIdAsWrapperConfName()) {
            wrapperConfigFileName = "wrapper-" + daemon.getId() + ".conf";
        }
        return wrapperConfigFileName;
    }

    private Properties createConfiguration(Daemon daemon) {
        Properties configuration = new Properties();
        Iterator i = daemon.getGeneratorConfigurations().iterator();
        while (i.hasNext()) {
            GeneratorConfiguration generatorConfiguration = (GeneratorConfiguration)i.next();
            if (!generatorConfiguration.getGenerator().equals("jsw")) continue;
            configuration.putAll((Map<?, ?>)generatorConfiguration.getConfiguration());
        }
        return configuration;
    }

    private static void writeFilteredFile(DaemonGenerationRequest request, Daemon daemon, Reader reader, File outputFile, Map context) throws DaemonGeneratorException {
        InterpolationFilterReader interpolationFilterReader = new InterpolationFilterReader(reader, context, "@", "@");
        JavaServiceWrapperDaemonGenerator.writeFile(outputFile, (Reader)interpolationFilterReader);
    }

    private static Properties createContext(DaemonGenerationRequest request, Daemon daemon) {
        Properties context = new Properties();
        context.setProperty("app.long.name", request.getMavenProject().getName());
        context.setProperty("app.name", daemon.getId());
        String description = request.getMavenProject().getDescription();
        if (description == null) {
            description = request.getMavenProject().getName();
        }
        context.setProperty("app.description", description);
        String envSetupFileName = daemon.getEnvironmentSetupFileName();
        String envSetup = "";
        if (envSetupFileName != null) {
            String envScriptPath = "\"%BASEDIR%\\bin\\" + envSetupFileName + ".bat\"";
            envSetup = "if exist " + envScriptPath + " call " + envScriptPath;
            context.put("env.setup.windows", envSetup);
            envScriptPath = "\"$BASEDIR\"/bin/" + envSetupFileName;
            envSetup = "[ -f " + envScriptPath + " ] && . " + envScriptPath;
            context.put("env.setup.unix", envSetup);
        } else {
            context.put("env.setup.windows", envSetup);
            context.put("env.setup.unix", envSetup);
        }
        return context;
    }

    private static void writeFile(File outputFile, Reader reader) throws DaemonGeneratorException {
        FileWriter out = null;
        try {
            outputFile.getParentFile().mkdirs();
            out = new FileWriter(outputFile);
            IOUtil.copy((Reader)reader, (Writer)out);
        }
        catch (IOException e) {
            try {
                throw new DaemonGeneratorException("Error writing output file: " + outputFile.getAbsolutePath(), e);
            }
            catch (Throwable throwable) {
                IOUtil.close((Reader)reader);
                IOUtil.close(out);
                throw throwable;
            }
        }
        IOUtil.close((Reader)reader);
        IOUtil.close((Writer)out);
    }

    private static void writeFile(File outputFile, InputStream inputStream) throws DaemonGeneratorException {
        FileOutputStream out = null;
        try {
            outputFile.getParentFile().mkdirs();
            out = new FileOutputStream(outputFile);
            IOUtil.copy((InputStream)inputStream, (OutputStream)out);
        }
        catch (IOException e) {
            try {
                throw new DaemonGeneratorException("Error writing output file: " + outputFile.getAbsolutePath(), e);
            }
            catch (Throwable throwable) {
                IOUtil.close((InputStream)inputStream);
                IOUtil.close(out);
                throw throwable;
            }
        }
        IOUtil.close((InputStream)inputStream);
        IOUtil.close((OutputStream)out);
    }

    private void createClasspath(Daemon daemon, DaemonGenerationRequest request, FormattedProperties confFile, Properties configuration) {
        String wrapperClassPathPrefix = "wrapper.java.classpath.";
        int counter = 1;
        confFile.setProperty("wrapper.java.classpath." + counter++, daemon.getRepositoryName() + "/wrapper.jar");
        String configurationDirFirst = configuration.getProperty("configuration.directory.in.classpath.first");
        if (configurationDirFirst != null) {
            confFile.setProperty("wrapper.java.classpath." + counter++, configurationDirFirst);
        }
        MavenProject project = request.getMavenProject();
        ArtifactRepositoryLayout layout = request.getRepositoryLayout();
        if (daemon.getEndorsedDir() != null) {
            confFile.setProperty("wrapper.java.classpath." + counter++, daemon.getEndorsedDir() + "/*");
        }
        if (daemon.isUseWildcardClassPath()) {
            confFile.setProperty("wrapper.java.classpath." + counter++, "%REPO_DIR%/*");
        } else {
            confFile.setProperty("wrapper.java.classpath." + counter++, "%REPO_DIR%/" + DependencyFactory.create(project.getArtifact(), layout, true, request.getOutputFileNameMapping()).getRelativePath());
            Iterator j = project.getRuntimeArtifacts().iterator();
            while (j.hasNext()) {
                Artifact artifact = (Artifact)j.next();
                confFile.setProperty("wrapper.java.classpath." + counter, "%REPO_DIR%/" + DependencyFactory.create(artifact, layout, daemon.isUseTimestampInSnapshotFileName(), request.getOutputFileNameMapping()).getRelativePath());
                ++counter;
            }
        }
        String configurationDirLast = configuration.getProperty("configuration.directory.in.classpath.last");
        if (configurationDirLast != null) {
            confFile.setProperty("wrapper.java.classpath." + counter++, configurationDirLast);
        }
    }

    private static void createAdditional(Daemon daemon, FormattedProperties confFile) {
        if (daemon.getJvmSettings() != null) {
            int count = 1;
            Iterator i = daemon.getJvmSettings().getSystemProperties().iterator();
            while (i.hasNext()) {
                String systemProperty = (String)i.next();
                confFile.setProperty("wrapper.java.additional." + count, "-D" + systemProperty);
                ++count;
            }
            i = daemon.getJvmSettings().getExtraArguments().iterator();
            while (i.hasNext()) {
                String extraArgument = (String)i.next();
                confFile.setProperty("wrapper.java.additional." + count, extraArgument);
                ++count;
            }
        }
    }

    private static void createParameters(Daemon daemon, FormattedProperties confFile) {
        int count = 2;
        Iterator i = daemon.getCommandLineArguments().iterator();
        while (i.hasNext()) {
            String argument = (String)i.next();
            if (StringUtils.isNotEmpty((String)argument)) {
                confFile.setProperty("wrapper.app.parameter." + count, argument);
            }
            ++count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeScriptFiles(DaemonGenerationRequest request, Daemon daemon, File outputDirectory, Properties context) throws DaemonGeneratorException {
        InputStream shellScriptInputStream = null;
        InputStream batchFileInputStream = null;
        try {
            shellScriptInputStream = this.getUnixTemplate(daemon);
            if (shellScriptInputStream == null) {
                throw new DaemonGeneratorException("Could not load template.");
            }
            InputStreamReader reader = new InputStreamReader(shellScriptInputStream);
            JavaServiceWrapperDaemonGenerator.writeFilteredFile(request, daemon, reader, new File(outputDirectory, "bin/" + daemon.getId()), context);
            batchFileInputStream = this.getWindowsTemplate(daemon);
            if (batchFileInputStream == null) {
                throw new DaemonGeneratorException("Could not load template.");
            }
            reader = new InputStreamReader(batchFileInputStream);
            JavaServiceWrapperDaemonGenerator.writeFilteredFile(request, daemon, reader, new File(outputDirectory, "bin/" + daemon.getId() + ".bat"), context);
        }
        catch (Throwable throwable) {
            IOUtil.close((InputStream)shellScriptInputStream);
            IOUtil.close(batchFileInputStream);
            throw throwable;
        }
        IOUtil.close((InputStream)shellScriptInputStream);
        IOUtil.close((InputStream)batchFileInputStream);
    }

    private InputStream getUnixTemplate(Daemon daemon) throws DaemonGeneratorException {
        return this.getTemplate(daemon.getUnixScriptTemplate(), "bin/sh.script.in");
    }

    private InputStream getWindowsTemplate(Daemon daemon) throws DaemonGeneratorException {
        return this.getTemplate(daemon.getWindowsScriptTemplate(), "bin/AppCommand.bat.in");
    }

    private InputStream getTemplate(String customTemplate, String internalTemplate) throws DaemonGeneratorException {
        InputStream is = null;
        try {
            if (customTemplate != null) {
                File customTemplateFile = new File(customTemplate);
                if (customTemplateFile.exists()) {
                    is = new FileInputStream(customTemplateFile);
                } else {
                    is = this.getClass().getClassLoader().getResourceAsStream(customTemplate);
                    if (is == null) {
                        throw new DaemonGeneratorException("Unable to load external template resource: " + customTemplate);
                    }
                }
            } else {
                is = this.getClass().getResourceAsStream(internalTemplate);
                if (is == null) {
                    throw new DaemonGeneratorException("Unable to load internal template resource: " + internalTemplate);
                }
            }
        }
        catch (FileNotFoundException e) {
            throw new DaemonGeneratorException("Unable to load external template file", e);
        }
        return is;
    }

    private void writeLibraryFiles(File outputDirectory, Daemon daemon, List jswPlatformIncludes) throws DaemonGeneratorException {
        if (daemon.getExternalDeltaPackDirectory() != null) {
            this.copyExternalFile(new File(daemon.getExternalDeltaPackDirectory(), "lib/wrapper.jar"), new File(outputDirectory, daemon.getRepositoryName() + "/wrapper.jar"));
        } else {
            this.copyResourceFile(new File(outputDirectory, daemon.getRepositoryName()), JSW_LIB_DIR, "wrapper.jar");
        }
        Iterator iter = jswPlatformIncludes.iterator();
        while (iter.hasNext()) {
            String platform = (String)iter.next();
            String libFile = (String)JSW_PLATFORMS_MAP.get(platform + "-lib");
            if (libFile != null) {
                if (daemon.getExternalDeltaPackDirectory() != null) {
                    this.copyExternalFile(new File(daemon.getExternalDeltaPackDirectory(), "lib/" + libFile), new File(outputDirectory, daemon.getRepositoryName() + "/" + libFile));
                    continue;
                }
                this.copyResourceFile(new File(outputDirectory, daemon.getRepositoryName()), JSW_LIB_DIR, libFile);
                continue;
            }
            this.getLogger().warn("Lib file for " + platform + " not found in map.");
        }
    }

    private void writeExecutableFiles(File outputDirectory, Daemon daemon, List jswPlatformIncludes) throws DaemonGeneratorException {
        Iterator iter = jswPlatformIncludes.iterator();
        while (iter.hasNext()) {
            String platform = (String)iter.next();
            String execFile = (String)JSW_PLATFORMS_MAP.get(platform + "-exec");
            if (execFile != null) {
                if (daemon.getExternalDeltaPackDirectory() != null) {
                    this.copyExternalFile(new File(daemon.getExternalDeltaPackDirectory(), "bin/" + execFile), new File(outputDirectory, "bin/" + execFile));
                    continue;
                }
                this.copyResourceFile(new File(outputDirectory, JSW_BIN_DIR), JSW_BIN_DIR, execFile);
                continue;
            }
            this.getLogger().warn("Exec file for " + platform + " not found in map.");
        }
    }

    private void copyExternalFile(File from, File to) throws DaemonGeneratorException {
        try {
            from.getParentFile().mkdirs();
            FileUtils.copyFile((File)from, (File)to);
        }
        catch (IOException e) {
            throw new DaemonGeneratorException("Could not copy external file: " + from, e);
        }
    }

    private void copyResourceFile(File outputDirectory, String inputDirectory, String fileName) throws DaemonGeneratorException {
        InputStream batchFileInputStream = this.getClass().getResourceAsStream(inputDirectory + "/" + fileName);
        if (batchFileInputStream == null) {
            throw new DaemonGeneratorException("Could not load library file: " + fileName);
        }
        JavaServiceWrapperDaemonGenerator.writeFile(new File(outputDirectory, fileName), batchFileInputStream);
    }

    private List getJswPlatformIncludes(Daemon daemon) {
        List<String> jswPlatformIncludes = null;
        Iterator i = daemon.getGeneratorConfigurations().iterator();
        while (i.hasNext()) {
            GeneratorConfiguration generatorConfiguration = (GeneratorConfiguration)i.next();
            if (!generatorConfiguration.getGenerator().equals("jsw")) continue;
            jswPlatformIncludes = generatorConfiguration.getIncludes();
        }
        if (jswPlatformIncludes == null || jswPlatformIncludes.isEmpty()) {
            jswPlatformIncludes = new ArrayList<String>();
            jswPlatformIncludes.add("aix-ppc-32");
            jswPlatformIncludes.add("aix-ppc-64");
            jswPlatformIncludes.add("linux-x86-32");
            jswPlatformIncludes.add("macosx-x86-universal-32");
            jswPlatformIncludes.add("solaris-x86-32");
            jswPlatformIncludes.add("windows-x86-32");
        }
        return jswPlatformIncludes;
    }
}

