/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.appassembler.model.io.stax;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.codehaus.mojo.appassembler.model.Classpath;
import org.codehaus.mojo.appassembler.model.ClasspathElement;
import org.codehaus.mojo.appassembler.model.Daemon;
import org.codehaus.mojo.appassembler.model.Dependency;
import org.codehaus.mojo.appassembler.model.Directory;
import org.codehaus.mojo.appassembler.model.GeneratorConfiguration;
import org.codehaus.mojo.appassembler.model.JvmSettings;

public class AppassemblerModelStaxReader {
    public Daemon read(Reader reader, boolean strict) throws IOException, XMLStreamException {
        XMLStreamReader xmlStreamReader = XMLInputFactory.newInstance().createXMLStreamReader(reader);
        return this.read(xmlStreamReader, strict);
    }

    public Daemon read(Reader reader) throws IOException, XMLStreamException {
        return this.read(reader, true);
    }

    public Daemon read(InputStream stream, boolean strict) throws IOException, XMLStreamException {
        XMLStreamReader xmlStreamReader = XMLInputFactory.newInstance().createXMLStreamReader(stream);
        return this.read(xmlStreamReader, strict);
    }

    public Daemon read(InputStream stream) throws IOException, XMLStreamException {
        return this.read(stream, true);
    }

    public Daemon read(String filePath, boolean strict) throws IOException, XMLStreamException {
        File file = new File(filePath);
        XMLStreamReader xmlStreamReader = XMLInputFactory.newInstance().createXMLStreamReader(file.toURI().toURL().toExternalForm(), new FileInputStream(file));
        return this.read(xmlStreamReader, strict);
    }

    public Daemon read(String filePath) throws IOException, XMLStreamException {
        return this.read(filePath, true);
    }

    private boolean checkFieldWithDuplicate(XMLStreamReader xmlStreamReader, String tagName, String alias, Set parsed) throws XMLStreamException {
        if (!xmlStreamReader.getLocalName().equals(tagName) && !xmlStreamReader.getLocalName().equals(alias)) {
            return false;
        }
        if (!parsed.add(tagName)) {
            throw new XMLStreamException("Duplicated tag: '" + tagName + "'", xmlStreamReader.getLocation());
        }
        return true;
    }

    private void checkUnknownElement(XMLStreamReader xmlStreamReader, boolean strict) throws XMLStreamException {
        if (strict) {
            throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
        }
        int unrecognizedTagCount = 1;
        while (unrecognizedTagCount != 0) {
            xmlStreamReader.next();
            if (xmlStreamReader.getEventType() == 1) {
                ++unrecognizedTagCount;
                continue;
            }
            if (xmlStreamReader.getEventType() != 2) continue;
            --unrecognizedTagCount;
        }
    }

    private boolean getBooleanValue(String s, String attribute, XMLStreamReader xmlStreamReader) throws XMLStreamException {
        if (s != null) {
            return Boolean.valueOf(s);
        }
        return false;
    }

    private byte getByteValue(String s, String attribute, XMLStreamReader xmlStreamReader, boolean strict) throws XMLStreamException {
        block3: {
            if (s != null) {
                try {
                    return Byte.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XMLStreamException("Unable to parse element '" + attribute + "', must be a byte but was '" + s + "'", xmlStreamReader.getLocation(), nfe);
                }
            }
        }
        return 0;
    }

    private char getCharacterValue(String s, String attribute, XMLStreamReader xmlStreamReader) throws XMLStreamException {
        if (s != null) {
            return s.charAt(0);
        }
        return '\u0000';
    }

    private Date getDateValue(String s, String attribute, String dateFormat, XMLStreamReader xmlStreamReader) throws XMLStreamException {
        if (s != null) {
            String effectiveDateFormat = dateFormat;
            if (dateFormat == null) {
                effectiveDateFormat = "yyyy-MM-dd'T'HH:mm:ss.SSS";
            }
            if ("long".equals(effectiveDateFormat)) {
                try {
                    return new Date(Long.parseLong(s));
                }
                catch (NumberFormatException e) {
                    throw new XMLStreamException(e.getMessage(), xmlStreamReader.getLocation(), e);
                }
            }
            try {
                SimpleDateFormat dateParser = new SimpleDateFormat(effectiveDateFormat, Locale.US);
                return dateParser.parse(s);
            }
            catch (ParseException e) {
                throw new XMLStreamException(e.getMessage(), xmlStreamReader.getLocation(), e);
            }
        }
        return null;
    }

    private String getDefaultValue(String s, String v) {
        if (s == null) {
            s = v;
        }
        return s;
    }

    private double getDoubleValue(String s, String attribute, XMLStreamReader xmlStreamReader, boolean strict) throws XMLStreamException {
        block3: {
            if (s != null) {
                try {
                    return Double.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XMLStreamException("Unable to parse element '" + attribute + "', must be a floating point number but was '" + s + "'", xmlStreamReader.getLocation(), nfe);
                }
            }
        }
        return 0.0;
    }

    private float getFloatValue(String s, String attribute, XMLStreamReader xmlStreamReader, boolean strict) throws XMLStreamException {
        block3: {
            if (s != null) {
                try {
                    return Float.valueOf(s).floatValue();
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XMLStreamException("Unable to parse element '" + attribute + "', must be a floating point number but was '" + s + "'", xmlStreamReader.getLocation(), nfe);
                }
            }
        }
        return 0.0f;
    }

    private int getIntegerValue(String s, String attribute, XMLStreamReader xmlStreamReader, boolean strict) throws XMLStreamException {
        block3: {
            if (s != null) {
                try {
                    return Integer.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XMLStreamException("Unable to parse element '" + attribute + "', must be an integer but was '" + s + "'", xmlStreamReader.getLocation(), nfe);
                }
            }
        }
        return 0;
    }

    private long getLongValue(String s, String attribute, XMLStreamReader xmlStreamReader, boolean strict) throws XMLStreamException {
        block3: {
            if (s != null) {
                try {
                    return Long.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XMLStreamException("Unable to parse element '" + attribute + "', must be a long integer but was '" + s + "'", xmlStreamReader.getLocation(), nfe);
                }
            }
        }
        return 0L;
    }

    private String getRequiredAttributeValue(String s, String attribute, XMLStreamReader xmlStreamReader, boolean strict) throws XMLStreamException {
        if (s == null && strict) {
            throw new XMLStreamException("Missing required value for attribute '" + attribute + "'", xmlStreamReader.getLocation());
        }
        return s;
    }

    private short getShortValue(String s, String attribute, XMLStreamReader xmlStreamReader, boolean strict) throws XMLStreamException {
        block3: {
            if (s != null) {
                try {
                    return Short.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XMLStreamException("Unable to parse element '" + attribute + "', must be a short integer but was '" + s + "'", xmlStreamReader.getLocation(), nfe);
                }
            }
        }
        return 0;
    }

    private String getTrimmedValue(String s) {
        if (s != null) {
            s = s.trim();
        }
        return s;
    }

    private int nextTag(XMLStreamReader xmlStreamReader) throws XMLStreamException {
        block4: while (true) {
            int eventType = xmlStreamReader.next();
            switch (eventType) {
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 12: {
                    continue block4;
                }
                case 1: 
                case 2: {
                    return eventType;
                }
            }
            break;
        }
        throw new XMLStreamException("expected start or end tag", xmlStreamReader.getLocation());
    }

    private Classpath parseClasspath(XMLStreamReader xmlStreamReader, boolean strict) throws IOException, XMLStreamException {
        Classpath classpath = new Classpath();
        HashSet parsed = new HashSet();
        while ((strict ? xmlStreamReader.nextTag() : this.nextTag(xmlStreamReader)) == 1) {
            if (this.checkFieldWithDuplicate(xmlStreamReader, "dependencies", null, parsed)) {
                ArrayList dependencies = new ArrayList();
                classpath.setDependencies(dependencies);
                while (xmlStreamReader.nextTag() == 1) {
                    if ("dependency".equals(xmlStreamReader.getLocalName())) {
                        classpath.addDependency(this.parseDependency(xmlStreamReader, strict));
                        continue;
                    }
                    throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(xmlStreamReader, "directories", null, parsed)) {
                ArrayList directories = new ArrayList();
                classpath.setDirectories(directories);
                while (xmlStreamReader.nextTag() == 1) {
                    if ("directory".equals(xmlStreamReader.getLocalName())) {
                        classpath.addDirectory(this.parseDirectory(xmlStreamReader, strict));
                        continue;
                    }
                    throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                continue;
            }
            this.checkUnknownElement(xmlStreamReader, strict);
        }
        return classpath;
    }

    private ClasspathElement parseClasspathElement(XMLStreamReader xmlStreamReader, boolean strict) throws IOException, XMLStreamException {
        ClasspathElement classpathElement = new ClasspathElement();
        HashSet parsed = new HashSet();
        while ((strict ? xmlStreamReader.nextTag() : this.nextTag(xmlStreamReader)) == 1) {
            if (this.checkFieldWithDuplicate(xmlStreamReader, "relativePath", null, parsed)) {
                classpathElement.setRelativePath(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            this.checkUnknownElement(xmlStreamReader, strict);
        }
        return classpathElement;
    }

    private Daemon parseDaemon(XMLStreamReader xmlStreamReader, boolean strict) throws IOException, XMLStreamException {
        Daemon daemon = new Daemon();
        HashSet parsed = new HashSet();
        while ((strict ? xmlStreamReader.nextTag() : this.nextTag(xmlStreamReader)) == 1) {
            if (this.checkFieldWithDuplicate(xmlStreamReader, "id", null, parsed)) {
                daemon.setId(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(xmlStreamReader, "mainClass", null, parsed)) {
                daemon.setMainClass(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(xmlStreamReader, "wrapperMainClass", null, parsed)) {
                daemon.setWrapperMainClass(this.getTrimmedValue(this.getDefaultValue(xmlStreamReader.getElementText(), "org.tanukisoftware.wrapper.WrapperSimpleApp")));
                continue;
            }
            if (this.checkFieldWithDuplicate(xmlStreamReader, "classpath", null, parsed)) {
                daemon.setClasspath(this.parseClasspath(xmlStreamReader, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(xmlStreamReader, "commandLineArguments", null, parsed)) {
                ArrayList<String> commandLineArguments = new ArrayList<String>();
                daemon.setCommandLineArguments(commandLineArguments);
                while (xmlStreamReader.nextTag() == 1) {
                    if ("commandLineArgument".equals(xmlStreamReader.getLocalName())) {
                        commandLineArguments.add(this.getTrimmedValue(this.getDefaultValue(xmlStreamReader.getElementText(), "new java.util.ArrayList/*<String>*/()")));
                        continue;
                    }
                    throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(xmlStreamReader, "configurationDirectory", null, parsed)) {
                daemon.setConfigurationDirectory(this.getTrimmedValue(this.getDefaultValue(xmlStreamReader.getElementText(), "repo")));
                continue;
            }
            if (this.checkFieldWithDuplicate(xmlStreamReader, "jvmSettings", null, parsed)) {
                daemon.setJvmSettings(this.parseJvmSettings(xmlStreamReader, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(xmlStreamReader, "environmentSetupFileName", null, parsed)) {
                daemon.setEnvironmentSetupFileName(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(xmlStreamReader, "showConsoleWindow", null, parsed)) {
                daemon.setShowConsoleWindow(this.getBooleanValue(this.getTrimmedValue(this.getDefaultValue(xmlStreamReader.getElementText(), "true")), "showConsoleWindow", xmlStreamReader));
                continue;
            }
            if (this.checkFieldWithDuplicate(xmlStreamReader, "useTimestampInSnapshotFileName", null, parsed)) {
                daemon.setUseTimestampInSnapshotFileName(this.getBooleanValue(this.getTrimmedValue(this.getDefaultValue(xmlStreamReader.getElementText(), "true")), "useTimestampInSnapshotFileName", xmlStreamReader));
                continue;
            }
            if (this.checkFieldWithDuplicate(xmlStreamReader, "useDaemonIdAsWrapperConfName", null, parsed)) {
                daemon.setUseDaemonIdAsWrapperConfName(this.getBooleanValue(this.getTrimmedValue(this.getDefaultValue(xmlStreamReader.getElementText(), "false")), "useDaemonIdAsWrapperConfName", xmlStreamReader));
                continue;
            }
            if (this.checkFieldWithDuplicate(xmlStreamReader, "useWildcardClassPath", null, parsed)) {
                daemon.setUseWildcardClassPath(this.getBooleanValue(this.getTrimmedValue(this.getDefaultValue(xmlStreamReader.getElementText(), "false")), "useWildcardClassPath", xmlStreamReader));
                continue;
            }
            if (this.checkFieldWithDuplicate(xmlStreamReader, "generatorConfigurations", null, parsed)) {
                ArrayList generatorConfigurations = new ArrayList();
                daemon.setGeneratorConfigurations(generatorConfigurations);
                while (xmlStreamReader.nextTag() == 1) {
                    if ("generatorConfiguration".equals(xmlStreamReader.getLocalName())) {
                        daemon.addGeneratorConfiguration(this.parseGeneratorConfiguration(xmlStreamReader, strict));
                        continue;
                    }
                    throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(xmlStreamReader, "repositoryName", null, parsed)) {
                daemon.setRepositoryName(this.getTrimmedValue(this.getDefaultValue(xmlStreamReader.getElementText(), "repo")));
                continue;
            }
            if (this.checkFieldWithDuplicate(xmlStreamReader, "licenseHeaderFile", null, parsed)) {
                daemon.setLicenseHeaderFile(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(xmlStreamReader, "wrapperLogFile", null, parsed)) {
                daemon.setWrapperLogFile(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(xmlStreamReader, "unixScriptTemplate", null, parsed)) {
                daemon.setUnixScriptTemplate(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(xmlStreamReader, "windowsScriptTemplate", null, parsed)) {
                daemon.setWindowsScriptTemplate(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(xmlStreamReader, "externalDeltaPackDirectory", null, parsed)) {
                daemon.setExternalDeltaPackDirectory(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(xmlStreamReader, "endorsedDir", null, parsed)) {
                daemon.setEndorsedDir(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(xmlStreamReader, "preWrapperConf", null, parsed)) {
                daemon.setPreWrapperConf(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            this.checkUnknownElement(xmlStreamReader, strict);
        }
        return daemon;
    }

    private Dependency parseDependency(XMLStreamReader xmlStreamReader, boolean strict) throws IOException, XMLStreamException {
        Dependency dependency = new Dependency();
        HashSet parsed = new HashSet();
        while ((strict ? xmlStreamReader.nextTag() : this.nextTag(xmlStreamReader)) == 1) {
            if (this.checkFieldWithDuplicate(xmlStreamReader, "groupId", null, parsed)) {
                dependency.setGroupId(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(xmlStreamReader, "artifactId", null, parsed)) {
                dependency.setArtifactId(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(xmlStreamReader, "version", null, parsed)) {
                dependency.setVersion(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(xmlStreamReader, "classifier", null, parsed)) {
                dependency.setClassifier(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(xmlStreamReader, "relativePath", null, parsed)) {
                dependency.setRelativePath(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            this.checkUnknownElement(xmlStreamReader, strict);
        }
        return dependency;
    }

    private Directory parseDirectory(XMLStreamReader xmlStreamReader, boolean strict) throws IOException, XMLStreamException {
        Directory directory = new Directory();
        HashSet parsed = new HashSet();
        while ((strict ? xmlStreamReader.nextTag() : this.nextTag(xmlStreamReader)) == 1) {
            if (this.checkFieldWithDuplicate(xmlStreamReader, "relativePath", null, parsed)) {
                directory.setRelativePath(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            this.checkUnknownElement(xmlStreamReader, strict);
        }
        return directory;
    }

    private GeneratorConfiguration parseGeneratorConfiguration(XMLStreamReader xmlStreamReader, boolean strict) throws IOException, XMLStreamException {
        GeneratorConfiguration generatorConfiguration = new GeneratorConfiguration();
        HashSet parsed = new HashSet();
        while ((strict ? xmlStreamReader.nextTag() : this.nextTag(xmlStreamReader)) == 1) {
            if (this.checkFieldWithDuplicate(xmlStreamReader, "generator", null, parsed)) {
                generatorConfiguration.setGenerator(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(xmlStreamReader, "configuration", null, parsed)) {
                while (xmlStreamReader.nextTag() == 1) {
                    String key = xmlStreamReader.getLocalName();
                    String value = xmlStreamReader.getElementText().trim();
                    generatorConfiguration.addConfiguration(key, value);
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(xmlStreamReader, "includes", null, parsed)) {
                ArrayList<String> includes = new ArrayList<String>();
                generatorConfiguration.setIncludes(includes);
                while (xmlStreamReader.nextTag() == 1) {
                    if ("include".equals(xmlStreamReader.getLocalName())) {
                        includes.add(this.getTrimmedValue(this.getDefaultValue(xmlStreamReader.getElementText(), "new java.util.ArrayList/*<String>*/()")));
                        continue;
                    }
                    throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                continue;
            }
            this.checkUnknownElement(xmlStreamReader, strict);
        }
        return generatorConfiguration;
    }

    private JvmSettings parseJvmSettings(XMLStreamReader xmlStreamReader, boolean strict) throws IOException, XMLStreamException {
        JvmSettings jvmSettings = new JvmSettings();
        HashSet parsed = new HashSet();
        while ((strict ? xmlStreamReader.nextTag() : this.nextTag(xmlStreamReader)) == 1) {
            if (this.checkFieldWithDuplicate(xmlStreamReader, "initialMemorySize", null, parsed)) {
                jvmSettings.setInitialMemorySize(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(xmlStreamReader, "maxMemorySize", null, parsed)) {
                jvmSettings.setMaxMemorySize(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(xmlStreamReader, "maxStackSize", null, parsed)) {
                jvmSettings.setMaxStackSize(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (this.checkFieldWithDuplicate(xmlStreamReader, "systemProperties", null, parsed)) {
                ArrayList<String> systemProperties = new ArrayList<String>();
                jvmSettings.setSystemProperties(systemProperties);
                while (xmlStreamReader.nextTag() == 1) {
                    if ("systemProperty".equals(xmlStreamReader.getLocalName())) {
                        systemProperties.add(this.getTrimmedValue(this.getDefaultValue(xmlStreamReader.getElementText(), "new java.util.ArrayList/*<String>*/()")));
                        continue;
                    }
                    throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(xmlStreamReader, "extraArguments", null, parsed)) {
                ArrayList<String> extraArguments = new ArrayList<String>();
                jvmSettings.setExtraArguments(extraArguments);
                while (xmlStreamReader.nextTag() == 1) {
                    if ("extraArgument".equals(xmlStreamReader.getLocalName())) {
                        extraArguments.add(this.getTrimmedValue(this.getDefaultValue(xmlStreamReader.getElementText(), "new java.util.ArrayList/*<String>*/()")));
                        continue;
                    }
                    throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                continue;
            }
            this.checkUnknownElement(xmlStreamReader, strict);
        }
        return jvmSettings;
    }

    private Daemon read(XMLStreamReader xmlStreamReader, boolean strict) throws IOException, XMLStreamException {
        int eventType = xmlStreamReader.getEventType();
        String encoding = null;
        while (eventType != 8) {
            if (eventType == 7) {
                encoding = xmlStreamReader.getCharacterEncodingScheme();
            }
            if (eventType == 1) {
                if (strict && !"daemon".equals(xmlStreamReader.getLocalName())) {
                    throw new XMLStreamException("Expected root element 'daemon' but found '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation(), null);
                }
                Daemon daemon = this.parseDaemon(xmlStreamReader, strict);
                daemon.setModelEncoding(encoding);
                this.resolveReferences(daemon);
                return daemon;
            }
            eventType = xmlStreamReader.next();
        }
        throw new XMLStreamException("Expected root element 'daemon' but found no element at all: invalid XML document", xmlStreamReader.getLocation(), null);
    }

    private void resolveReferences(Daemon value) {
    }
}

