/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.axistools;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class HelpMojo
extends AbstractMojo {
    private boolean detail;
    private String goal;
    private int lineLength;
    private int indentSize;

    public void execute() throws MojoExecutionException {
        StringBuffer sb = new StringBuffer();
        this.append(sb, "org.codehaus.mojo:axistools-maven-plugin:1.3", 0);
        this.append(sb, "", 0);
        this.append(sb, "Maven Axis Tools Plugin 1.3", 0);
        this.append(sb, "This plugin supports the wsdl2java and java2wsdl tools from the Apache Axis (1) project.", 1);
        this.append(sb, "", 0);
        if (this.goal == null || this.goal.length() <= 0) {
            this.append(sb, "This plugin has 4 goals:", 0);
            this.append(sb, "", 0);
        }
        if (this.goal == null || this.goal.length() <= 0 || "admin".equals(this.goal)) {
            this.append(sb, "axistools:admin", 0);
            this.append(sb, "Utility for turning xml into Axis deployment operations (wraps org.apache.axis.utils.Admin)", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "configOutputDirectory", 2);
                this.append(sb, "Where the server-config.wsdd or client-config.wsdd should go", 3);
                this.append(sb, "", 0);
                this.append(sb, "inputFiles", 2);
                this.append(sb, "Files used to create deployment file", 3);
                this.append(sb, "", 0);
                this.append(sb, "isServerConfig", 2);
                this.append(sb, "Generate a server or client deployment file", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "help".equals(this.goal)) {
            this.append(sb, "axistools:help", 0);
            this.append(sb, "Display help information on axistools-maven-plugin. Call\n\u00a0\u00a0mvn\u00a0axistools:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "detail (Default: false)", 2);
                this.append(sb, "If true, display all settable properties for each goal.", 3);
                this.append(sb, "", 0);
                this.append(sb, "goal", 2);
                this.append(sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3);
                this.append(sb, "", 0);
                this.append(sb, "lineLength (Default: 80)", 2);
                this.append(sb, "The maximum length of a display line.", 3);
                this.append(sb, "", 0);
                this.append(sb, "indentSize (Default: 2)", 2);
                this.append(sb, "The number of spaces per indentation level.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "java2wsdl".equals(this.goal)) {
            this.append(sb, "axistools:java2wsdl", 0);
            this.append(sb, "A Plugin for generating WSDL files using Axis Java2WSDL.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "all", 2);
                this.append(sb, "Look for allowed methods in inherited class.", 3);
                this.append(sb, "", 0);
                this.append(sb, "bindingName", 2);
                this.append(sb, "Indicates the name to use for the binding element. If not specified, the value of the servicePortName + 'SoapBinding' is used.", 3);
                this.append(sb, "", 0);
                this.append(sb, "classOfPortType", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "classesDirectory", 2);
                this.append(sb, "The directory the compile objects will be located for java2wsdl to source from.", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludes", 2);
                this.append(sb, "List of methods not to export.", 3);
                this.append(sb, "", 0);
                this.append(sb, "extraClasses", 2);
                this.append(sb, "Specify a list of class names which should be included in the types section of the WSDL document. This is useful in the case where your service interface references a base class and you would like your WSDL to contain XML Schema type definitions for these other classes.", 3);
                this.append(sb, "", 0);
                this.append(sb, "filename", 2);
                this.append(sb, "Indicates the name of the output WSDL file.", 3);
                this.append(sb, "", 0);
                this.append(sb, "implClass", 2);
                this.append(sb, "Sometimes extra information is available in the implementation class file. Use this option to specify the implementation class.", 3);
                this.append(sb, "", 0);
                this.append(sb, "importSchema", 2);
                this.append(sb, "A file or URL to an XML Schema that should be physically imported into the generated WSDL.", 3);
                this.append(sb, "", 0);
                this.append(sb, "input", 2);
                this.append(sb, "Optional parameter that indicates the name of the input wsdl file. The output wsdl file will contain everything from the input wsdl file plus the new constructs. If a new construct is already present in the input wsdl file, it is not added. This option is useful for constructing a wsdl file with multiple ports, bindings, or portTypes.", 3);
                this.append(sb, "", 0);
                this.append(sb, "location", 2);
                this.append(sb, "Indicates the url of the location of the service. The name after the last slash or backslash is the name of the service port (unless overridden by the servicePortName option). The service port address location attribute is assigned the specified value.", 3);
                this.append(sb, "", 0);
                this.append(sb, "locationImport", 2);
                this.append(sb, "Used to indicate the location of the interface WSDL when generating an implementation WSDL.", 3);
                this.append(sb, "", 0);
                this.append(sb, "methods", 2);
                this.append(sb, "Methods to export.", 3);
                this.append(sb, "", 0);
                this.append(sb, "namespace", 2);
                this.append(sb, "Indicates the name of the target namespace of the WSDL.", 3);
                this.append(sb, "", 0);
                this.append(sb, "namespaceImpl", 2);
                this.append(sb, "Namespace of the implementation WSDL.", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory", 2);
                this.append(sb, "Directory for generated content.", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputImpl", 2);
                this.append(sb, "Use this option to indicate the name of the output implementation WSDL file. If specified, Java2WSDL will produce interface and implementation WSDL files. If this option is used, the outputWSDLMode option is ignored.", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputWSDLMode", 2);
                this.append(sb, "Indicates the kind of WSDL to generate. Accepted values are:\n-\tAll --- (default) Generates wsdl containing both interface and implementation WSDL constructs.\n-\tInterface --- Generates a WSDL containing the interface constructs (no service element).\n-\tImplementation -- Generates a WSDL containing the implementation. The interface WSDL is imported via the locationImport option.\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "packageToNamespace", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "portTypeName", 2);
                this.append(sb, "Indicates the name to use for the portType element. If not specified, the classOfPortType name is used.", 3);
                this.append(sb, "", 0);
                this.append(sb, "serviceElementName", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "servicePortName", 2);
                this.append(sb, "Indicates the name of the service port. If not specified, the service port name is derived from the location value.", 3);
                this.append(sb, "", 0);
                this.append(sb, "soapAction", 2);
                this.append(sb, "The value of the operations soapAction field. Values are DEFAULT, OPERATION or NONE. OPERATION forces soapAction to the name of the operation. DEFAULT causes the soapAction to be set according to the operation's meta data (usually ''). NONE forces the soapAction to ''. The default is DEFAULT.", 3);
                this.append(sb, "", 0);
                this.append(sb, "stopClasses", 2);
                this.append(sb, "List of classes which stop the Java2WSDL inheritance search.", 3);
                this.append(sb, "", 0);
                this.append(sb, "style", 2);
                this.append(sb, "The style of the WSDL document: RPC, DOCUMENT or WRAPPED. The default is RPC. If RPC is specified, an rpc wsdl is generated. If DOCUMENT is specified, a document wsdl is generated. If WRAPPED is specified, a document/literal wsdl is generated using the wrapped approach. Wrapped style forces the use attribute to be literal.", 3);
                this.append(sb, "", 0);
                this.append(sb, "typeMappingVersion", 2);
                this.append(sb, "Choose the default type mapping registry to use. Either 1.1 or 1.2.", 3);
                this.append(sb, "", 0);
                this.append(sb, "use", 2);
                this.append(sb, "The use of the WSDL document: LITERAL or ENCODED. If LITERAL is specified, the XML Schema defines the representation of the XML for the request. If ENCODED is specified, SOAP encoding is specified in the generated WSDL.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "wsdl2java".equals(this.goal)) {
            this.append(sb, "axistools:wsdl2java", 0);
            this.append(sb, "A Plugin for generating stubs for WSDL files using Axis WSDL2Java.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "allElements", 2);
                this.append(sb, "Generate code for all elements, even unreferenced ones. By default, WSDL2Java only generates code for those elements in the WSDL file that are referenced. A note about what it means to be referenced. We cannot simply say: start with the services, generate all bindings referenced by the service, generate all portTypes referenced by the referenced bindings, etc. What if we're generating code from a WSDL file that only contains portTypes, messages, and types? If WSDL2Java used service as an anchor, and there's no service in the file, then nothing will be generated. So the anchor is the lowest element that exists in the WSDL file in the order:\n1.\ttypes\n2.\tportTypes\n3.\tbindings\n4.\tservices\nFor example, if a WSDL file only contained types, then all the listed types would be generated. But if a WSDL file contained types and a portType, then that portType will be generated and only those types that are referenced by that portType. Note that the anchor is searched for in the WSDL file appearing on the command line, not in imported WSDL files. This allows one WSDL file to import constructs defined in another WSDL file without the nuisance of having all the imported WSDL file's constructs generated.", 3);
                this.append(sb, "", 0);
                this.append(sb, "debug", 2);
                this.append(sb, "Print debug information, which currently is WSDL2Java's symbol table. Note that this is only printed after the symbol table is complete, ie., after the WSDL is parsed successfully.", 3);
                this.append(sb, "", 0);
                this.append(sb, "deployScope", 2);
                this.append(sb, "Add scope to deploy.xml: 'Application', 'Request', 'Session'", 3);
                this.append(sb, "", 0);
                this.append(sb, "factory", 2);
                this.append(sb, "Name of a custom class that implements GeneratorFactory interface (for extending Java generation functions).", 3);
                this.append(sb, "", 0);
                this.append(sb, "fileNamespaceToPackage", 2);
                this.append(sb, "file of NStoPkg mappings", 3);
                this.append(sb, "", 0);
                this.append(sb, "helperGen", 2);
                this.append(sb, "Emits separate Helper classes for meta data.", 3);
                this.append(sb, "", 0);
                this.append(sb, "implementationClassName", 2);
                this.append(sb, "Use this as the implementation class.", 3);
                this.append(sb, "", 0);
                this.append(sb, "mappings", 2);
                this.append(sb, "mappings are only used when useEmitter is set to true", 3);
                this.append(sb, "", 0);
                this.append(sb, "namespaceToPackage", 2);
                this.append(sb, "Mapping of namespace to package", 3);
                this.append(sb, "", 0);
                this.append(sb, "noImports", 2);
                this.append(sb, "Only generate code for the immediate WSDL document.", 3);
                this.append(sb, "", 0);
                this.append(sb, "noWrapped", 2);
                this.append(sb, "Turn off support for 'wrapped' document/literal.", 3);
                this.append(sb, "", 0);
                this.append(sb, "nsExcludes", 2);
                this.append(sb, "Namespace to specifically exclude from the generated code (defaults to none excluded until first namespace included with nsIncludes option)", 3);
                this.append(sb, "", 0);
                this.append(sb, "nsIncludes", 2);
                this.append(sb, "Namescape to specifically include in the generated code (defaults to all namespaces unless specifically excluded with the nsExcludes option)", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "packageSpace", 2);
                this.append(sb, "package to create the java files under", 3);
                this.append(sb, "", 0);
                this.append(sb, "password", 2);
                this.append(sb, "Password to access the WSDL-URI.", 3);
                this.append(sb, "", 0);
                this.append(sb, "runTestCasesAsUnitTests", 2);
                this.append(sb, "copy the generated test cases to a generated-sources test directory to be compiled and run as normal surefire unit tests", 3);
                this.append(sb, "", 0);
                this.append(sb, "serverSide", 2);
                this.append(sb, "Emit server-side bindings for web service.", 3);
                this.append(sb, "", 0);
                this.append(sb, "skeletonDeploy", 2);
                this.append(sb, "Deploy skeleton (true) or implementation (false) in deploy.wsdd.", 3);
                this.append(sb, "", 0);
                this.append(sb, "sourceDependencies", 2);
                this.append(sb, "list of source dependencies in the format groupId:artifactId:version:file", 3);
                this.append(sb, "", 0);
                this.append(sb, "sourceDependencyDirectory", 2);
                this.append(sb, "Cache directory for WSDLs from sourceDependencies", 3);
                this.append(sb, "", 0);
                this.append(sb, "sourceDirectory", 2);
                this.append(sb, "source directory that contains .wsdl files", 3);
                this.append(sb, "", 0);
                this.append(sb, "staleMillis (Default: 0)", 2);
                this.append(sb, "The granularity in milliseconds of the last modification date for testing whether a source needs recompilation", 3);
                this.append(sb, "", 0);
                this.append(sb, "subPackageByFileName", 2);
                this.append(sb, "load.wsdl would further subpackage into load.*", 3);
                this.append(sb, "", 0);
                this.append(sb, "testCases", 2);
                this.append(sb, "generate the test cases", 3);
                this.append(sb, "", 0);
                this.append(sb, "testSourceDirectory", 2);
                this.append(sb, "location to place generated test source", 3);
                this.append(sb, "", 0);
                this.append(sb, "timeout", 2);
                this.append(sb, "Timeout in seconds (default is 45, specify -1 to disable).", 3);
                this.append(sb, "", 0);
                this.append(sb, "timestampDirectory", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "typeMappingVersion", 2);
                this.append(sb, "Indicate 1.1 or 1.2. The default is 1.1 (SOAP 1.1 JAX-RPC compliant. 1.2 indicates SOAP 1.1 encoded.)", 3);
                this.append(sb, "", 0);
                this.append(sb, "urlDownloadDirectory", 2);
                this.append(sb, "Cache directory for WSDLs from URLs", 3);
                this.append(sb, "", 0);
                this.append(sb, "urls", 2);
                this.append(sb, "list of urls to process", 3);
                this.append(sb, "", 0);
                this.append(sb, "useEmitter", 2);
                this.append(sb, "use the Emitter for generating the java files as opposed to the commandline wsdl2java tool", 3);
                this.append(sb, "", 0);
                this.append(sb, "username", 2);
                this.append(sb, "Username to access the WSDL-URI.", 3);
                this.append(sb, "", 0);
                this.append(sb, "verbose", 2);
                this.append(sb, "See what the tool is generating as it is generating it.", 3);
                this.append(sb, "", 0);
                this.append(sb, "wrapArrays", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "wsdlFiles", 2);
                this.append(sb, "List of wsdl files from sourceDirectory to process", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)sb.toString());
        }
    }

    private static String repeat(String str, int repeat) {
        StringBuffer buffer = new StringBuffer(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    private void append(StringBuffer sb, String description, int indent) {
        Iterator it = this.toLines(description, indent).iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append('\n');
        }
    }

    private List toLines(String text, int indent) {
        ArrayList lines = new ArrayList();
        String ind = HelpMojo.repeat("\t", indent);
        String[] plainLines = text.split("(\r\n)|(\r)|(\n)");
        for (int i = 0; i < plainLines.length; ++i) {
            this.toLines(lines, ind + plainLines[i]);
        }
        return lines;
    }

    private void toLines(List lines, String line) {
        int lineIndent = HelpMojo.getIndentLevel(line);
        StringBuffer buf = new StringBuffer(256);
        String[] tokens = line.split(" +");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (i > 0) {
                if (buf.length() + token.length() >= this.lineLength) {
                    lines.add(buf.toString());
                    buf.setLength(0);
                    buf.append(HelpMojo.repeat(" ", lineIndent * this.indentSize));
                } else {
                    buf.append(' ');
                }
            }
            for (int j = 0; j < token.length(); ++j) {
                char c = token.charAt(j);
                if (c == '\t') {
                    buf.append(HelpMojo.repeat(" ", this.indentSize - buf.length() % this.indentSize));
                    continue;
                }
                if (c == '\u00a0') {
                    buf.append(' ');
                    continue;
                }
                buf.append(c);
            }
        }
        lines.add(buf.toString());
    }

    private static int getIndentLevel(String line) {
        int i;
        int level = 0;
        for (i = 0; i < line.length() && line.charAt(i) == '\t'; ++i) {
            ++level;
        }
        for (i = level + 1; i <= level + 4 && i < line.length(); ++i) {
            if (line.charAt(i) != '\t') continue;
            ++level;
            break;
        }
        return level;
    }
}

