/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.axistools.admin;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import org.codehaus.mojo.axistools.admin.AdminPlugin;
import org.codehaus.mojo.axistools.admin.AdminWrapper;
import org.codehaus.mojo.axistools.axis.AbstractAxisPlugin;
import org.codehaus.mojo.axistools.axis.AxisPluginException;

public class DefaultAdminPlugin
extends AbstractAxisPlugin
implements AdminPlugin {
    private File configOutputDirectory;
    private boolean isServerConfig;
    private ArrayList inputFiles;

    public void setServerConfig(boolean serverConfig) {
        this.isServerConfig = serverConfig;
    }

    public void setConfigOutputDirectory(File configOutputDirectory) {
        this.configOutputDirectory = configOutputDirectory;
    }

    public void setInputFiles(ArrayList inputFiles) {
        this.inputFiles = inputFiles;
    }

    public void execute() throws AxisPluginException {
        ArrayList<String> argsList = new ArrayList<String>();
        if (!this.configOutputDirectory.exists()) {
            this.configOutputDirectory.mkdirs();
        }
        String mode = "client";
        if (this.isServerConfig) {
            mode = "server";
        }
        argsList.add(mode);
        argsList.add(this.configOutputDirectory.getAbsolutePath() + File.separator + mode + "-config.wsdd");
        if (this.inputFiles != null && this.inputFiles.size() > 0) {
            Iterator i = this.inputFiles.iterator();
            while (i.hasNext()) {
                argsList.add((String)i.next());
            }
        } else {
            throw new AxisPluginException("You must specify at least one inputfile in the pom");
        }
        try {
            AdminWrapper wrapper = new AdminWrapper(this.getLog());
            wrapper.execute(argsList.toArray(new String[0]));
        }
        catch (Throwable t) {
            throw new AxisPluginException("Admin execution failed", t);
        }
    }
}

