/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.batik;

import java.awt.Color;
import java.io.File;
import java.util.Map;
import java.util.Vector;
import org.apache.batik.apps.rasterizer.DestinationType;
import org.apache.batik.apps.rasterizer.SVGConverter;
import org.apache.batik.apps.rasterizer.SVGConverterController;
import org.apache.batik.apps.rasterizer.SVGConverterException;
import org.apache.batik.apps.rasterizer.SVGConverterSource;
import org.apache.batik.transcoder.Transcoder;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.StringUtils;

public class RasterizeMojo
extends AbstractMojo
implements SVGConverterController {
    private File srcDir;
    private String srcIncludes;
    private String srcExcludes;
    private File destDir;
    private String destType;
    private float width;
    private float height;
    private float maxWidth;
    private float maxHeight;
    private int indexed;
    private float quality;
    private String background;
    private float dpi;

    public void execute() throws MojoExecutionException, MojoFailureException {
        String[] src = RasterizeMojo.getSrc(this.srcDir, this.srcIncludes, this.srcExcludes);
        if (src.length == 0) {
            this.getLog().info((CharSequence)"No SVG files found");
            return;
        }
        SVGConverter converter = new SVGConverter((SVGConverterController)this);
        converter.setSources(src);
        converter.setDst(this.destDir);
        converter.setDestinationType(RasterizeMojo.toDestinationType(this.destType));
        converter.setWidth(this.width);
        converter.setHeight(this.height);
        converter.setMaxWidth(this.maxWidth);
        converter.setMaxHeight(this.maxHeight);
        converter.setIndexed(this.indexed);
        converter.setQuality(this.quality);
        if (this.dpi != -1.0f) {
            converter.setPixelUnitToMillimeter(2.54f / this.dpi * 10.0f);
        }
        if (this.background != null) {
            converter.setBackgroundColor(RasterizeMojo.toColor(this.background));
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("Rasterizing ").append(src.length).append(" image");
        if (src.length > 1) {
            buffer.append("s");
        }
        buffer.append(" from SVG to ");
        buffer.append(converter.getDestinationType().toString());
        this.getLog().info((CharSequence)buffer.toString());
        try {
            converter.execute();
        }
        catch (SVGConverterException exception) {
            throw new MojoExecutionException("Cannot rasterize SVGs", (Exception)((Object)exception));
        }
    }

    public boolean proceedWithComputedTask(Transcoder transcoder, Map hints, Vector sources, Vector dest) {
        return true;
    }

    public boolean proceedWithSourceTranscoding(SVGConverterSource source, File dest) {
        return true;
    }

    public boolean proceedOnSourceTranscodingFailure(SVGConverterSource source, File dest, String errorCode) {
        this.getLog().warn((CharSequence)("Cannot rasterize SVG " + source.getName() + ": " + errorCode));
        return false;
    }

    public void onSourceTranscodingSuccess(SVGConverterSource source, File dest) {
        this.getLog().debug((CharSequence)("Rasterized SVG " + source.getName()));
    }

    private static String[] getSrc(File directory, String includes, String excludes) {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(directory);
        scanner.setIncludes(StringUtils.split((String)includes, (String)","));
        if (excludes != null) {
            scanner.setExcludes(StringUtils.split((String)excludes, (String)","));
        }
        scanner.scan();
        String[] files = scanner.getIncludedFiles();
        for (int i = 0; i < files.length; ++i) {
            files[i] = new File(directory, files[i]).toString();
        }
        return files;
    }

    private static DestinationType toDestinationType(String destinationType) throws MojoExecutionException {
        DestinationType type;
        if ("png".equals(destinationType)) {
            type = DestinationType.PNG;
        } else if ("jpeg".equals(destinationType)) {
            type = DestinationType.JPEG;
        } else if ("tiff".equals(destinationType)) {
            type = DestinationType.TIFF;
        } else if ("pdf".equals(destinationType)) {
            type = DestinationType.PDF;
        } else {
            throw new MojoExecutionException("Invalid destination type: " + destinationType);
        }
        return type;
    }

    private static Color toColor(String color) throws MojoExecutionException {
        if (!color.startsWith("#") || color.length() != 7) {
            throw new MojoExecutionException("Color must be of the form #rrggbb: " + color);
        }
        int r = Integer.parseInt(color.substring(1, 3), 16);
        int g = Integer.parseInt(color.substring(3, 5), 16);
        int b = Integer.parseInt(color.substring(5), 16);
        return new Color(r, g, b);
    }
}

