/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.resolver.bod.binary;

import java.util.Iterator;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.io.logging.DefaultMessageHolder;
import org.apache.maven.wagon.TransferFailedException;
import org.codehaus.mojo.resolver.bod.BuildOnDemandResolutionException;
import org.codehaus.mojo.resolver.bod.binary.BinaryDependencyManager;
import org.codehaus.plexus.logging.LogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.console.ConsoleLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOSBinaryDependencyManager
implements BinaryDependencyManager,
LogEnabled {
    private ArtifactResolver artifactResolver;
    private Logger logger;

    protected AbstractOSBinaryDependencyManager(ArtifactResolver resolver) {
        this.artifactResolver = resolver;
    }

    protected AbstractOSBinaryDependencyManager() {
    }

    @Override
    public void findDependenciesWithMissingBinaries(List<MavenProject> dependencyProjects, ArtifactRepository localRepository) throws BuildOnDemandResolutionException {
        if (dependencyProjects == null || dependencyProjects.isEmpty()) {
            return;
        }
        DefaultMessageHolder errors = new DefaultMessageHolder();
        Iterator<MavenProject> it = dependencyProjects.iterator();
        while (it.hasNext()) {
            MavenProject project = it.next();
            if (this.isDependencyInstalledOnSystem(project)) {
                it.remove();
                continue;
            }
            Artifact projectArtifact = project.getArtifact();
            try {
                this.artifactResolver.resolve(projectArtifact, project.getRemoteArtifactRepositories(), localRepository);
                if (!projectArtifact.isResolved() || projectArtifact.getFile() == null || !this.installDependencyOnSystem(project)) continue;
                it.remove();
            }
            catch (ArtifactResolutionException e) {
                Throwable cause = e.getCause();
                if (cause != null && cause instanceof TransferFailedException) {
                    errors.addMessage((CharSequence)("Transfer of artifact: " + project.getId() + " failed."), (Throwable)e);
                    continue;
                }
                this.getLogger().debug("Failed to resolve artifact: " + project.getId() + "; it will need to be built.", (Throwable)e);
            }
            catch (ArtifactNotFoundException e) {
                this.getLogger().debug("Failed to resolve artifact: " + project.getId() + "; it will need to be built.", (Throwable)e);
            }
        }
    }

    protected abstract boolean installDependencyOnSystem(MavenProject var1) throws BuildOnDemandResolutionException;

    protected abstract boolean isDependencyInstalledOnSystem(MavenProject var1) throws BuildOnDemandResolutionException;

    protected ArtifactResolver getArtifactResolver() {
        return this.artifactResolver;
    }

    protected Logger getLogger() {
        if (this.logger == null) {
            this.logger = new ConsoleLogger(0, "BinaryDependencyManager:internal");
        }
        return this.logger;
    }

    public void enableLogging(Logger log) {
        this.logger = log;
    }
}

