/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.build;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.command.status.StatusScmResult;
import org.apache.maven.scm.command.update.UpdateScmResult;
import org.apache.maven.scm.log.ScmLogDispatcher;
import org.apache.maven.scm.log.ScmLogger;
import org.apache.maven.scm.manager.ScmManager;
import org.apache.maven.scm.provider.ScmProvider;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.svn.command.update.SvnUpdateScmResult;
import org.apache.maven.scm.provider.svn.repository.SvnScmProviderRepository;
import org.apache.maven.scm.repository.ScmRepository;
import org.codehaus.mojo.build.InfoScmResult;
import org.codehaus.mojo.build.SvnInfoCommand;
import org.codehaus.plexus.util.StringUtils;

public class BuildMojo
extends AbstractMojo {
    private String urlScm;
    private String username;
    private String password;
    private String tag;
    private String tagBase;
    private File basedir;
    private String buildNumberPropertyName;
    private String timestampPropertyName;
    private boolean doCheck;
    private boolean doUpdate;
    private String format;
    private List items;
    private ScmManager scmManager;
    private MavenProject project;
    private ScmLogDispatcher logger;
    private String revision;

    public void setScmManager(ScmManager scmManager) {
        this.scmManager = scmManager;
    }

    public void setUrlScm(String urlScm) {
        this.urlScm = urlScm;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public void setTagBase(String tagBase) {
        this.tagBase = tagBase;
    }

    public void setBasedir(File basedir) {
        this.basedir = basedir;
    }

    public void setDoCheck(boolean doCheck) {
        String doCheckSystemProperty = System.getProperty("maven.buildNumber.doCheck");
        this.doCheck = doCheckSystemProperty != null ? Boolean.valueOf(doCheckSystemProperty) : doCheck;
    }

    public void setDoUpdate(boolean doUpdate) {
        String doUpdateSystemProperty = System.getProperty("maven.buildNumber.doUpdate");
        this.doUpdate = doUpdateSystemProperty != null ? Boolean.valueOf(doUpdateSystemProperty) : doUpdate;
    }

    void setFormat(String format) {
        this.format = format;
    }

    void setItems(List items) {
        this.items = items;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        Date now = Calendar.getInstance().getTime();
        if (this.format != null) {
            Object[] itemAry = new Object[this.items.size()];
            for (int i = 0; i < this.items.size(); ++i) {
                Object item = this.items.get(i);
                if (item instanceof String) {
                    String s = (String)item;
                    if (s.equals("timestamp")) {
                        itemAry[i] = now;
                        continue;
                    }
                    if (s.startsWith("buildNumber")) {
                        File propertiesFile = new File(this.basedir, "buildNumber.properties");
                        if (!propertiesFile.exists()) {
                            try {
                                propertiesFile.createNewFile();
                            }
                            catch (IOException e) {
                                throw new MojoExecutionException("Couldn't create properties file: " + propertiesFile, (Exception)e);
                            }
                        }
                        Properties properties = new Properties();
                        String buildNumberString = null;
                        try {
                            properties.load(new FileInputStream(propertiesFile));
                            buildNumberString = properties.getProperty(s);
                            if (buildNumberString == null) {
                                buildNumberString = "0";
                            }
                            int buildNumber = Integer.valueOf(buildNumberString);
                            properties.setProperty(s, String.valueOf(++buildNumber));
                            properties.store(new FileOutputStream(propertiesFile), "maven.buildNumber.plugin properties file");
                            itemAry[i] = new Integer(buildNumber);
                            continue;
                        }
                        catch (NumberFormatException e) {
                            throw new MojoExecutionException("Couldn't parse buildNumber in properties file to an Integer: " + buildNumberString);
                        }
                        catch (IOException e) {
                            throw new MojoExecutionException("Couldn't load properties file: " + propertiesFile, (Exception)e);
                        }
                    }
                    itemAry[i] = item;
                    continue;
                }
                itemAry[i] = item;
            }
            this.revision = MessageFormat.format(this.format, itemAry);
        } else {
            if (this.doCheck) {
                this.checkForLocalModifications();
            } else {
                this.getLog().info((CharSequence)"Checking for local modifications: skipped.");
            }
            if (this.doUpdate) {
                List changedFiles = this.update();
                Iterator i = changedFiles.iterator();
                while (i.hasNext()) {
                    ScmFile file = (ScmFile)i.next();
                    this.getLog().info((CharSequence)("Updated: " + file));
                }
                if (changedFiles.size() == 0) {
                    this.getLog().info((CharSequence)"No files needed updating.");
                }
            } else {
                this.getLog().info((CharSequence)"Updating project files from SCM: skipped.");
            }
            this.revision = this.getRevision();
        }
        if (this.project != null) {
            String timestamp = String.valueOf(now.getTime());
            this.getLog().info((CharSequence)MessageFormat.format("Storing buildNumber: {0} at timestamp: {1}", this.revision, timestamp));
            this.project.getProperties().put(this.buildNumberPropertyName, this.revision);
            this.project.getProperties().put(this.timestampPropertyName, timestamp);
        }
    }

    private void checkForLocalModifications() throws MojoExecutionException {
        List changedFiles;
        this.getLog().info((CharSequence)"Verifying there are no local modifications ...");
        try {
            changedFiles = this.getStatus();
        }
        catch (ScmException e) {
            throw new MojoExecutionException("An error has occurred while checking scm status.", (Exception)((Object)e));
        }
        if (!changedFiles.isEmpty()) {
            StringBuffer message = new StringBuffer();
            Iterator i = changedFiles.iterator();
            while (i.hasNext()) {
                ScmFile file = (ScmFile)i.next();
                message.append(file.toString());
                message.append("\n");
            }
            throw new MojoExecutionException("Cannot create the build number because you have local modifications : \n" + message);
        }
    }

    public List update() throws MojoExecutionException {
        try {
            ScmRepository repository = this.getScmRepository();
            ScmProvider scmProvider = this.scmManager.getProviderByRepository(repository);
            UpdateScmResult result = scmProvider.update(repository, new ScmFileSet(new File(this.basedir.getAbsolutePath())), null);
            this.checkResult((ScmResult)result);
            if (result instanceof SvnUpdateScmResult) {
                String revision = ((SvnUpdateScmResult)result).getRevision();
                this.getLog().info((CharSequence)("Got a revision during update: " + revision));
                this.revision = revision;
            }
            return result.getUpdatedFiles();
        }
        catch (ScmException e) {
            throw new MojoExecutionException("Couldn't update project.", (Exception)((Object)e));
        }
    }

    public List getStatus() throws ScmException {
        ScmRepository repository = this.getScmRepository();
        ScmProvider scmProvider = this.scmManager.getProviderByRepository(repository);
        StatusScmResult result = scmProvider.status(repository, new ScmFileSet(new File(this.basedir.getAbsolutePath())));
        this.checkResult((ScmResult)result);
        return result.getChangedFiles();
    }

    public String getRevision() throws MojoExecutionException {
        if (this.format != null) {
            return this.revision;
        }
        try {
            ScmRepository repository = this.getScmRepository();
            InfoScmResult result = this.info(repository, new ScmFileSet(new File(this.basedir.getAbsolutePath())));
            this.checkResult(result);
            return result.getRevision();
        }
        catch (ScmException e) {
            throw new MojoExecutionException("Cannot get the revision information from the scm repository : \n" + e.getLocalizedMessage(), (Exception)((Object)e));
        }
    }

    public InfoScmResult info(ScmRepository repository, ScmFileSet fileSet) throws ScmException {
        SvnInfoCommand command = new SvnInfoCommand();
        command.setLogger(this.getLogger());
        return (InfoScmResult)command.execute(repository.getProviderRepository(), fileSet, null);
    }

    private ScmLogger getLogger() {
        if (this.logger == null) {
            this.logger = new ScmLogDispatcher();
        }
        return this.logger;
    }

    private ScmRepository getScmRepository() throws ScmException {
        ScmRepository repository;
        try {
            repository = this.scmManager.makeScmRepository(this.urlScm);
            ScmProviderRepository scmRepo = repository.getProviderRepository();
            if (!StringUtils.isEmpty((String)this.username)) {
                scmRepo.setUser(this.username);
            }
            if (!StringUtils.isEmpty((String)this.password)) {
                scmRepo.setPassword(this.password);
            }
            if (repository.getProvider().equals("svn")) {
                SvnScmProviderRepository svnRepo = (SvnScmProviderRepository)repository.getProviderRepository();
                if (this.tagBase != null && this.tagBase.length() > 0) {
                    svnRepo.setTagBase(this.tagBase);
                }
            }
        }
        catch (Exception e) {
            throw new ScmException("Can't load the scm provider.", (Throwable)e);
        }
        return repository;
    }

    private void checkResult(ScmResult result) throws ScmException {
        if (!result.isSuccess()) {
            System.err.println("Provider message:");
            System.err.println(result.getProviderMessage());
            System.err.println("Command output:");
            System.err.println(result.getCommandOutput());
            throw new ScmException("Error!");
        }
    }
}

