package org.codehaus.mojo.build;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

/**
 * Display help information on buildnumber-maven-plugin. Call <pre>  mvn buildnumber:help -Ddetail=true -Dgoal=&lt;goal-name&gt;</pre> to display parameter details.
 *
 * @version generated on Fri Jan 09 15:12:19 PST 2009
 * @goal help
 * @requiresProject false
 */
public class HelpMojo
    extends AbstractMojo
{
    /**
     * If <code>true</code>, display all settable properties for each goal.
     * 
     * @parameter expression="${detail}" default-value="false"
     */
    private boolean detail;

    /**
     * The name of the goal for which to show help. If unspecified, all goals will be displayed.
     * 
     * @parameter expression="${goal}"
     */
    private java.lang.String goal;

    /**
     * The maximum length of a display line.
     * 
     * @parameter expression="${lineLength}" default-value="80"
     */
    private int lineLength;

    /**
     * The number of spaces per indentation level.
     * 
     * @parameter expression="${indentSize}" default-value="2"
     */
    private int indentSize;


    /** {@inheritDoc} */
    public void execute()
        throws MojoExecutionException
    {
        StringBuffer sb = new StringBuffer();

        append( sb, "org.codehaus.mojo:buildnumber-maven-plugin:1.0-beta-2", 0 );
        append( sb, "", 0 );

        append( sb, "Build Number Maven Plugin 1.0-beta-2", 0 );
        append( sb, "This plugin is designed to give you a build number. So when you might make 100 builds of version 1.0-SNAPSHOT, you can differentiate between them all.", 1 );
        append( sb, "", 0 );

        if ( goal == null || goal.length() <= 0 )
        {
            append( sb, "This plugin has 2 goals:", 0 );
            append( sb, "", 0 );
        }

        if ( goal == null || goal.length() <= 0 || "create".equals( goal ) )
        {
            append( sb, "buildnumber:create", 0 );
            append( sb, "This mojo is designed to give you a build number. So when you might make 100 builds of version 1.0-SNAPSHOT, you can differentiate between them all. The build number is based on the revision number retrieved from scm. It only works with subversion, currently. This mojo can also check to make sure that you have checked everything into scm, before issuing the build number. That behaviour can be suppressed, and then the latest local build number is used. Build numbers are not reflected in your artifact\'s filename (automatically), but can be added to the metadata. You can access the build number in your pom with ${buildNumber}. You can also access ${timestamp}.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "buildNumberPropertiesFileLocation (Default: ${basedir}/buildNumber.properties)", 2 );
                append( sb, "Properties file to be created when \'format\' is not null and item has \'buildNumber\'. See Usage for details", 3 );
                append( sb, "", 0 );

                append( sb, "buildNumberPropertyName (Default: buildNumber)", 2 );
                append( sb, "You can rename the buildNumber property name to another property name if desired.", 3 );
                append( sb, "", 0 );

                append( sb, "doCheck (Default: false)", 2 );
                append( sb, "If this is made true, we check for modified files, and if there are any, we fail the build. Note that this used to be inverted (skipCheck), but needed to be changed to allow releases to work. This corresponds to \'svn status\'.", 3 );
                append( sb, "", 0 );

                append( sb, "doUpdate (Default: false)", 2 );
                append( sb, "", 3 );
                append( sb, "", 0 );

                append( sb, "format", 2 );
                append( sb, "Specify a message as specified by java.text.MessageFormat. This triggers \'items\' configuration to be read", 3 );
                append( sb, "", 0 );

                append( sb, "items", 2 );
                append( sb, "Specify the corresponding items for the format message, as specified by java.text.MessageFormat. Special item values are \'timestamp\' and \'buildNumber/d*\'.", 3 );
                append( sb, "", 0 );

                append( sb, "locale", 2 );
                append( sb, "The locale used for date and time formatting. The locale name should be in the format defined in Locale.toString(). The default locale is the platform default returned by Locale.getDefault().", 3 );
                append( sb, "", 0 );

                append( sb, "password", 2 );
                append( sb, "The password that is used when connecting to the SCM system.", 3 );
                append( sb, "", 0 );

                append( sb, "revisionOnScmFailure", 2 );
                append( sb, "Setting this value allows the build to continue even in the event of an SCM failure. The value set will be used as the revision string in the event of a failure to retrieve the revision it from the SCM.", 3 );
                append( sb, "", 0 );

                append( sb, "scmDirectory (Default: ${basedir})", 2 );
                append( sb, "Local directory to be used to issue SCM actions", 3 );
                append( sb, "", 0 );

                append( sb, "tagBase", 2 );
                append( sb, "The tag base directory in subversion, you must define it if you don\'t use the standard svn layout (branches/tags/trunk).", 3 );
                append( sb, "", 0 );

                append( sb, "timestampFormat", 2 );
                append( sb, "Apply this java.text.MessageFormat to the timestamp only (as opposed to the format parameter).", 3 );
                append( sb, "", 0 );

                append( sb, "timestampPropertyName (Default: timestamp)", 2 );
                append( sb, "You can rename the timestamp property name to another property name if desired.", 3 );
                append( sb, "", 0 );

                append( sb, "useLastCommittedRevision (Default: false)", 2 );
                append( sb, "whether to retrieve the revision for the last commit, or the last revision of the repository.", 3 );
                append( sb, "", 0 );

                append( sb, "username", 2 );
                append( sb, "The username that is used when connecting to the SCM system.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "help".equals( goal ) )
        {
            append( sb, "buildnumber:help", 0 );
            append( sb, "Display help information on buildnumber-maven-plugin. Call\n\u00a0\u00a0mvn\u00a0buildnumber:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "detail (Default: false)", 2 );
                append( sb, "If true, display all settable properties for each goal.", 3 );
                append( sb, "", 0 );

                append( sb, "goal", 2 );
                append( sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3 );
                append( sb, "", 0 );

                append( sb, "lineLength (Default: 80)", 2 );
                append( sb, "The maximum length of a display line.", 3 );
                append( sb, "", 0 );

                append( sb, "indentSize (Default: 2)", 2 );
                append( sb, "The number of spaces per indentation level.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( getLog().isInfoEnabled() )
        {
            getLog().info( sb.toString() );
        }
    }

    /**
     * <p>Repeat a String <code>n</code> times to form a new string.</p>
     *
     * @param str String to repeat
     * @param repeat number of times to repeat str
     * @return String with repeated String
     * @throws NegativeArraySizeException if <code>repeat < 0</code>
     * @throws NullPointerException if str is <code>null</code>
     */
    private static String repeat( String str, int repeat )
    {
        StringBuffer buffer = new StringBuffer( repeat * str.length() );

        for ( int i = 0; i < repeat; i++ )
        {
            buffer.append( str );
        }

        return buffer.toString();
    }

    private void append( StringBuffer sb, String description, int indent )
    {
        for ( Iterator it = toLines( description, indent ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( '\n' );
        }
    }

    /** 
     * Splits the specified text into lines of convenient display length.
     * 
     * @param text The text to split into lines, must not be <code>null</code>.
     * @param indent The base indentation level of each line, must not be negative.
     * @return The sequence of display lines, never <code>null</code>.
     */
    private List toLines( String text, int indent )
    {
        List lines = new ArrayList();

        String ind = repeat( "\t", indent );
        String[] plainLines = text.split( "(\r\n)|(\r)|(\n)" );
        for ( int i = 0; i < plainLines.length; i++ )
        {
            toLines( lines, ind + plainLines[i] );
        }

        return lines;
    }

    /** 
     * Adds the specified line to the output sequence, performing line wrapping if necessary.
     * 
     * @param lines The sequence of display lines, must not be <code>null</code>.
     * @param line The line to add, must not be <code>null</code>.
     */
    private void toLines( List lines, String line )
    {
        int lineIndent = getIndentLevel( line );
        StringBuffer buf = new StringBuffer( 256 );
        String[] tokens = line.split( " +" );
        for ( int i = 0; i < tokens.length; i++ )
        {
            String token = tokens[i];
            if ( i > 0 )
            {
                if ( buf.length() + token.length() >= lineLength )
                {
                    lines.add( buf.toString() );
                    buf.setLength( 0 );
                    buf.append( repeat( " ", lineIndent * indentSize ) );
                }
                else
                {
                    buf.append( ' ' );
                }
            }
            for ( int j = 0; j < token.length(); j++ )
            {
                char c = token.charAt( j );
                if ( c == '\t' )
                {
                    buf.append( repeat( " ", indentSize - buf.length() % indentSize ) );
                }
                else if ( c == '\u00A0' )
                {
                    buf.append( ' ' );
                }
                else
                {
                    buf.append( c );
                }
            }
        }
        lines.add( buf.toString() );
    }

    /** 
     * Gets the indentation level of the specified line.
     * 
     * @param line The line whose indentation level should be retrieved, must not be <code>null</code>.
     * @return The indentation level of the line.
     */
    private static int getIndentLevel( String line )
    {
        int level = 0;
        for ( int i = 0; i < line.length() && line.charAt( i ) == '\t'; i++ )
        {
            level++;
        }
        for ( int i = level + 1; i <= level + 4 && i < line.length(); i++ )
        {
            if ( line.charAt( i ) == '\t' )
            {
                level++;
                break;
            }
        }
        return level;
    }
}
