/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.build;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class HelpMojo
extends AbstractMojo {
    private boolean detail;
    private String goal;
    private int lineLength;
    private int indentSize;

    public void execute() throws MojoExecutionException {
        StringBuffer sb = new StringBuffer();
        this.append(sb, "org.codehaus.mojo:buildnumber-maven-plugin:1.0-beta-2", 0);
        this.append(sb, "", 0);
        this.append(sb, "Build Number Maven Plugin 1.0-beta-2", 0);
        this.append(sb, "This plugin is designed to give you a build number. So when you might make 100 builds of version 1.0-SNAPSHOT, you can differentiate between them all.", 1);
        this.append(sb, "", 0);
        if (this.goal == null || this.goal.length() <= 0) {
            this.append(sb, "This plugin has 2 goals:", 0);
            this.append(sb, "", 0);
        }
        if (this.goal == null || this.goal.length() <= 0 || "create".equals(this.goal)) {
            this.append(sb, "buildnumber:create", 0);
            this.append(sb, "This mojo is designed to give you a build number. So when you might make 100 builds of version 1.0-SNAPSHOT, you can differentiate between them all. The build number is based on the revision number retrieved from scm. It only works with subversion, currently. This mojo can also check to make sure that you have checked everything into scm, before issuing the build number. That behaviour can be suppressed, and then the latest local build number is used. Build numbers are not reflected in your artifact's filename (automatically), but can be added to the metadata. You can access the build number in your pom with ${buildNumber}. You can also access ${timestamp}.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "buildNumberPropertiesFileLocation (Default: ${basedir}/buildNumber.properties)", 2);
                this.append(sb, "Properties file to be created when 'format' is not null and item has 'buildNumber'. See Usage for details", 3);
                this.append(sb, "", 0);
                this.append(sb, "buildNumberPropertyName (Default: buildNumber)", 2);
                this.append(sb, "You can rename the buildNumber property name to another property name if desired.", 3);
                this.append(sb, "", 0);
                this.append(sb, "doCheck (Default: false)", 2);
                this.append(sb, "If this is made true, we check for modified files, and if there are any, we fail the build. Note that this used to be inverted (skipCheck), but needed to be changed to allow releases to work. This corresponds to 'svn status'.", 3);
                this.append(sb, "", 0);
                this.append(sb, "doUpdate (Default: false)", 2);
                this.append(sb, "", 3);
                this.append(sb, "", 0);
                this.append(sb, "format", 2);
                this.append(sb, "Specify a message as specified by java.text.MessageFormat. This triggers 'items' configuration to be read", 3);
                this.append(sb, "", 0);
                this.append(sb, "items", 2);
                this.append(sb, "Specify the corresponding items for the format message, as specified by java.text.MessageFormat. Special item values are 'timestamp' and 'buildNumber/d*'.", 3);
                this.append(sb, "", 0);
                this.append(sb, "locale", 2);
                this.append(sb, "The locale used for date and time formatting. The locale name should be in the format defined in Locale.toString(). The default locale is the platform default returned by Locale.getDefault().", 3);
                this.append(sb, "", 0);
                this.append(sb, "password", 2);
                this.append(sb, "The password that is used when connecting to the SCM system.", 3);
                this.append(sb, "", 0);
                this.append(sb, "revisionOnScmFailure", 2);
                this.append(sb, "Setting this value allows the build to continue even in the event of an SCM failure. The value set will be used as the revision string in the event of a failure to retrieve the revision it from the SCM.", 3);
                this.append(sb, "", 0);
                this.append(sb, "scmDirectory (Default: ${basedir})", 2);
                this.append(sb, "Local directory to be used to issue SCM actions", 3);
                this.append(sb, "", 0);
                this.append(sb, "tagBase", 2);
                this.append(sb, "The tag base directory in subversion, you must define it if you don't use the standard svn layout (branches/tags/trunk).", 3);
                this.append(sb, "", 0);
                this.append(sb, "timestampFormat", 2);
                this.append(sb, "Apply this java.text.MessageFormat to the timestamp only (as opposed to the format parameter).", 3);
                this.append(sb, "", 0);
                this.append(sb, "timestampPropertyName (Default: timestamp)", 2);
                this.append(sb, "You can rename the timestamp property name to another property name if desired.", 3);
                this.append(sb, "", 0);
                this.append(sb, "useLastCommittedRevision (Default: false)", 2);
                this.append(sb, "whether to retrieve the revision for the last commit, or the last revision of the repository.", 3);
                this.append(sb, "", 0);
                this.append(sb, "username", 2);
                this.append(sb, "The username that is used when connecting to the SCM system.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "help".equals(this.goal)) {
            this.append(sb, "buildnumber:help", 0);
            this.append(sb, "Display help information on buildnumber-maven-plugin. Call\n\u00a0\u00a0mvn\u00a0buildnumber:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "detail (Default: false)", 2);
                this.append(sb, "If true, display all settable properties for each goal.", 3);
                this.append(sb, "", 0);
                this.append(sb, "goal", 2);
                this.append(sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3);
                this.append(sb, "", 0);
                this.append(sb, "lineLength (Default: 80)", 2);
                this.append(sb, "The maximum length of a display line.", 3);
                this.append(sb, "", 0);
                this.append(sb, "indentSize (Default: 2)", 2);
                this.append(sb, "The number of spaces per indentation level.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)sb.toString());
        }
    }

    private static String repeat(String str, int repeat) {
        StringBuffer buffer = new StringBuffer(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    private void append(StringBuffer sb, String description, int indent) {
        Iterator it = this.toLines(description, indent).iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append('\n');
        }
    }

    private List toLines(String text, int indent) {
        ArrayList lines = new ArrayList();
        String ind = HelpMojo.repeat("\t", indent);
        String[] plainLines = text.split("(\r\n)|(\r)|(\n)");
        for (int i = 0; i < plainLines.length; ++i) {
            this.toLines(lines, ind + plainLines[i]);
        }
        return lines;
    }

    private void toLines(List lines, String line) {
        int lineIndent = HelpMojo.getIndentLevel(line);
        StringBuffer buf = new StringBuffer(256);
        String[] tokens = line.split(" +");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (i > 0) {
                if (buf.length() + token.length() >= this.lineLength) {
                    lines.add(buf.toString());
                    buf.setLength(0);
                    buf.append(HelpMojo.repeat(" ", lineIndent * this.indentSize));
                } else {
                    buf.append(' ');
                }
            }
            for (int j = 0; j < token.length(); ++j) {
                char c = token.charAt(j);
                if (c == '\t') {
                    buf.append(HelpMojo.repeat(" ", this.indentSize - buf.length() % this.indentSize));
                    continue;
                }
                if (c == '\u00a0') {
                    buf.append(' ');
                    continue;
                }
                buf.append(c);
            }
        }
        lines.add(buf.toString());
    }

    private static int getIndentLevel(String line) {
        int i;
        int level = 0;
        for (i = 0; i < line.length() && line.charAt(i) == '\t'; ++i) {
            ++level;
        }
        for (i = level + 1; i <= level + 4 && i < line.length(); ++i) {
            if (line.charAt(i) != '\t') continue;
            ++level;
            break;
        }
        return level;
    }
}

