/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.build;

import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.build.Utils;

@Mojo(name="create-timestamp", defaultPhase=LifecyclePhase.INITIALIZE, requiresProject=true, threadSafe=true)
public class CreateTimestampMojo
extends AbstractMojo {
    @Parameter(property="maven.buildNumber.skip", defaultValue="false")
    private boolean skip;
    @Parameter(defaultValue="${session}", required=true, readonly=true)
    private MavenSession session;
    @Parameter(property="maven.buildNumber.timestampPropertyName", defaultValue="timestamp")
    private String timestampPropertyName;
    @Parameter(property="maven.buildNumber.timestampFormat", defaultValue="")
    private String timestampFormat;
    @Parameter(property="maven.buildNumber.timestampTimeZone", defaultValue="")
    private String timezone;
    @Parameter(defaultValue="false")
    private boolean executeRootOnly;

    public void execute() {
        String timestampString;
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping execution.");
            return;
        }
        if (this.session.getCurrentProject().isExecutionRoot() && !this.executeRootOnly) {
            this.getLog().info((CharSequence)"Skipping because we are not in root module.");
        }
        if ((timestampString = this.session.getTopLevelProject().getProperties().getProperty(this.timestampPropertyName)) != null) {
            this.getLog().debug((CharSequence)"Using previously created timestamp.");
            return;
        }
        timestampString = Utils.createTimestamp(this.timestampFormat, this.timezone);
        this.getLog().debug((CharSequence)("Storing timestamp property: " + this.timestampPropertyName + " " + timestampString));
        for (MavenProject project : this.session.getProjectDependencyGraph().getSortedProjects()) {
            this.getLog().debug((CharSequence)("Storing timestamp property in project " + project.getId()));
            project.getProperties().setProperty(this.timestampPropertyName, timestampString);
        }
    }
}

