/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.buildplan;

import java.util.Locale;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.lifecycle.DefaultLifecycles;
import org.apache.maven.lifecycle.LifecycleExecutor;
import org.apache.maven.lifecycle.MavenExecutionPlan;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.reporting.AbstractMavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.mojo.buildplan.display.MojoExecutionDisplay;
import org.codehaus.mojo.buildplan.display.PlainTextMojoExecutionDisplay;
import org.codehaus.mojo.buildplan.display.TableColumn;

@Mojo(name="report", defaultPhase=LifecyclePhase.SITE)
public class ReportMojo
extends AbstractMavenReport {
    @Component
    private LifecycleExecutor lifecycleExecutor;
    @Component(role=DefaultLifecycles.class)
    DefaultLifecycles defaultLifecycles;
    @Parameter(defaultValue="${session}", readonly=true)
    private MavenSession session;

    protected void executeReport(Locale locale) throws MavenReportException {
        MavenExecutionPlan plan;
        try {
            plan = this.calculateExecutionPlan();
        }
        catch (MojoFailureException e) {
            throw new MavenReportException("Cannot calculate execution plan...", (Exception)((Object)e));
        }
        Log logger = this.getLog();
        logger.info((CharSequence)("Generating " + this.getOutputName() + ".html for " + this.project.getName() + " " + this.project.getVersion()));
        Sink mainSink = this.getSink();
        if (mainSink == null) {
            throw new MavenReportException("Could not get the Doxia sink");
        }
        mainSink.head();
        mainSink.title();
        mainSink.text("Build Plan for " + this.project.getName() + " " + this.project.getVersion());
        mainSink.title_();
        mainSink.head_();
        mainSink.body();
        mainSink.header();
        mainSink.rawText("<h1 id=\"titleContent\">" + this.getDescription(locale) + "</h1>");
        mainSink.header_();
        mainSink.table();
        mainSink.tableRow();
        this.tableHead(mainSink, TableColumn.LIFECYCLE);
        this.tableHead(mainSink, TableColumn.PHASE);
        this.tableHead(mainSink, TableColumn.ARTIFACT_ID);
        this.tableHead(mainSink, TableColumn.GOAL);
        this.tableHead(mainSink, TableColumn.EXECUTION_ID);
        mainSink.tableRow_();
        for (MojoExecution execution : plan.getMojoExecutions()) {
            PlainTextMojoExecutionDisplay display = new PlainTextMojoExecutionDisplay(execution);
            mainSink.tableRow();
            this.tableCell(mainSink, display.getLifecycle(this.defaultLifecycles));
            this.tableCell(mainSink, display.getPhase());
            this.tableCell(mainSink, ((MojoExecutionDisplay)display).getArtifactId());
            this.tableCell(mainSink, display.getGoal());
            this.tableCell(mainSink, display.getExecutionId());
            mainSink.tableRow_();
        }
        mainSink.table_();
        mainSink.body_();
    }

    private void tableCell(Sink mainSink, String content) {
        mainSink.tableCell();
        mainSink.text(content);
        mainSink.tableCell_();
    }

    private void tableHead(Sink mainSink, TableColumn lifecycle) {
        mainSink.tableHeaderCell();
        mainSink.text(lifecycle.title());
        mainSink.tableHeaderCell_();
    }

    public String getOutputName() {
        return "buildplan-report";
    }

    public String getName(Locale locale) {
        return "Build Plan";
    }

    public String getDescription(Locale locale) {
        return "List plugin executions for " + this.currentProject();
    }

    private String currentProject() {
        return this.session.getCurrentProject().getGroupId() + ":" + this.session.getCurrentProject().getArtifactId();
    }

    protected MavenExecutionPlan calculateExecutionPlan() throws MojoFailureException {
        try {
            return this.lifecycleExecutor.calculateExecutionPlan(this.session, new String[]{"deploy"});
        }
        catch (Exception e) {
            throw new MojoFailureException(String.format("Cannot calculate Maven execution plan, caused by: %s", e.getMessage()), (Throwable)e);
        }
    }
}

