/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.buildplan.display;

import java.util.Collection;
import java.util.Map;
import org.apache.maven.lifecycle.DefaultLifecycles;
import org.apache.maven.plugin.MojoExecution;
import org.codehaus.mojo.buildplan.display.AbstractTableDescriptor;
import org.codehaus.mojo.buildplan.display.TableColumn;

public class ListPluginTableDescriptor
extends AbstractTableDescriptor {
    private static final int SEPARATOR_SIZE = "    + ".length() + 2 * " | ".length();
    private int phaseSize;
    private int executionIdSize;
    private int goalSize;

    @Override
    public String rowFormat() {
        StringBuilder builder = new StringBuilder();
        builder.append("    + ").append("%-").append(this.getPhaseSize()).append(FORMAT_STRING).append(" | ").append("%-").append(this.getGoalSize()).append(FORMAT_STRING).append(" | ").append("%-").append(this.getExecutionIdSize()).append(FORMAT_STRING);
        return builder.toString();
    }

    @Override
    public int width() {
        return this.getExecutionIdSize() + this.getGoalSize() + this.getPhaseSize() + SEPARATOR_SIZE;
    }

    public int getPhaseSize() {
        return this.phaseSize;
    }

    public int getExecutionIdSize() {
        return this.executionIdSize;
    }

    public int getGoalSize() {
        return this.goalSize;
    }

    public ListPluginTableDescriptor setPhaseSize(int phaseSize) {
        this.phaseSize = phaseSize;
        return this;
    }

    public ListPluginTableDescriptor setExecutionIdSize(int executionIdSize) {
        this.executionIdSize = executionIdSize;
        return this;
    }

    public ListPluginTableDescriptor setGoalSize(int goalSize) {
        this.goalSize = goalSize;
        return this;
    }

    public static ListPluginTableDescriptor of(Collection<MojoExecution> executions, DefaultLifecycles defaultLifecycles) {
        Map<TableColumn, Integer> maxSize = ListPluginTableDescriptor.findMaxSize(executions, defaultLifecycles, TableColumn.PHASE, TableColumn.EXECUTION_ID, TableColumn.GOAL);
        return new ListPluginTableDescriptor().setPhaseSize(maxSize.get((Object)TableColumn.PHASE)).setGoalSize(maxSize.get((Object)TableColumn.GOAL)).setExecutionIdSize(maxSize.get((Object)TableColumn.EXECUTION_ID));
    }
}

