/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.buildplan.display;

import org.apache.maven.lifecycle.DefaultLifecycles;
import org.apache.maven.lifecycle.Lifecycle;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.codehaus.mojo.buildplan.display.MavenPluginPatterns;
import org.codehaus.plexus.util.StringUtils;

public class MojoExecutionDisplay {
    protected final MojoExecution execution;

    public MojoExecutionDisplay(MojoExecution execution) {
        this.execution = execution;
    }

    public String getPhase() {
        MojoDescriptor mojoDescriptor = this.execution.getMojoDescriptor();
        if (mojoDescriptor != null && mojoDescriptor.getPhase() != null) {
            return mojoDescriptor.getPhase();
        }
        return StringUtils.defaultString((Object)this.execution.getLifecyclePhase());
    }

    public String getLifecycle(DefaultLifecycles defaultLifecycles) {
        Lifecycle lifecycle = defaultLifecycles.get(this.execution.getLifecyclePhase());
        return StringUtils.defaultString((Object)(lifecycle == null ? null : lifecycle.getId()));
    }

    public String getArtifactId() {
        if (this.execution.getArtifactId() == null) {
            return "";
        }
        return MavenPluginPatterns.mayHighlightPrefix(this.execution.getArtifactId());
    }

    public String getVersion() {
        return StringUtils.defaultString((Object)this.execution.getVersion());
    }

    public String getGoal() {
        return StringUtils.defaultString((Object)this.execution.getGoal());
    }

    public String getExecutionId() {
        return StringUtils.defaultString((Object)this.execution.getExecutionId());
    }
}

