/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.cassandra;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.thrift.Cassandra;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecuteResultHandler;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteException;
import org.apache.commons.exec.ExecuteResultHandler;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.ProcessDestroyer;
import org.apache.commons.exec.PumpStreamHandler;
import org.apache.commons.exec.ShutdownHookProcessDestroyer;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TFramedTransport;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.codehaus.mojo.cassandra.MavenLogOutputStream;
import org.codehaus.mojo.cassandra.ThriftApiExecutionException;
import org.codehaus.mojo.cassandra.ThriftApiOperation;
import org.codehaus.plexus.util.StringUtils;
import org.yaml.snakeyaml.Yaml;

public final class Utils {
    private Utils() {
        throw new IllegalAccessError("Utility class");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void stopCassandraServer(String rpcAddress, int rpcPort, String stopAddress, int stopPort, String stopKey, Log log) {
        try {
            Socket s = new Socket(InetAddress.getByName(stopAddress), stopPort);
            s.setSoLinger(false, 0);
            OutputStream out = s.getOutputStream();
            out.write((stopKey + "\r\nstop\r\n").getBytes());
            out.flush();
            s.close();
        }
        catch (ConnectException e) {
            log.info((CharSequence)"Cassandra not running!");
            return;
        }
        catch (Exception e) {
            log.error((Throwable)e);
            return;
        }
        log.info((CharSequence)"Waiting for Cassandra to stop...");
        long maxWaiting = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(30L);
        boolean stopped = false;
        while (!stopped && System.currentTimeMillis() < maxWaiting) {
            TFramedTransport tr = new TFramedTransport((TTransport)new TSocket(rpcAddress, rpcPort));
            TBinaryProtocol proto = new TBinaryProtocol((TTransport)tr);
            Cassandra.Client client = new Cassandra.Client((TProtocol)proto);
            try {
                tr.open();
            }
            catch (TTransportException e) {
                if (e.getCause() instanceof ConnectException) {
                    stopped = true;
                    if (!tr.isOpen()) continue;
                    tr.close();
                    continue;
                }
                try {
                    log.debug((CharSequence)e.getLocalizedMessage(), (Throwable)e);
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e1) {
                        // empty catch block
                    }
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (!tr.isOpen()) continue;
                    tr.close();
                }
            }
        }
        if (stopped) {
            log.info((CharSequence)"Cassandra has stopped.");
        } else {
            log.warn((CharSequence)"Gave up waiting for Cassandra to stop.");
        }
    }

    protected static DefaultExecuteResultHandler startCassandraServer(File cassandraDir, CommandLine commandLine, Map environment, Log log) throws MojoExecutionException {
        try {
            DefaultExecutor exec = new DefaultExecutor();
            DefaultExecuteResultHandler execHandler = new DefaultExecuteResultHandler();
            exec.setWorkingDirectory(cassandraDir);
            exec.setProcessDestroyer((ProcessDestroyer)new ShutdownHookProcessDestroyer());
            MavenLogOutputStream stdout = new MavenLogOutputStream(log);
            MavenLogOutputStream stderr = new MavenLogOutputStream(log);
            log.debug((CharSequence)("Executing command line: " + commandLine));
            exec.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler((OutputStream)((Object)stdout), (OutputStream)((Object)stderr)));
            exec.execute(commandLine, environment, (ExecuteResultHandler)execHandler);
            return execHandler;
        }
        catch (ExecuteException e) {
            throw new MojoExecutionException("Command execution failed.", (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Command execution failed.", (Exception)e);
        }
    }

    static boolean shouldGenerateResource(MavenProject project, File resource) {
        if (!resource.isFile()) {
            return true;
        }
        long resourceLM = resource.lastModified();
        long projectLM = project.getFile().lastModified();
        if (Long.signum(resourceLM) == Long.signum(projectLM)) {
            return resourceLM < projectLM;
        }
        return true;
    }

    public static String merge(String baseYaml, String glossYaml) {
        if (StringUtils.isBlank((String)glossYaml)) {
            return baseYaml;
        }
        if (StringUtils.isBlank((String)baseYaml)) {
            return glossYaml;
        }
        Yaml yaml = new Yaml();
        Map baseMap = (Map)yaml.load(baseYaml);
        Map glossMap = (Map)yaml.load(glossYaml);
        for (Map.Entry glossEntry : glossMap.entrySet()) {
            baseMap.put(glossEntry.getKey(), glossEntry.getValue());
        }
        return yaml.dump((Object)baseMap);
    }

    static boolean waitUntilStarted(String rpcAddress, int rpcPort, int startWaitSeconds, Log log) throws MojoExecutionException {
        long maxWaiting = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(startWaitSeconds);
        while (startWaitSeconds == 0 || System.currentTimeMillis() < maxWaiting) {
            TFramedTransport tr = new TFramedTransport((TTransport)new TSocket(rpcAddress, rpcPort));
            TBinaryProtocol proto = new TBinaryProtocol((TTransport)tr);
            Cassandra.Client client = new Cassandra.Client((TProtocol)proto);
            try {
                tr.open();
            }
            catch (TTransportException e) {
                if (!(e.getCause() instanceof ConnectException)) {
                    log.debug((CharSequence)e.getLocalizedMessage(), (Throwable)e);
                }
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e1) {
                    // empty catch block
                }
                if (!tr.isOpen()) continue;
                tr.close();
                continue;
            }
            try {
                log.info((CharSequence)("Cassandra cluster \"" + client.describe_cluster_name() + "\" started."));
                boolean e = true;
                return e;
            }
            catch (TException e) {
                throw new MojoExecutionException(e.getLocalizedMessage(), (Exception)((Object)e));
            }
            finally {
                if (tr.isOpen()) {
                    tr.close();
                }
            }
        }
        return false;
    }

    public static void executeThrift(ThriftApiOperation thriftApiOperation) throws MojoExecutionException {
        TSocket socket = new TSocket(thriftApiOperation.getRpcAddress(), thriftApiOperation.getRpcPort());
        TFramedTransport transport = new TFramedTransport((TTransport)socket);
        TBinaryProtocol binaryProtocol = new TBinaryProtocol((TTransport)transport, true, true);
        Cassandra.Client cassandraClient = new Cassandra.Client((TProtocol)binaryProtocol);
        try {
            transport.open();
            if (StringUtils.isNotBlank((String)thriftApiOperation.getKeyspace())) {
                cassandraClient.set_keyspace(thriftApiOperation.getKeyspace());
            }
            cassandraClient.set_cql_version(thriftApiOperation.getCqlVersion());
            thriftApiOperation.executeOperation(cassandraClient);
        }
        catch (ThriftApiExecutionException taee) {
            throw new MojoExecutionException("API Exception calling Apache Cassandra", (Exception)taee);
        }
        catch (Exception ex) {
            throw new MojoExecutionException("General exception from Thrift", ex);
        }
        finally {
            if (transport != null && transport.isOpen()) {
                try {
                    transport.flush();
                    transport.close();
                }
                catch (Exception e) {
                    throw new MojoExecutionException("Something went wrong cleaning up", e);
                }
            }
        }
    }
}

