/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.cassandra;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.cassandra.thrift.Cassandra;
import org.apache.cassandra.thrift.Compression;
import org.apache.cassandra.thrift.ConsistencyLevel;
import org.apache.cassandra.thrift.CqlResult;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.mojo.cassandra.AbstractCassandraMojo;
import org.codehaus.mojo.cassandra.ThriftApiExecutionException;
import org.codehaus.mojo.cassandra.ThriftApiOperation;
import org.codehaus.mojo.cassandra.Utils;
import org.codehaus.plexus.util.IOUtil;

public abstract class AbstractCqlExecMojo
extends AbstractCassandraMojo {
    private String cqlVersion = "3.4.0";

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String readFile(File file) throws MojoExecutionException {
        String string;
        if (!file.isFile()) {
            throw new MojoExecutionException("script " + file + " does not exist.");
        }
        FileReader fr = null;
        try {
            fr = new FileReader(file);
            string = IOUtil.toString((Reader)fr);
        }
        catch (FileNotFoundException e) {
            try {
                throw new MojoExecutionException("Cql file '" + file + "' was deleted before I could read it", (Exception)e);
                catch (IOException e2) {
                    throw new MojoExecutionException("Could not parse or load cql file", (Exception)e2);
                }
            }
            catch (Throwable throwable) {
                IOUtil.close(fr);
                throw throwable;
            }
        }
        IOUtil.close((Reader)fr);
        return string;
    }

    protected List<CqlResult> executeCql(String statements) throws MojoExecutionException {
        ArrayList<CqlResult> results = new ArrayList<CqlResult>();
        if (StringUtils.isBlank((String)statements)) {
            this.getLog().warn((CharSequence)"No CQL provided. Nothing to do.");
        } else {
            try {
                CqlExecOperation operation = new CqlExecOperation(statements);
                Utils.executeThrift(operation);
                results.addAll(operation.results);
            }
            catch (ThriftApiExecutionException taee) {
                throw new MojoExecutionException(taee.getMessage(), (Exception)taee);
            }
        }
        return results;
    }

    private class CqlExecOperation
    extends ThriftApiOperation {
        private final List<CqlResult> results;
        private final String[] statements;

        private CqlExecOperation(String statements) {
            super(AbstractCqlExecMojo.this.rpcAddress, AbstractCqlExecMojo.this.rpcPort);
            this.results = new ArrayList<CqlResult>();
            this.statements = statements.split(";");
            if (StringUtils.isNotBlank((String)AbstractCqlExecMojo.this.keyspace)) {
                AbstractCqlExecMojo.this.getLog().info((CharSequence)("setting keyspace: " + AbstractCqlExecMojo.this.keyspace));
                this.setKeyspace(AbstractCqlExecMojo.this.keyspace);
            }
            AbstractCqlExecMojo.this.getLog().info((CharSequence)("setting cqlversion: " + AbstractCqlExecMojo.this.cqlVersion));
            this.setCqlVersion(AbstractCqlExecMojo.this.cqlVersion);
        }

        @Override
        void executeOperation(Cassandra.Client client) throws ThriftApiExecutionException {
            for (String statement : this.statements) {
                if (!StringUtils.isNotBlank((String)statement)) continue;
                this.results.add(this.executeStatement(client, statement));
            }
        }

        private CqlResult executeStatement(Cassandra.Client client, String statement) throws ThriftApiExecutionException {
            ByteBuffer buf = ByteBufferUtil.bytes((String)statement);
            try {
                if (AbstractCqlExecMojo.this.cqlVersion.charAt(0) >= '3') {
                    return client.execute_cql3_query(buf, Compression.NONE, ConsistencyLevel.ONE);
                }
                return client.execute_cql_query(buf, Compression.NONE);
            }
            catch (Exception e) {
                AbstractCqlExecMojo.this.getLog().debug((CharSequence)statement);
                throw new ThriftApiExecutionException(e);
            }
        }
    }
}

