/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.cassandra;

import java.io.File;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.cassandraunit.DataLoader;
import org.cassandraunit.dataset.DataSet;
import org.cassandraunit.dataset.FileDataSet;
import org.cassandraunit.dataset.ParseException;
import org.codehaus.mojo.cassandra.AbstractCassandraMojo;

public class LoadCassandraUnitDataSetMojo
extends AbstractCassandraMojo {
    protected File cuDataSet;
    private boolean cuLoadFailureIgnore;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping cassandra: cassandra.skip==true");
            return;
        }
        if (!this.cuDataSet.isFile()) {
            if (this.cuLoadFailureIgnore) {
                this.getLog().error((CharSequence)("CassandraUnit dataSet " + this.cuDataSet + " does not exist.. Ignoring as cuLoadFailureIgnore is true"));
                return;
            }
            throw new MojoFailureException("CassandraUnit dataSet " + this.cuDataSet + " does not exist.");
        }
        try {
            DataLoader dataLoader = new DataLoader("cassandraUnitCluster", this.rpcAddress + ":" + this.rpcPort);
            dataLoader.load((DataSet)new FileDataSet(this.cuDataSet.getAbsolutePath()));
        }
        catch (ParseException e) {
            if (this.cuLoadFailureIgnore) {
                this.getLog().error((CharSequence)(e.getMessage() + ". Ignoring as cuLoadFailureIgnore is true"));
            }
            throw new MojoExecutionException("Error while loading CassandraUnit dataSet", (Exception)((Object)e));
        }
    }
}

