/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.cassandra;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.Token;
import org.apache.cassandra.cql3.CqlLexer;
import org.apache.cassandra.thrift.Cassandra;
import org.apache.cassandra.thrift.Compression;
import org.apache.cassandra.thrift.ConsistencyLevel;
import org.apache.cassandra.thrift.CqlResult;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.mojo.cassandra.AbstractCassandraMojo;
import org.codehaus.mojo.cassandra.ThriftApiExecutionException;
import org.codehaus.mojo.cassandra.ThriftApiOperation;
import org.codehaus.mojo.cassandra.Utils;
import org.codehaus.plexus.util.IOUtil;

public abstract class AbstractCqlExecMojo
extends AbstractCassandraMojo {
    @Parameter(property="cql.version", defaultValue="3.11.12")
    private String cqlVersion = "3.11.12";
    @Parameter(property="cql.encoding")
    protected String cqlEncoding = Charset.defaultCharset().name();
    @Parameter(defaultValue="false")
    protected boolean useCqlLexer = false;

    protected String readFile(File file) throws MojoExecutionException {
        String string;
        if (!file.isFile() || !file.exists()) {
            throw new MojoExecutionException("script " + file + " does not exist.");
        }
        InputStreamReader r = new InputStreamReader((InputStream)new FileInputStream(file), this.cqlEncoding);
        try {
            string = IOUtil.toString((Reader)r);
        }
        catch (Throwable throwable) {
            try {
                try {
                    r.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (FileNotFoundException e) {
                throw new MojoExecutionException("Cql file '" + file + "' was deleted before I could read it", (Exception)e);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Could not parse or load cql file", (Exception)e);
            }
        }
        r.close();
        return string;
    }

    protected List<CqlResult> executeCql(String statements) throws MojoExecutionException {
        ArrayList<CqlResult> results = new ArrayList<CqlResult>();
        if (StringUtils.isBlank((String)statements)) {
            this.getLog().warn((CharSequence)"No CQL provided. Nothing to do.");
        } else {
            try {
                CqlExecOperation operation = new CqlExecOperation(statements);
                Utils.executeThrift(operation);
                results.addAll(operation.results);
            }
            catch (ThriftApiExecutionException taee) {
                throw new MojoExecutionException(taee.getMessage(), (Exception)taee);
            }
        }
        return results;
    }

    protected static List<String> splitStatementsUsingCqlLexer(String statements) {
        ANTLRStringStream stream = new ANTLRStringStream(statements);
        CqlLexer lexer = new CqlLexer((CharStream)stream);
        ArrayList<String> statementList = new ArrayList<String>();
        StringBuilder currentStatement = new StringBuilder();
        Token token = lexer.nextToken();
        while (token.getType() != -1) {
            if (token.getText().equals(";")) {
                currentStatement.append(";");
                statementList.add(currentStatement.toString());
                currentStatement = new StringBuilder();
            } else if (token.getType() == 176) {
                currentStatement.append("'");
                currentStatement.append(token.getText().replaceAll("'", "''"));
                currentStatement.append("'");
            } else if (token.getType() != 8) {
                currentStatement.append(token.getText());
            }
            token = lexer.nextToken();
        }
        if (currentStatement.length() > 0 && currentStatement.toString().trim().length() > 0) {
            statementList.add(currentStatement.toString());
        }
        return statementList;
    }

    private class CqlExecOperation
    extends ThriftApiOperation {
        private final List<CqlResult> results;
        private final List<String> statements;

        private CqlExecOperation(String statements) {
            super(AbstractCqlExecMojo.this.rpcAddress, AbstractCqlExecMojo.this.rpcPort);
            this.results = new ArrayList<CqlResult>();
            if (AbstractCqlExecMojo.this.useCqlLexer) {
                AbstractCqlExecMojo.this.getLog().warn((CharSequence)"Using CqlLexer has not been extensively tested");
                this.statements = AbstractCqlExecMojo.splitStatementsUsingCqlLexer(statements);
            } else {
                this.statements = Arrays.asList(statements.split(";"));
            }
            if (StringUtils.isNotBlank((String)AbstractCqlExecMojo.this.keyspace)) {
                AbstractCqlExecMojo.this.getLog().info((CharSequence)("setting keyspace: " + AbstractCqlExecMojo.this.keyspace));
                this.setKeyspace(AbstractCqlExecMojo.this.keyspace);
            }
            AbstractCqlExecMojo.this.getLog().info((CharSequence)("setting cqlversion: " + AbstractCqlExecMojo.this.cqlVersion));
            this.setCqlVersion(AbstractCqlExecMojo.this.cqlVersion);
        }

        @Override
        void executeOperation(Cassandra.Client client) throws ThriftApiExecutionException {
            for (String statement : this.statements) {
                if (!StringUtils.isNotBlank((String)statement)) continue;
                if (AbstractCqlExecMojo.this.getLog().isDebugEnabled()) {
                    AbstractCqlExecMojo.this.getLog().debug((CharSequence)("Executing cql statement: " + statement));
                }
                this.results.add(this.executeStatement(client, statement));
            }
        }

        private CqlResult executeStatement(Cassandra.Client client, String statement) throws ThriftApiExecutionException {
            ByteBuffer buf = ByteBufferUtil.bytes((String)statement);
            try {
                if (AbstractCqlExecMojo.this.cqlVersion.charAt(0) >= '3') {
                    return client.execute_cql3_query(buf, Compression.NONE, ConsistencyLevel.ONE);
                }
                return client.execute_cql_query(buf, Compression.NONE);
            }
            catch (Exception e) {
                AbstractCqlExecMojo.this.getLog().debug((CharSequence)statement);
                throw new ThriftApiExecutionException(e);
            }
        }
    }
}

