/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.cassandra;

import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.FileUtils;

@Mojo(name="delete", threadSafe=true)
public class DeleteCassandraMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project.build.directory}/cassandra")
    protected File cassandraDir;
    @Parameter(property="cassandra.skip", defaultValue="false")
    private boolean skip;
    @Parameter(property="cassandra.failOnError", defaultValue="true")
    protected boolean failOnError;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping cassandra: cassandra.skip==true");
            return;
        }
        try {
            this.getLog().info((CharSequence)("Deleting " + this.cassandraDir.getAbsolutePath()));
            FileUtils.deleteDirectory((File)this.cassandraDir);
        }
        catch (IOException e) {
            if (this.failOnError) {
                throw new MojoFailureException(e.getLocalizedMessage(), (Throwable)e);
            }
            this.getLog().warn((CharSequence)("Failed to delete " + this.cassandraDir.getAbsolutePath()), (Throwable)e);
        }
    }
}

