/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.castor;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.exolab.castor.builder.FieldInfoFactory;
import org.exolab.castor.builder.SourceGenerator;
import org.exolab.castor.builder.binding.ExtendedBinding;
import org.exolab.castor.util.LocalConfiguration;
import org.exolab.castor.xml.XMLException;
import org.exolab.castor.xml.schema.Schema;
import org.exolab.castor.xml.schema.reader.ComponentReader;
import org.exolab.castor.xml.schema.reader.Sax2ComponentReader;
import org.exolab.castor.xml.schema.reader.SchemaUnmarshaller;
import org.xml.sax.DocumentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;

class CastorSourceGenerator
extends SourceGenerator {
    private Log log;
    private FieldInfoFactory fieldInfoFactory;
    private boolean verbose;

    public CastorSourceGenerator() {
        this(new FieldInfoFactory());
    }

    public CastorSourceGenerator(FieldInfoFactory fieldInfoFactory) {
        super(fieldInfoFactory);
        this.fieldInfoFactory = fieldInfoFactory;
    }

    public CastorSourceGenerator(FieldInfoFactory fieldInfoFactory, ExtendedBinding extendedBinding) {
        super(fieldInfoFactory, extendedBinding);
        this.fieldInfoFactory = fieldInfoFactory;
    }

    public void generateSource(InputSource source, String packageName) throws IOException {
        Parser parser = null;
        try {
            parser = LocalConfiguration.getInstance().getParser();
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Unable to create SAX parser.", e);
        }
        if (parser == null) {
            throw new RuntimeException("Unable to create SAX parser.");
        }
        SchemaUnmarshaller schemaUnmarshaller = null;
        try {
            schemaUnmarshaller = new SchemaUnmarshaller();
        }
        catch (XMLException e) {
            throw new RuntimeException("Unable to create schema unmarshaller.", e);
        }
        Sax2ComponentReader handler = new Sax2ComponentReader((ComponentReader)schemaUnmarshaller);
        parser.setDocumentHandler((DocumentHandler)handler);
        parser.setErrorHandler((ErrorHandler)handler);
        try {
            parser.parse(source);
        }
        catch (IOException e) {
            throw new RuntimeException("Can't read input file " + source.getSystemId() + ".\n" + e, e);
        }
        catch (SAXException e) {
            throw new RuntimeException("Can't parse input file " + source.getSystemId() + ".\n" + e, e);
        }
        Schema schema = schemaUnmarshaller.getSchema();
        if (packageName == null && schema.getTargetNamespace() != null && "".equals(packageName = this.lookupPackageByNamespace(schema.getTargetNamespace()))) {
            packageName = null;
        }
        this.generateSource(schema, packageName);
    }

    public static CastorSourceGenerator createSourceGenerator(String types) throws MojoExecutionException {
        CastorSourceGenerator sgen;
        if (types != null) {
            try {
                String typ = "j2".equals(types) ? "arraylist" : types;
                FieldInfoFactory factory = new FieldInfoFactory(typ);
                sgen = new CastorSourceGenerator(factory);
            }
            catch (Exception e) {
                try {
                    sgen = new CastorSourceGenerator((FieldInfoFactory)Class.forName(types).newInstance());
                }
                catch (Exception e2) {
                    throw new MojoExecutionException("Invalid types \"" + types + "\": " + e.getMessage());
                }
            }
        } else {
            sgen = new CastorSourceGenerator();
        }
        return sgen;
    }

    public void setLog(Log log) {
        this.log = log;
    }

    public Log getLog() {
        return this.log;
    }

    public void log(String msg) {
        this.getLog().info((CharSequence)msg);
    }

    public void verbose(String msg) {
        if (this.verbose) {
            this.getLog().info((CharSequence)msg);
        }
    }

    public void setLineSeparatorStyle(String lineSeparator) throws MojoExecutionException {
        String lineSep = System.getProperty("line.separator");
        if (lineSeparator != null) {
            if ("win".equals(lineSeparator)) {
                this.log("Using Windows style line separation.");
                lineSep = "\r\n";
            } else if ("unix".equals(lineSeparator)) {
                this.log("Using UNIX style line separation.");
                lineSep = "\n";
            } else if ("mac".equals(lineSeparator)) {
                this.log("Using Macintosh style line separation.");
                lineSep = "\r";
            } else {
                throw new MojoExecutionException("Invalid value for lineseparator, must be win, unix, or mac.");
            }
        }
        this.setLineSeparator(lineSep);
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
        super.setVerbose(verbose);
    }

    public void setBindingFile(String bindingFile) {
        if (bindingFile != null && new File(bindingFile).exists()) {
            this.setBinding(bindingFile);
        }
    }

    public void setBuilderProperties(String properties) throws MojoExecutionException {
        if (properties != null) {
            String suffix;
            String filePath = new File(properties).getAbsolutePath();
            Properties customProperties = new Properties();
            try {
                customProperties.load(new FileInputStream(filePath));
            }
            catch (FileNotFoundException e) {
                throw new MojoExecutionException("Properties file \"" + filePath + "\" not found");
            }
            catch (IOException e) {
                throw new MojoExecutionException("Can't read properties file \"" + filePath + "\": " + e);
            }
            this.setDefaultProperties(customProperties);
            if (this.generateExtraCollectionMethods()) {
                this.verbose("Overriding default castorbuilder.properties and setting createExtraMethods to true");
                this.fieldInfoFactory.setCreateExtraMethods(true);
            }
            if ((suffix = this.getProperty("org.exolab.castor.builder.collections.reference.suffix", null)) != null) {
                this.verbose("Overriding default castorbuilder.properties and setting referenceSuffixProperty to " + suffix);
            }
            this.fieldInfoFactory.setReferenceMethodSuffix(suffix);
            if (this.boundPropertiesEnabled()) {
                this.verbose("Overriding default castorbuilder.properties and setting boundProperties to true");
                this.fieldInfoFactory.setBoundProperties(true);
            }
        }
    }
}

