/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.castor;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.castor.CastorSourceGenerator;
import org.codehaus.plexus.compiler.util.scan.InclusionScanException;
import org.codehaus.plexus.compiler.util.scan.SourceInclusionScanner;
import org.codehaus.plexus.compiler.util.scan.StaleSourceScanner;
import org.codehaus.plexus.compiler.util.scan.mapping.SourceMapping;
import org.codehaus.plexus.compiler.util.scan.mapping.SuffixMapping;
import org.codehaus.plexus.util.FileUtils;

public class GenerateMojo
extends AbstractMojo {
    private static final String DISABLE_DESCRIPTORS_MSG = "Disabling generation of Class descriptors";
    private static final String DISABLE_MARSHALL_MSG = "Disabling generation of Marshalling framework methods (marshall, unmarshall, validate).";
    private String bindingfile;
    private String schema;
    private String schemaDirectory;
    private String dest;
    private String tstamp;
    private int staleMillis = 0;
    private String types = "arraylist";
    private boolean descriptors = true;
    private boolean verbose = false;
    private boolean warnings = false;
    private boolean marshal = true;
    private String lineSeparator;
    private String properties;
    private String packaging;
    private MavenProject project;
    private CastorSourceGenerator sgen;

    public void execute() throws MojoExecutionException {
        Set staleXSDs;
        if (!FileUtils.fileExists((String)this.dest)) {
            FileUtils.mkdir((String)this.dest);
        }
        if ((staleXSDs = this.computeStaleXSDs()).isEmpty()) {
            this.getLog().info((CharSequence)"Nothing to process - all xsds are up to date");
            this.project.addCompileSourceRoot(this.dest);
            return;
        }
        this.config();
        Iterator i = staleXSDs.iterator();
        while (i.hasNext()) {
            File xsd = (File)i.next();
            try {
                this.processFile(xsd.getCanonicalPath());
                FileUtils.copyFileToDirectory((File)xsd, (File)this.getTimeStampDirectory());
            }
            catch (Exception e) {
                throw new MojoExecutionException("Castor execution failed", e);
            }
            catch (Throwable t) {
                throw new MojoExecutionException("Castor execution failed", t);
            }
        }
        if (this.project != null) {
            this.project.addCompileSourceRoot(this.dest);
        }
    }

    private Set computeStaleXSDs() throws MojoExecutionException {
        HashSet<File> staleSources = new HashSet<File>();
        if (this.schema != null) {
            File sourceFile = new File(this.schema);
            File targetFile = new File(this.getTimeStampDirectory(), sourceFile.getName());
            if (!targetFile.exists() || targetFile.lastModified() + (long)this.staleMillis < sourceFile.lastModified()) {
                staleSources.add(sourceFile);
            }
        } else {
            SuffixMapping mapping = new SuffixMapping(".xsd", ".xsd");
            File tstampDir = this.getTimeStampDirectory();
            File schemaDir = new File(this.schemaDirectory);
            SourceInclusionScanner scanner = this.getSourceInclusionScanner();
            scanner.addSourceMapping((SourceMapping)mapping);
            try {
                staleSources.addAll(scanner.getIncludedSources(schemaDir, tstampDir));
            }
            catch (InclusionScanException e) {
                throw new MojoExecutionException("Error scanning source root: '" + schemaDir + "' for stale xsds to reprocess.", (Exception)((Object)e));
            }
        }
        return staleSources;
    }

    private SourceInclusionScanner getSourceInclusionScanner() {
        return new StaleSourceScanner((long)this.staleMillis);
    }

    private File getTimeStampDirectory() {
        return new File(this.tstamp);
    }

    private void config() throws MojoExecutionException {
        this.sgen = CastorSourceGenerator.createSourceGenerator(this.types);
        this.sgen.setLog(this.getLog());
        this.sgen.setLineSeparatorStyle(this.lineSeparator);
        this.sgen.setDestDir(this.dest);
        this.sgen.setBindingFile(this.bindingfile);
        this.sgen.setVerbose(this.verbose);
        this.sgen.setSuppressNonFatalWarnings(!this.warnings);
        this.sgen.setDescriptorCreation(this.descriptors);
        if (!this.descriptors) {
            this.log(DISABLE_DESCRIPTORS_MSG);
        }
        this.sgen.setCreateMarshalMethods(this.marshal);
        if (!this.marshal) {
            this.log(DISABLE_MARSHALL_MSG);
        }
        this.sgen.setBuilderProperties(this.properties);
    }

    private void processFile(String filePath) throws MojoExecutionException {
        this.log("Processing " + filePath);
        try {
            this.sgen.generateSource(filePath, this.packaging);
        }
        catch (FileNotFoundException e) {
            String message = "XML Schema file \"" + filePath + "\" not found.";
            this.log(message);
            throw new MojoExecutionException(message);
        }
        catch (IOException iox) {
            throw new MojoExecutionException("An IOException occurred processing " + filePath, (Exception)iox);
        }
        catch (Exception e) {
            throw new MojoExecutionException("An Exception occurred processing " + filePath, e);
        }
    }

    private void log(String msg) {
        this.getLog().info((CharSequence)msg);
    }

    public String getDest() {
        return this.dest;
    }

    public void setDest(String dest) {
        this.dest = dest;
    }

    public String getTstamp() {
        return this.tstamp;
    }

    public void setTstamp(String tstamp) {
        this.tstamp = tstamp;
    }

    public String getPackaging() {
        return this.packaging;
    }

    public void setPackaging(String packaging) {
        this.packaging = packaging;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public String getTypes() {
        return this.types;
    }

    public void setTypes(String types) {
        this.types = types;
    }

    public void setProperties(String properties) {
        this.properties = properties;
    }

    public boolean getMarshal() {
        return this.marshal;
    }

    public void setMarshal(boolean marshal) {
        this.marshal = marshal;
    }

    public MavenProject getProject() {
        return this.project;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }
}

