/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.jira;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.maven.jira.JiraIssue;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class JiraXML
extends DefaultHandler {
    private List issueList;
    String currentElement;
    String currentParent = "";
    JiraIssue issue;

    public JiraXML(String xmlPath) {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        this.issueList = new ArrayList();
        try {
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse(new File(xmlPath), (DefaultHandler)this);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void startElement(String namespaceURI, String sName, String qName, Attributes attrs) throws SAXException {
        if (qName.equals("item")) {
            this.issue = new JiraIssue();
            this.currentParent = "item";
        }
    }

    public void endElement(String namespaceURI, String sName, String qName) throws SAXException {
        if (qName.equals("item")) {
            this.issueList.add(this.issue);
            this.currentParent = "";
        } else if (qName.equals("key")) {
            this.issue.setKey(this.currentElement);
        } else if (qName.equals("summary")) {
            this.issue.setSummary(this.currentElement);
        } else if (qName.equals("link") && this.currentParent.equals("item")) {
            this.issue.setLink(this.currentElement);
        } else if (qName.equals("status")) {
            this.issue.setStatus(this.currentElement);
        } else if (qName.equals("resolution")) {
            this.issue.setResolution(this.currentElement);
        } else if (qName.equals("assignee")) {
            this.issue.setAssignee(this.currentElement);
        }
        this.currentElement = "";
    }

    public void characters(char[] buf, int offset, int len) throws SAXException {
        String s = new String(buf, offset, len);
        if (!s.trim().equals("")) {
            this.currentElement = this.currentElement + s.trim() + "\n";
        }
    }

    public List getIssueList() {
        return this.issueList;
    }
}

