/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.chronos;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class HelpMojo
extends AbstractMojo {
    private boolean detail;
    private String goal;
    private int lineLength;
    private int indentSize;

    public void execute() throws MojoExecutionException {
        if (this.lineLength <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'lineLength' should be positive, using '80' as default.");
            this.lineLength = 80;
        }
        if (this.indentSize <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'indentSize' should be positive, using '2' as default.");
            this.indentSize = 2;
        }
        StringBuffer sb = new StringBuffer();
        this.append(sb, "org.codehaus.mojo:chronos-surefire-maven-plugin:1.1.0", 0);
        this.append(sb, "", 0);
        this.append(sb, "Chronos Surefire", 0);
        this.append(sb, "This plugin enables you to track and the executiontimes of a selection of Your unittests (JUnit or TestNG). One usage is to regard some of your automatic testcases as performancetests, tracking their executiontimes. Another usage is simply to monitor Your automatic tests to discover reasons for slow build times.", 1);
        this.append(sb, "", 0);
        if (this.goal == null || this.goal.length() <= 0) {
            this.append(sb, "This plugin has 2 goals:", 0);
            this.append(sb, "", 0);
        }
        if (this.goal == null || this.goal.length() <= 0 || "collect".equals(this.goal)) {
            this.append(sb, "chronos-surefire:collect", 0);
            this.append(sb, "Goal which collects the execution of each performed unittest, and compares the execution time to previous measured\nexecution times for the same test.\nIf the new execution time is larger then the old ones, the build will fail with a list of non-complient tests.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "chronosdir", 2);
                this.append(sb, "The directory to store chronos timing output.", 3);
                this.append(sb, "Expression: ${basedir}/target/chronos", 3);
                this.append(sb, "", 0);
                this.append(sb, "dataid (Default: performancetest)", 2);
                this.append(sb, "The id of the data, to create a report from.", 3);
                this.append(sb, "", 0);
                this.append(sb, "discrepancy (Default: 5)", 2);
                this.append(sb, "The maximum difference allowed between two measurements in percentage.\nSetting this to 0 (or less) will cause many failed builds, since there will almost always be a small discrepancy between two identical runs.", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludes", 2);
                this.append(sb, "List of test cases to exclude from reporting and validation", 3);
                this.append(sb, "", 0);
                this.append(sb, "failbuild (Default: true)", 2);
                this.append(sb, "Instructs chronos-timing to either fail or ignore the descrepancy (if any).", 3);
                this.append(sb, "", 0);
                this.append(sb, "includes", 2);
                this.append(sb, "List of test cases to include in reporting and validation", 3);
                this.append(sb, "", 0);
                this.append(sb, "maxnumberofresults (Default: 200)", 2);
                this.append(sb, "The number of (latest) results to include in the final graphs.\nThe more result - the longer processing time!", 3);
                this.append(sb, "", 0);
                this.append(sb, "minimumexecutiontime (Default: 100)", 2);
                this.append(sb, "Many unittests only takes a short time (< 100 m.seconds). Such tests will usually fail in chronos-surefire,\nbecause the default discrepancy of 50 m.seconds is 5 m.seconds, which is below the precision of the execution time recorder.\nIn order to prevent such problems, chronos-timing will per default filter out tests with an execution time less the a certain minimum execution time.", 3);
                this.append(sb, "", 0);
                this.append(sb, "reports", 2);
                this.append(sb, "List of test cases to exclude from discrepancy tests.\nChronos will still collect and report the execution time, but will not fail the build.", 3);
                this.append(sb, "", 0);
                this.append(sb, "surefiredir", 2);
                this.append(sb, "The directory where surefire reports results are stored.", 3);
                this.append(sb, "Expression: ${basedir}/target/surefire-reports", 3);
                this.append(sb, "", 0);
                this.append(sb, "testSourceDirectory", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "Expression: ${project.build.testSourceDirectory}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "help".equals(this.goal)) {
            this.append(sb, "chronos-surefire:help", 0);
            this.append(sb, "Display help information on chronos-surefire-maven-plugin.\nCall\n\u00a0\u00a0mvn\u00a0chronos-surefire:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "detail (Default: false)", 2);
                this.append(sb, "If true, display all settable properties for each goal.", 3);
                this.append(sb, "Expression: ${detail}", 3);
                this.append(sb, "", 0);
                this.append(sb, "goal", 2);
                this.append(sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3);
                this.append(sb, "Expression: ${goal}", 3);
                this.append(sb, "", 0);
                this.append(sb, "indentSize (Default: 2)", 2);
                this.append(sb, "The number of spaces per indentation level, should be positive.", 3);
                this.append(sb, "Expression: ${indentSize}", 3);
                this.append(sb, "", 0);
                this.append(sb, "lineLength (Default: 80)", 2);
                this.append(sb, "The maximum length of a display line, should be positive.", 3);
                this.append(sb, "Expression: ${lineLength}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)sb.toString());
        }
    }

    private static String repeat(String str, int repeat) {
        StringBuffer buffer = new StringBuffer(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    private void append(StringBuffer sb, String description, int indent) {
        Iterator it = HelpMojo.toLines(description, indent, this.indentSize, this.lineLength).iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append('\n');
        }
    }

    private static List toLines(String text, int indent, int indentSize, int lineLength) {
        ArrayList lines = new ArrayList();
        String ind = HelpMojo.repeat("\t", indent);
        String[] plainLines = text.split("(\r\n)|(\r)|(\n)");
        for (int i = 0; i < plainLines.length; ++i) {
            HelpMojo.toLines(lines, ind + plainLines[i], indentSize, lineLength);
        }
        return lines;
    }

    private static void toLines(List lines, String line, int indentSize, int lineLength) {
        int lineIndent = HelpMojo.getIndentLevel(line);
        StringBuffer buf = new StringBuffer(256);
        String[] tokens = line.split(" +");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (i > 0) {
                if (buf.length() + token.length() >= lineLength) {
                    lines.add(buf.toString());
                    buf.setLength(0);
                    buf.append(HelpMojo.repeat(" ", lineIndent * indentSize));
                } else {
                    buf.append(' ');
                }
            }
            for (int j = 0; j < token.length(); ++j) {
                char c = token.charAt(j);
                if (c == '\t') {
                    buf.append(HelpMojo.repeat(" ", indentSize - buf.length() % indentSize));
                    continue;
                }
                if (c == '\u00a0') {
                    buf.append(' ');
                    continue;
                }
                buf.append(c);
            }
        }
        lines.add(buf.toString());
    }

    private static int getIndentLevel(String line) {
        int i;
        int level = 0;
        for (i = 0; i < line.length() && line.charAt(i) == '\t'; ++i) {
            ++level;
        }
        for (i = level + 1; i <= level + 4 && i < line.length(); ++i) {
            if (line.charAt(i) != '\t') continue;
            ++level;
            break;
        }
        return level;
    }
}

