/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.chronos;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.mojo.chronos.Transactional;
import org.codehaus.mojo.chronos.data.HibernateUtil;
import org.codehaus.mojo.chronos.data.TestCase;
import org.codehaus.mojo.chronos.data.TestCaseResult;
import org.codehaus.mojo.chronos.data.Thresholds;
import org.codehaus.mojo.chronos.xml.GroupedResponseTimeSamples;
import org.codehaus.mojo.chronos.xml.ResponseTimeSampleGroup;
import org.codehaus.plexus.util.DirectoryScanner;
import org.hibernate.Query;
import org.hibernate.Session;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimerMojo
extends AbstractMojo {
    private static final String TESTCASE_TAG = "testcase";
    private List<String> compliencyProblems = new ArrayList<String>();
    protected String dataid;
    File surefiredir;
    File chronosdir;
    int maxnumberofresults;
    int discrepancy;
    private File testSourceDirectory;
    boolean failbuild;
    private String[] excludes;
    private String[] includes;
    private String[] reports;
    private long minimumexecutiontime = 100L;

    public void execute() throws MojoExecutionException {
        Thresholds baseTimes;
        File[] xmlFiles = this.surefiredir.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".xml");
            }
        });
        final HashSet<String> testCases = new HashSet<String>();
        try {
            baseTimes = new Thresholds(this.discrepancy);
        }
        catch (IOException e) {
            throw new MojoExecutionException("unable to load basetimes", (Exception)e);
        }
        for (final File xmlFile : xmlFiles) {
            Element testsuiteXML = this.loadFile(xmlFile);
            List testCaseXMLs = testsuiteXML.getChildren(TESTCASE_TAG);
            for (Element testCaseXML : testCaseXMLs) {
                final String classname = testCaseXML.getAttributeValue("classname");
                final String name = testCaseXML.getAttributeValue("name");
                final int executionTime = this.convertTime(testCaseXML.getAttributeValue("time"));
                if (!this.getIncludedTests().contains(this.asPath(classname))) continue;
                HibernateUtil.run(new Transactional(){

                    public void run(Session session) throws MojoExecutionException {
                        TestCase tc;
                        Query query = session.getNamedQuery("testcase.byClassAndName");
                        query.setString("classname", classname);
                        query.setString("name", name);
                        List res = query.list();
                        TestCase testCase = tc = res.isEmpty() ? null : (TestCase)res.get(0);
                        if (tc == null && (long)executionTime >= TimerMojo.this.minimumexecutiontime) {
                            tc = new TestCase(classname, name);
                        }
                        if (tc != null) {
                            TimerMojo.this.checkExecutionTime(tc, executionTime, baseTimes);
                            tc.addExecution(true, xmlFile.lastModified(), executionTime);
                            session.saveOrUpdate((Object)tc);
                            testCases.add(classname);
                        }
                    }
                });
            }
        }
        this.verifyCompliancy();
        try {
            baseTimes.store();
        }
        catch (IOException e) {
            throw new MojoExecutionException("unable to store basetimes", (Exception)e);
        }
        this.exportToXml(testCases);
    }

    private void verifyCompliancy() throws MojoExecutionException {
        if (this.compliencyProblems.isEmpty()) {
            return;
        }
        for (String compliencyProblem : this.compliencyProblems) {
            this.getLog().error((CharSequence)compliencyProblem);
        }
        if (this.failbuild) {
            throw new MojoExecutionException("Chronos-timing failed build due to compliency problems.");
        }
    }

    private int convertTime(String time) {
        double dTime = Double.parseDouble(time);
        return new Double(dTime *= 1000.0).intValue();
    }

    private void exportToXml(final Set<String> testClasses) throws MojoExecutionException {
        HibernateUtil.run(new Transactional(){

            public void run(Session session) throws MojoExecutionException {
                GroupedResponseTimeSamples samples = new GroupedResponseTimeSamples();
                try {
                    for (String testClass : testClasses) {
                        Query query = session.getNamedQuery("testcase.byClass");
                        query.setString("classname", testClass);
                        List testCases = query.list();
                        for (TestCase testCase : testCases) {
                            samples.addGroup(TimerMojo.this.assempleGroup(testCase));
                        }
                    }
                }
                catch (IOException ex) {
                    throw new MojoExecutionException("Error while saving results", (Exception)ex);
                }
                TimerMojo.this.getOutputdir().mkdirs();
                try {
                    samples.dumpResults(TimerMojo.this.getOutputdir());
                }
                catch (IOException ex) {
                    throw new MojoExecutionException("Error while saving results", (Exception)ex);
                }
            }
        });
    }

    private File getOutputdir() {
        return new File(this.chronosdir, this.dataid);
    }

    private ResponseTimeSampleGroup assempleGroup(TestCase testCase) throws IOException {
        ResponseTimeSampleGroup tr = new ResponseTimeSampleGroup(testCase.getTestIdentifier());
        int count = 0;
        int startIndex = testCase.getResults().size() - this.maxnumberofresults;
        for (TestCaseResult tcr : testCase.getResults()) {
            if (count >= startIndex) {
                tr.addMeasurement(tcr.getTimeOfMeasurement(), tcr.getTime(), tcr.isSuccess(), tcr.getIdentifier());
            }
            ++count;
        }
        return tr;
    }

    private void checkExecutionTime(TestCase tc, int executionTime, Thresholds basetimes) {
        boolean valid;
        if (this.getValidatedTests().contains(this.asPath(tc.getClassname())) && !(valid = basetimes.validate(tc, executionTime))) {
            this.compliencyProblems.add(tc.getTestIdentifier() + " failed with an execution executionTime of " + executionTime + " against a base executionTime of " + basetimes.getBaseTime(tc));
        }
    }

    private Set<String> getIncludedTests() {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(this.testSourceDirectory);
        scanner.setIncludes(TimerMojo.merge(this.includes, this.reports));
        scanner.setExcludes(this.excludes);
        scanner.scan();
        HashSet<String> res = new HashSet<String>();
        for (String filePath : scanner.getIncludedFiles()) {
            res.add(filePath);
        }
        return res;
    }

    private Set<String> getValidatedTests() {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(this.testSourceDirectory);
        scanner.setIncludes(this.includes);
        scanner.setExcludes(TimerMojo.merge(this.excludes, this.reports));
        scanner.scan();
        HashSet<String> res = new HashSet<String>();
        for (String filePath : scanner.getIncludedFiles()) {
            res.add(filePath);
        }
        return res;
    }

    private String asPath(String className) {
        return className.replace('.', File.separatorChar) + ".java";
    }

    private static String[] merge(String[] src1, String[] src2) {
        if (src1 == null) {
            src1 = new String[]{};
        }
        if (src2 == null) {
            src2 = new String[]{};
        }
        String[] dest = new String[src1.length + src2.length];
        System.arraycopy(src1, 0, dest, 0, src1.length);
        System.arraycopy(src2, 0, dest, src1.length, src2.length);
        return dest;
    }

    private Element loadFile(File xmlFile) throws MojoExecutionException {
        try {
            SAXBuilder sb = new SAXBuilder();
            Document doc = sb.build(xmlFile);
            return doc.getRootElement();
        }
        catch (JDOMException e) {
            throw new MojoExecutionException("Error during parsing xml file.", (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error loading xml file.", (Exception)e);
        }
    }
}

