/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.chronos.data;

import java.io.File;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.mojo.chronos.Transactional;
import org.codehaus.mojo.chronos.data.TestCase;
import org.codehaus.mojo.chronos.data.TestCaseResult;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.cfg.Configuration;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.ServiceRegistryBuilder;

public class HibernateUtil {
    private static SessionFactory sessionFactory;
    private static final String DB_LOC = "chronostimerdb";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void run(Transactional transactional) throws MojoExecutionException {
        Session session = HibernateUtil.getSession();
        try {
            Transaction transaction = session.beginTransaction();
            try {
                transactional.run(session);
                transaction.commit();
            }
            catch (RuntimeException e) {
                transaction.rollback();
                throw new MojoExecutionException("Error while accessing database", (Exception)e);
            }
        }
        finally {
            if (session.isOpen()) {
                session.close();
            }
        }
    }

    public static Session getSession() throws HibernateException {
        if (sessionFactory == null) {
            HibernateUtil.initialize();
        }
        return sessionFactory.getCurrentSession();
    }

    private static void initialize() {
        try {
            Configuration ac = new Configuration();
            ac.addAnnotatedClass(TestCase.class);
            ac.addAnnotatedClass(TestCaseResult.class);
            Properties properties = new Properties();
            properties.setProperty("hibernate.dialect", "org.hibernate.dialect.DerbyTenSevenDialect");
            properties.setProperty("hibernate.connection.driver_class", "org.apache.derby.jdbc.EmbeddedDriver");
            properties.setProperty("hibernate.connection.url", "jdbc:derby:chronostimerdb;create=true");
            properties.setProperty("hibernate.connection.username", "chronos");
            properties.setProperty("hibernate.connection.password", "chronos");
            properties.setProperty("hibernate.current_session_context_class", "thread");
            properties.setProperty("hibernate.show_sql", "false");
            properties.setProperty("hibernate.search.default.optimizer.operation_limit.max", "1000");
            properties.setProperty("hibernate.search.default.optimizer.transaction_limit.max", "100");
            ac.setProperties(properties);
            if (!new File(".", DB_LOC).exists()) {
                properties.setProperty("hibernate.hbm2ddl.auto", "create");
            }
            ac.setProperties(properties);
            ServiceRegistry serviceRegistry = new ServiceRegistryBuilder().applySettings((Map)properties).buildServiceRegistry();
            sessionFactory = ac.buildSessionFactory(serviceRegistry);
        }
        catch (Throwable ex) {
            throw new ExceptionInInitializerError(ex);
        }
    }

    private HibernateUtil() {
    }
}

