/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.chronos.data;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.codehaus.mojo.chronos.data.TestCaseIdentifierHelper;
import org.codehaus.mojo.chronos.data.TestCaseResult;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.IndexColumn;
import org.hibernate.annotations.LazyCollection;
import org.hibernate.annotations.LazyCollectionOption;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="testcase", uniqueConstraints={@UniqueConstraint(columnNames={"classname", "name"})})
@NamedQueries(value={@NamedQuery(name="testcase.byClassAndName", query="select tc from TestCase as tc where tc.classname = :classname and tc.name = :name"), @NamedQuery(name="testcase.byClass", query="select tc from TestCase as tc where tc.classname = :classname"), @NamedQuery(name="testcase.all", query="select tc from TestCase as tc")})
public class TestCase {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    @Column(name="id")
    protected Long id;
    @Column(name="basetime")
    private int basetime;
    @Column(length=1024)
    private String classname;
    @Column(length=512)
    private String name;
    @OneToMany(fetch=FetchType.LAZY)
    @IndexColumn(name="index", base=1)
    @Cascade(value={CascadeType.ALL})
    @LazyCollection(value=LazyCollectionOption.EXTRA)
    private List<TestCaseResult> results = new ArrayList<TestCaseResult>();

    public TestCase() {
    }

    public TestCase(String classname, String name) {
        this.classname = classname;
        this.name = name;
    }

    public String getTestIdentifier() {
        return TestCaseIdentifierHelper.instance().getIdentifier(this.classname, this.name);
    }

    public void addExecution(boolean succes, long startTime, int executionTime) {
        TestCaseResult testCaseResult = new TestCaseResult(succes, startTime, executionTime);
        this.results.add(testCaseResult);
    }

    public List<TestCaseResult> getResults() {
        return this.results;
    }

    public String getClassname() {
        return this.classname;
    }

    public boolean equals(Object obj) {
        if (obj instanceof TestCase) {
            TestCase other = (TestCase)obj;
            return this.classname.equals(other.classname) && this.name.equals(other.name);
        }
        return false;
    }

    public int hashCode() {
        return this.classname.hashCode() + this.name.hashCode();
    }

    public String toString() {
        return "TestCase[classname=" + this.classname + ", name=" + this.name + ", basetime=" + this.basetime + "]";
    }
}

