/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.chronos.xml;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math.stat.descriptive.rank.Min;
import org.codehaus.mojo.chronos.xml.ResponseTimeSampleGroup;
import org.jdom2.Comment;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public class GroupedResponseTimeSamples {
    private List<ResponseTimeSampleGroup> groups = new ArrayList<ResponseTimeSampleGroup>();

    public void addGroup(ResponseTimeSampleGroup group) {
        this.groups.add(group);
    }

    public void dumpResults(File parentDirectory) throws IOException {
        File outputFile = new File(parentDirectory, "perf-chronostiming.xml");
        Element root = new Element("groupedresponsetimesamples");
        int index = 0;
        int succeeded = 0;
        Min testStart = new Min();
        for (ResponseTimeSampleGroup group : this.groups) {
            Element child = group.toXML();
            child.setAttribute("index", Integer.toString(++index));
            root.addContent((Content)child);
            succeeded += group.getSucceeded();
            testStart.increment((double)group.getTestStart());
        }
        root.setAttribute("succeeded", Integer.toString(succeeded));
        root.setAttribute("starttime", Long.toString((long)testStart.getResult()));
        root.setAttribute("dateformat", "yyyy.MM.dd 'at' HH:mm:ss");
        Document doc = new Document(root);
        doc.addContent((Content)new Comment("File generated by \"Chronos timing\""));
        XMLOutputter outputter = new XMLOutputter(Format.getPrettyFormat());
        outputter.output(doc, (OutputStream)new FileOutputStream(outputFile));
    }
}

