/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.chronos.xml;

import org.apache.commons.math.stat.descriptive.rank.Min;
import org.jdom2.Content;
import org.jdom2.Element;

public class ResponseTimeSampleGroup {
    private Element root = new Element("responsetimesamplegroup");
    private int succeeded = 0;
    private final Min testStart = new Min();
    private String name;

    public ResponseTimeSampleGroup(String name) {
        this.name = name;
        this.root.setAttribute("name", name);
    }

    public long getTestStart() {
        return (long)this.testStart.getResult();
    }

    public int getSucceeded() {
        return this.succeeded;
    }

    public Element toXML() {
        return this.root;
    }

    public void addMeasurement(long timestamp, int responseTime, boolean success, String threadId) {
        this.testStart.increment((double)timestamp);
        Element sample = new Element("sample");
        sample.setAttribute("timestamp", Long.toString(timestamp));
        sample.setAttribute("responsetime", Integer.toString(responseTime));
        sample.setAttribute("success", Boolean.toString(success));
        sample.setAttribute("threadId", threadId);
        this.root.addContent((Content)sample);
        ++this.succeeded;
    }
}

