/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.clirr;

import net.sf.clirr.core.ApiDifference;
import net.sf.clirr.core.DiffListenerAdapter;
import net.sf.clirr.core.MessageTranslator;
import net.sf.clirr.core.Severity;
import org.apache.maven.plugin.logging.Log;

public class LogDiffListener
extends DiffListenerAdapter {
    private final Log log;
    private final MessageTranslator messageTranslator;

    public LogDiffListener(Log log) {
        this.log = log;
        this.messageTranslator = new MessageTranslator();
    }

    public void reportDiff(ApiDifference apiDifference) {
        String message = apiDifference.getAffectedClass() + ": " + apiDifference.getReport(this.messageTranslator);
        Severity severity = apiDifference.getMaximumSeverity();
        if (severity.equals(Severity.INFO)) {
            this.log.info((CharSequence)message);
        } else if (severity.equals(Severity.WARNING)) {
            this.log.warn((CharSequence)message);
        } else if (severity.equals(Severity.ERROR)) {
            this.log.error((CharSequence)message);
        }
    }
}

