/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.clirr;

import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import net.sf.clirr.core.ApiDifference;
import net.sf.clirr.core.MessageTranslator;
import net.sf.clirr.core.Severity;
import org.apache.maven.doxia.sink.Sink;
import org.codehaus.mojo.clirr.ClirrDiffListener;

public class ClirrReportGenerator {
    private final ResourceBundle bundle;
    private final Sink sink;
    private boolean enableSeveritySummary;
    private final Locale locale;
    private Severity minSeverity;
    private String xrefLocation;
    private String currentVersion;
    private String comparisonVersion;

    public ClirrReportGenerator(Sink sink, ResourceBundle bundle, Locale locale) {
        this.bundle = bundle;
        this.sink = sink;
        this.enableSeveritySummary = true;
        this.locale = locale;
    }

    public void generateReport(ClirrDiffListener listener) {
        this.doHeading();
        if (this.enableSeveritySummary) {
            this.doSeveritySummary(listener);
        }
        this.doDetails(listener);
        this.sink.body_();
        this.sink.flush();
        this.sink.close();
    }

    private void doHeading() {
        this.sink.head();
        this.sink.title();
        String title = this.bundle.getString("report.clirr.title");
        this.sink.text(title);
        this.sink.title_();
        this.sink.head_();
        this.sink.body();
        this.sink.section1();
        this.sink.sectionTitle1();
        this.sink.text(title);
        this.sink.sectionTitle1_();
        this.sink.paragraph();
        this.sink.text(this.bundle.getString("report.clirr.clirrlink") + " ");
        this.sink.link("http://clirr.sourceforge.net/");
        this.sink.text("Clirr");
        this.sink.link_();
        this.sink.text(".");
        this.sink.paragraph_();
        this.sink.list();
        this.sink.listItem();
        this.sink.text(this.bundle.getString("report.clirr.version.current") + " ");
        this.sink.text(this.getCurrentVersion());
        this.sink.listItem_();
        if (this.getComparisonVersion() != null) {
            this.sink.listItem();
            this.sink.text(this.bundle.getString("report.clirr.version.comparison") + " ");
            this.sink.text(this.getComparisonVersion());
            this.sink.listItem_();
        }
        this.sink.list_();
        this.sink.section1_();
    }

    private void iconInfo() {
        this.sink.figure();
        this.sink.figureCaption();
        this.sink.text(this.bundle.getString("report.clirr.level.info"));
        this.sink.figureCaption_();
        this.sink.figureGraphics("images/icon_info_sml.gif");
        this.sink.figure_();
    }

    private void iconWarning() {
        this.sink.figure();
        this.sink.figureCaption();
        this.sink.text(this.bundle.getString("report.clirr.level.warning"));
        this.sink.figureCaption_();
        this.sink.figureGraphics("images/icon_warning_sml.gif");
        this.sink.figure_();
    }

    private void iconError() {
        this.sink.figure();
        this.sink.figureCaption();
        this.sink.text(this.bundle.getString("report.clirr.level.error"));
        this.sink.figureCaption_();
        this.sink.figureGraphics("images/icon_error_sml.gif");
        this.sink.figure_();
    }

    private void doSeveritySummary(ClirrDiffListener listener) {
        this.sink.section1();
        this.sink.sectionTitle1();
        this.sink.text(this.bundle.getString("report.clirr.summary"));
        this.sink.sectionTitle1_();
        this.sink.table();
        this.sink.tableRow();
        this.sink.tableHeaderCell();
        this.sink.text(this.bundle.getString("report.clirr.column.severity"));
        this.sink.tableHeaderCell_();
        this.sink.tableHeaderCell();
        this.sink.text(this.bundle.getString("report.clirr.column.number"));
        this.sink.tableHeaderCell_();
        this.sink.tableRow_();
        this.sink.tableRow();
        this.sink.tableCell();
        this.iconError();
        this.sink.nonBreakingSpace();
        this.sink.text(this.bundle.getString("report.clirr.level.error"));
        this.sink.tableCell_();
        this.sink.tableCell();
        this.sink.text(String.valueOf(listener.getSeverityCount(Severity.ERROR)));
        this.sink.tableCell_();
        this.sink.tableRow_();
        if (this.minSeverity == null || this.minSeverity.compareTo((Object)Severity.WARNING) <= 0) {
            this.sink.tableRow();
            this.sink.tableCell();
            this.iconWarning();
            this.sink.nonBreakingSpace();
            this.sink.text(this.bundle.getString("report.clirr.level.warning"));
            this.sink.tableCell_();
            this.sink.tableCell();
            this.sink.text(String.valueOf(listener.getSeverityCount(Severity.WARNING)));
            this.sink.tableCell_();
            this.sink.tableRow_();
        }
        if (this.minSeverity == null || this.minSeverity.compareTo((Object)Severity.INFO) <= 0) {
            this.sink.tableRow();
            this.sink.tableCell();
            this.iconInfo();
            this.sink.nonBreakingSpace();
            this.sink.text(this.bundle.getString("report.clirr.level.info"));
            this.sink.tableCell_();
            this.sink.tableCell();
            this.sink.text(String.valueOf(listener.getSeverityCount(Severity.INFO)));
            this.sink.tableCell_();
            this.sink.tableRow_();
        }
        this.sink.table_();
        if (this.minSeverity == null || this.minSeverity.compareTo((Object)Severity.INFO) > 0) {
            this.sink.paragraph();
            this.sink.italic();
            this.sink.text(this.bundle.getString("report.clirr.filtered"));
            this.sink.italic_();
            this.sink.paragraph_();
        }
        this.sink.section1_();
    }

    private void doDetails(ClirrDiffListener listener) {
        this.sink.section1();
        this.sink.sectionTitle1();
        this.sink.text(this.bundle.getString("report.clirr.details"));
        this.sink.sectionTitle1_();
        List differences = listener.getApiDifferences();
        if (!differences.isEmpty()) {
            this.doTable(differences);
        } else {
            this.sink.paragraph();
            this.sink.text(this.bundle.getString("report.clirr.noresults"));
            this.sink.paragraph_();
        }
        this.sink.section1_();
    }

    private void doTable(List differences) {
        this.sink.table();
        this.sink.tableRow();
        this.sink.tableHeaderCell();
        this.sink.text(this.bundle.getString("report.clirr.column.severity"));
        this.sink.tableHeaderCell_();
        this.sink.tableHeaderCell();
        this.sink.text(this.bundle.getString("report.clirr.column.message"));
        this.sink.tableHeaderCell_();
        this.sink.tableHeaderCell();
        this.sink.text(this.bundle.getString("report.clirr.column.class"));
        this.sink.tableHeaderCell_();
        this.sink.tableHeaderCell();
        this.sink.text(this.bundle.getString("report.clirr.column.methodorfield"));
        this.sink.tableHeaderCell_();
        this.sink.tableRow_();
        MessageTranslator translator = new MessageTranslator();
        translator.setLocale(this.locale);
        Iterator events = differences.iterator();
        while (events.hasNext()) {
            ApiDifference difference = (ApiDifference)events.next();
            Severity maximumSeverity = difference.getMaximumSeverity();
            if (this.minSeverity != null && this.minSeverity.compareTo((Object)maximumSeverity) > 0) continue;
            this.sink.tableRow();
            this.sink.tableCell();
            this.levelIcon(maximumSeverity);
            this.sink.tableCell_();
            this.sink.tableCell();
            this.sink.text(difference.getReport(translator));
            this.sink.tableCell_();
            this.sink.tableCell();
            if (this.xrefLocation != null) {
                this.sink.link(this.xrefLocation + "/" + difference.getAffectedClass().replace('.', '/') + ".html");
            }
            this.sink.text(difference.getAffectedClass());
            if (this.xrefLocation != null) {
                this.sink.link_();
            }
            this.sink.tableCell_();
            this.sink.tableCell();
            this.sink.text(difference.getAffectedMethod() != null ? difference.getAffectedMethod() : difference.getAffectedField());
            this.sink.tableCell_();
            this.sink.tableRow_();
        }
        this.sink.table_();
    }

    private void levelIcon(Severity level) {
        if (Severity.INFO.equals(level)) {
            this.iconInfo();
        } else if (Severity.WARNING.equals(level)) {
            this.iconWarning();
        } else if (Severity.ERROR.equals(level)) {
            this.iconError();
        }
    }

    public void setEnableSeveritySummary(boolean enableSeveritySummary) {
        this.enableSeveritySummary = enableSeveritySummary;
    }

    public void setMinSeverity(Severity minSeverity) {
        this.minSeverity = minSeverity;
    }

    public String getXrefLocation() {
        return this.xrefLocation;
    }

    public void setXrefLocation(String xrefLocation) {
        this.xrefLocation = xrefLocation;
    }

    public String getCurrentVersion() {
        return this.currentVersion;
    }

    public void setCurrentVersion(String currentVersion) {
        this.currentVersion = currentVersion;
    }

    public String getComparisonVersion() {
        return this.comparisonVersion;
    }

    public void setComparisonVersion(String comparisonVersion) {
        this.comparisonVersion = comparisonVersion;
    }
}

