package org.codehaus.mojo.clirr;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

/**
 * Display help information on clirr-maven-plugin.<br/> Call <pre>  mvn clirr:help -Ddetail=true -Dgoal=&lt;goal-name&gt;</pre> to display parameter details.
 *
 * @version generated on Sat Jan 08 01:14:40 CET 2011
 * @author org.apache.maven.tools.plugin.generator.PluginHelpGenerator (version 2.6)
 * @goal help
 * @requiresProject false
 */
public class HelpMojo
    extends AbstractMojo
{
    /**
     * If <code>true</code>, display all settable properties for each goal.
     * 
     * @parameter expression="${detail}" default-value="false"
     */
    private boolean detail;

    /**
     * The name of the goal for which to show help. If unspecified, all goals will be displayed.
     * 
     * @parameter expression="${goal}"
     */
    private java.lang.String goal;

    /**
     * The maximum length of a display line, should be positive.
     * 
     * @parameter expression="${lineLength}" default-value="80"
     */
    private int lineLength;

    /**
     * The number of spaces per indentation level, should be positive.
     * 
     * @parameter expression="${indentSize}" default-value="2"
     */
    private int indentSize;


    /** {@inheritDoc} */
    public void execute()
        throws MojoExecutionException
    {
        if ( lineLength <= 0 )
        {
            getLog().warn( "The parameter 'lineLength' should be positive, using '80' as default." );
            lineLength = 80;
        }
        if ( indentSize <= 0 )
        {
            getLog().warn( "The parameter 'indentSize' should be positive, using '2' as default." );
            indentSize = 2;
        }

        StringBuffer sb = new StringBuffer();

        append( sb, "org.codehaus.mojo:clirr-maven-plugin:2.3", 0 );
        append( sb, "", 0 );

        append( sb, "Clirr Maven Plugin", 0 );
        append( sb, "Clirr is a tool that checks Java libraries for binary and source compatibility with older releases. Basically you give it two sets of jar files and Clirr dumps out a list of changes in the public API. The clirr-maven-plugin can be configured to break the build, if it detects incompatible api changes. In a continuous integration process, the clirr-maven-plugin can automatically prevent accidental introduction of binary or source compatibility problems. Additionally, the plugin can generate a report as part of the generated site.", 1 );
        append( sb, "", 0 );

        if ( goal == null || goal.length() <= 0 )
        {
            append( sb, "This plugin has 5 goals:", 0 );
            append( sb, "", 0 );
        }

        if ( goal == null || goal.length() <= 0 || "check".equals( goal ) )
        {
            append( sb, "clirr:check", 0 );
            append( sb, "Check for compatibility with previous version.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "classesDirectory (Default: ${project.build.outputDirectory})", 2 );
                append( sb, "The classes of this project to compare the last release against.", 3 );
                append( sb, "", 0 );

                append( sb, "comparisonArtifacts", 2 );
                append( sb, "List of artifacts to compare the current code against. This overrides comparisonVersion, if present. Each comparisonArtifact is made of a groupId, an artifactId and a version number. Optionally it may have a classifier (default null) and a type (default \'jar\').", 3 );
                append( sb, "", 0 );

                append( sb, "comparisonVersion (Default: (,${project.version}))", 2 );
                append( sb, "Version to compare the current code against.", 3 );
                append( sb, "", 0 );

                append( sb, "excludes", 2 );
                append( sb, "A list of classes to exclude. These classes are excluded from the list of classes that are included. Values are specified in path pattern notation, e.g. org/codehaus/mojo/**.", 3 );
                append( sb, "", 0 );

                append( sb, "failOnError (Default: true)", 2 );
                append( sb, "Whether to fail on errors.", 3 );
                append( sb, "", 0 );

                append( sb, "failOnInfo (Default: false)", 2 );
                append( sb, "Whether to fail on info.", 3 );
                append( sb, "", 0 );

                append( sb, "failOnWarning (Default: false)", 2 );
                append( sb, "Whether to fail on warnings.", 3 );
                append( sb, "", 0 );

                append( sb, "includes", 2 );
                append( sb, "A list of classes to include. Anything not included is excluded. If omitted, all are assumed to be included. Values are specified in path pattern notation, e.g. org/codehaus/mojo/**.", 3 );
                append( sb, "", 0 );

                append( sb, "logResults (Default: false)", 2 );
                append( sb, "Whether to log the results to the console or not.", 3 );
                append( sb, "", 0 );

                append( sb, "minSeverity (Default: warning)", 2 );
                append( sb, "Show only messages of this severity or higher. Valid values are info, warning and error.", 3 );
                append( sb, "", 0 );

                append( sb, "skip (Default: false)", 2 );
                append( sb, "Flag to easily skip execution.", 3 );
                append( sb, "", 0 );

                append( sb, "textOutputFile", 2 );
                append( sb, "A text output file to render to. If omitted, no output is rendered to a text file.", 3 );
                append( sb, "", 0 );

                append( sb, "xmlOutputFile", 2 );
                append( sb, "An XML file to render to. If omitted, no output is rendered to an XML file.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "check-arbitrary".equals( goal ) )
        {
            append( sb, "clirr:check-arbitrary", 0 );
            append( sb, "Check for compatibility between two arbitrary artifact sets.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "classesDirectory (Default: ${project.build.outputDirectory})", 2 );
                append( sb, "The classes of this project to compare the last release against.", 3 );
                append( sb, "", 0 );

                append( sb, "comparisonArtifacts", 2 );
                append( sb, "List of artifacts to compare the current code against. This overrides comparisonVersion, if present. Each comparisonArtifact is made of a groupId, an artifactId and a version number. Optionally it may have a classifier (default null) and a type (default \'jar\').", 3 );
                append( sb, "", 0 );

                append( sb, "comparisonVersion (Default: (,${project.version}))", 2 );
                append( sb, "Version to compare the current code against.", 3 );
                append( sb, "", 0 );

                append( sb, "excludes", 2 );
                append( sb, "A list of classes to exclude. These classes are excluded from the list of classes that are included. Values are specified in path pattern notation, e.g. org/codehaus/mojo/**.", 3 );
                append( sb, "", 0 );

                append( sb, "failOnError (Default: true)", 2 );
                append( sb, "Whether to fail on errors.", 3 );
                append( sb, "", 0 );

                append( sb, "failOnWarning (Default: false)", 2 );
                append( sb, "Whether to fail on warnings.", 3 );
                append( sb, "", 0 );

                append( sb, "includes", 2 );
                append( sb, "A list of classes to include. Anything not included is excluded. If omitted, all are assumed to be included. Values are specified in path pattern notation, e.g. org/codehaus/mojo/**.", 3 );
                append( sb, "", 0 );

                append( sb, "logResults (Default: false)", 2 );
                append( sb, "Whether to log the results to the console or not.", 3 );
                append( sb, "", 0 );

                append( sb, "minSeverity (Default: warning)", 2 );
                append( sb, "Show only messages of this severity or higher. Valid values are info, warning and error.", 3 );
                append( sb, "", 0 );

                append( sb, "newComparisonArtifacts", 2 );
                append( sb, "List of artifacts to compare to baseline.", 3 );
                append( sb, "", 0 );

                append( sb, "oldComparisonArtifacts", 2 );
                append( sb, "List of artifacts to serve as a baseline to compare against.", 3 );
                append( sb, "", 0 );

                append( sb, "skip (Default: false)", 2 );
                append( sb, "Flag to easily skip execution.", 3 );
                append( sb, "", 0 );

                append( sb, "textOutputFile", 2 );
                append( sb, "A text output file to render to. If omitted, no output is rendered to a text file.", 3 );
                append( sb, "", 0 );

                append( sb, "xmlOutputFile", 2 );
                append( sb, "An XML file to render to. If omitted, no output is rendered to an XML file.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "check-no-fork".equals( goal ) )
        {
            append( sb, "clirr:check-no-fork", 0 );
            append( sb, "Check for compatibility with previous version without forking the project", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "classesDirectory (Default: ${project.build.outputDirectory})", 2 );
                append( sb, "The classes of this project to compare the last release against.", 3 );
                append( sb, "", 0 );

                append( sb, "comparisonArtifacts", 2 );
                append( sb, "List of artifacts to compare the current code against. This overrides comparisonVersion, if present. Each comparisonArtifact is made of a groupId, an artifactId and a version number. Optionally it may have a classifier (default null) and a type (default \'jar\').", 3 );
                append( sb, "", 0 );

                append( sb, "comparisonVersion (Default: (,${project.version}))", 2 );
                append( sb, "Version to compare the current code against.", 3 );
                append( sb, "", 0 );

                append( sb, "excludes", 2 );
                append( sb, "A list of classes to exclude. These classes are excluded from the list of classes that are included. Values are specified in path pattern notation, e.g. org/codehaus/mojo/**.", 3 );
                append( sb, "", 0 );

                append( sb, "failOnError (Default: true)", 2 );
                append( sb, "Whether to fail on errors.", 3 );
                append( sb, "", 0 );

                append( sb, "failOnInfo (Default: false)", 2 );
                append( sb, "Whether to fail on info.", 3 );
                append( sb, "", 0 );

                append( sb, "failOnWarning (Default: false)", 2 );
                append( sb, "Whether to fail on warnings.", 3 );
                append( sb, "", 0 );

                append( sb, "includes", 2 );
                append( sb, "A list of classes to include. Anything not included is excluded. If omitted, all are assumed to be included. Values are specified in path pattern notation, e.g. org/codehaus/mojo/**.", 3 );
                append( sb, "", 0 );

                append( sb, "logResults (Default: false)", 2 );
                append( sb, "Whether to log the results to the console or not.", 3 );
                append( sb, "", 0 );

                append( sb, "minSeverity (Default: warning)", 2 );
                append( sb, "Show only messages of this severity or higher. Valid values are info, warning and error.", 3 );
                append( sb, "", 0 );

                append( sb, "skip (Default: false)", 2 );
                append( sb, "Flag to easily skip execution.", 3 );
                append( sb, "", 0 );

                append( sb, "textOutputFile", 2 );
                append( sb, "A text output file to render to. If omitted, no output is rendered to a text file.", 3 );
                append( sb, "", 0 );

                append( sb, "xmlOutputFile", 2 );
                append( sb, "An XML file to render to. If omitted, no output is rendered to an XML file.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "clirr".equals( goal ) )
        {
            append( sb, "clirr:clirr", 0 );
            append( sb, "Generate a report from the Clirr output.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "classesDirectory (Default: ${project.build.outputDirectory})", 2 );
                append( sb, "The classes of this project to compare the last release against.", 3 );
                append( sb, "", 0 );

                append( sb, "comparisonArtifacts", 2 );
                append( sb, "List of artifacts to compare the current code against. This overrides comparisonVersion, if present. Each comparisonArtifact is made of a groupId, an artifactId and a version number. Optionally it may have a classifier (default null) and a type (default \'jar\').", 3 );
                append( sb, "", 0 );

                append( sb, "comparisonVersion (Default: (,${project.version}))", 2 );
                append( sb, "Version to compare the current code against.", 3 );
                append( sb, "", 0 );

                append( sb, "excludes", 2 );
                append( sb, "A list of classes to exclude. These classes are excluded from the list of classes that are included. Values are specified in path pattern notation, e.g. org/codehaus/mojo/**.", 3 );
                append( sb, "", 0 );

                append( sb, "htmlReport (Default: true)", 2 );
                append( sb, "Whether to render the HTML report or not.", 3 );
                append( sb, "", 0 );

                append( sb, "includes", 2 );
                append( sb, "A list of classes to include. Anything not included is excluded. If omitted, all are assumed to be included. Values are specified in path pattern notation, e.g. org/codehaus/mojo/**.", 3 );
                append( sb, "", 0 );

                append( sb, "linkXRef (Default: true)", 2 );
                append( sb, "Link the violation line numbers to the source Xref. This will create links if the JXR Plugin is being used.", 3 );
                append( sb, "", 0 );

                append( sb, "logResults (Default: false)", 2 );
                append( sb, "Whether to log the results to the console or not.", 3 );
                append( sb, "", 0 );

                append( sb, "minSeverity (Default: warning)", 2 );
                append( sb, "Show only messages of this severity or higher. Valid values are info, warning and error.", 3 );
                append( sb, "", 0 );

                append( sb, "outputDirectory (Default: ${project.reporting.outputDirectory})", 2 );
                append( sb, "Specifies the directory where the report will be generated.", 3 );
                append( sb, "", 0 );

                append( sb, "showSummary (Default: true)", 2 );
                append( sb, "Whether to show the summary of the number of errors, warnings and informational messages.", 3 );
                append( sb, "", 0 );

                append( sb, "skip (Default: false)", 2 );
                append( sb, "Flag to easily skip execution.", 3 );
                append( sb, "", 0 );

                append( sb, "textOutputFile", 2 );
                append( sb, "A text output file to render to. If omitted, no output is rendered to a text file.", 3 );
                append( sb, "", 0 );

                append( sb, "xmlOutputFile", 2 );
                append( sb, "An XML file to render to. If omitted, no output is rendered to an XML file.", 3 );
                append( sb, "", 0 );

                append( sb, "xrefLocation (Default: ${project.build.directory}/site/xref)", 2 );
                append( sb, "Location of the Xrefs to link to.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "help".equals( goal ) )
        {
            append( sb, "clirr:help", 0 );
            append( sb, "Display help information on clirr-maven-plugin.\nCall\n\u00a0\u00a0mvn\u00a0clirr:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "detail (Default: false)", 2 );
                append( sb, "If true, display all settable properties for each goal.", 3 );
                append( sb, "", 0 );

                append( sb, "goal", 2 );
                append( sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3 );
                append( sb, "", 0 );

                append( sb, "indentSize (Default: 2)", 2 );
                append( sb, "The number of spaces per indentation level, should be positive.", 3 );
                append( sb, "", 0 );

                append( sb, "lineLength (Default: 80)", 2 );
                append( sb, "The maximum length of a display line, should be positive.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( getLog().isInfoEnabled() )
        {
            getLog().info( sb.toString() );
        }
    }

    /**
     * <p>Repeat a String <code>n</code> times to form a new string.</p>
     *
     * @param str String to repeat
     * @param repeat number of times to repeat str
     * @return String with repeated String
     * @throws NegativeArraySizeException if <code>repeat < 0</code>
     * @throws NullPointerException if str is <code>null</code>
     */
    private static String repeat( String str, int repeat )
    {
        StringBuffer buffer = new StringBuffer( repeat * str.length() );

        for ( int i = 0; i < repeat; i++ )
        {
            buffer.append( str );
        }

        return buffer.toString();
    }

    /** 
     * Append a description to the buffer by respecting the indentSize and lineLength parameters.
     * <b>Note</b>: The last character is always a new line.
     * 
     * @param sb The buffer to append the description, not <code>null</code>.
     * @param description The description, not <code>null</code>.
     * @param indent The base indentation level of each line, must not be negative.
     */
    private void append( StringBuffer sb, String description, int indent )
    {
        for ( Iterator it = toLines( description, indent, indentSize, lineLength ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( '\n' );
        }
    }

    /** 
     * Splits the specified text into lines of convenient display length.
     * 
     * @param text The text to split into lines, must not be <code>null</code>.
     * @param indent The base indentation level of each line, must not be negative.
     * @param indentSize The size of each indentation, must not be negative.
     * @param lineLength The length of the line, must not be negative.
     * @return The sequence of display lines, never <code>null</code>.
     * @throws NegativeArraySizeException if <code>indent < 0</code>
     */
    private static List toLines( String text, int indent, int indentSize, int lineLength )
    {
        List lines = new ArrayList();

        String ind = repeat( "\t", indent );
        String[] plainLines = text.split( "(\r\n)|(\r)|(\n)" );
        for ( int i = 0; i < plainLines.length; i++ )
        {
            toLines( lines, ind + plainLines[i], indentSize, lineLength );
        }

        return lines;
    }

    /** 
     * Adds the specified line to the output sequence, performing line wrapping if necessary.
     * 
     * @param lines The sequence of display lines, must not be <code>null</code>.
     * @param line The line to add, must not be <code>null</code>.
     * @param indentSize The size of each indentation, must not be negative.
     * @param lineLength The length of the line, must not be negative.
     */
    private static void toLines( List lines, String line, int indentSize, int lineLength )
    {
        int lineIndent = getIndentLevel( line );
        StringBuffer buf = new StringBuffer( 256 );
        String[] tokens = line.split( " +" );
        for ( int i = 0; i < tokens.length; i++ )
        {
            String token = tokens[i];
            if ( i > 0 )
            {
                if ( buf.length() + token.length() >= lineLength )
                {
                    lines.add( buf.toString() );
                    buf.setLength( 0 );
                    buf.append( repeat( " ", lineIndent * indentSize ) );
                }
                else
                {
                    buf.append( ' ' );
                }
            }
            for ( int j = 0; j < token.length(); j++ )
            {
                char c = token.charAt( j );
                if ( c == '\t' )
                {
                    buf.append( repeat( " ", indentSize - buf.length() % indentSize ) );
                }
                else if ( c == '\u00A0' )
                {
                    buf.append( ' ' );
                }
                else
                {
                    buf.append( c );
                }
            }
        }
        lines.add( buf.toString() );
    }

    /** 
     * Gets the indentation level of the specified line.
     * 
     * @param line The line whose indentation level should be retrieved, must not be <code>null</code>.
     * @return The indentation level of the line.
     */
    private static int getIndentLevel( String line )
    {
        int level = 0;
        for ( int i = 0; i < line.length() && line.charAt( i ) == '\t'; i++ )
        {
            level++;
        }
        for ( int i = level + 1; i <= level + 4 && i < line.length(); i++ )
        {
            if ( line.charAt( i ) == '\t' )
            {
                level++;
                break;
            }
        }
        return level;
    }
}
