/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.clirr;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.sf.clirr.core.ApiDifference;
import net.sf.clirr.core.DiffListenerAdapter;
import net.sf.clirr.core.Severity;

public class ClirrDiffListener
extends DiffListenerAdapter {
    private List apiDifferences = new LinkedList();
    private Map counts = new HashMap(3);

    public void reportDiff(ApiDifference apiDifference) {
        this.incrementCount(apiDifference.getMaximumSeverity(), this.counts);
        this.apiDifferences.add(apiDifference);
    }

    public void stop() {
        Collections.sort(this.apiDifferences, new Comparator(){

            public int compare(Object o1, Object o2) {
                ApiDifference d1 = (ApiDifference)o1;
                ApiDifference d2 = (ApiDifference)o2;
                return d2.getMaximumSeverity().compareTo((Object)d1.getMaximumSeverity());
            }
        });
    }

    private void incrementCount(Severity sev, Map counts) {
        if (sev != null) {
            int count = this.getCount(counts, sev);
            counts.put(sev, new Integer(count + 1));
        }
    }

    private int getCount(Map counts, Severity sev) {
        Integer count = (Integer)counts.get(sev);
        if (count == null) {
            count = new Integer(0);
        }
        return count;
    }

    public List getApiDifferences() {
        return Collections.unmodifiableList(this.apiDifferences);
    }

    public int getSeverityCount(Severity severity) {
        return this.getCount(this.counts, severity);
    }
}

