/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.clirr;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.clirr.core.ApiDifference;
import net.sf.clirr.core.DiffListener;
import net.sf.clirr.core.Severity;
import org.codehaus.mojo.clirr.Difference;
import org.codehaus.mojo.clirr.MojoDiffListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DelegatingListener
implements MojoDiffListener {
    private final List<DiffListener> listeners;
    private final Severity minSeverity;
    private final List<Difference> ignored;
    private Map<Difference, Map<Object, List<ApiDifference>>> deferredMatchesPerDifference = new HashMap<Difference, Map<Object, List<ApiDifference>>>();

    public DelegatingListener(List<DiffListener> listeners, Severity minSeverity, List<Difference> ignored) {
        this.listeners = listeners == null ? Collections.emptyList() : listeners;
        this.minSeverity = minSeverity;
        this.ignored = ignored == null ? Collections.emptyList() : ignored;
    }

    public void start() {
        this.deferredMatchesPerDifference.clear();
        for (DiffListener listener : this.listeners) {
            listener.start();
        }
    }

    public void reportDiff(ApiDifference apiDifference) {
        if (this.minSeverity == null || this.minSeverity.compareTo((Object)apiDifference.getMaximumSeverity()) <= 0) {
            Difference reasonToIgnoreDiff = this.getReasonToIgnoreDiff(apiDifference);
            if (reasonToIgnoreDiff == null) {
                this.reportDiff_(apiDifference);
            } else {
                this.reportIgnoredDiff(apiDifference, reasonToIgnoreDiff);
            }
        }
    }

    private void reportDiff_(ApiDifference apiDifference) {
        for (DiffListener listener : this.listeners) {
            listener.reportDiff(apiDifference);
        }
    }

    @Override
    public void reportIgnoredDiff(ApiDifference ignoredDiff, Difference reason) {
        for (DiffListener listener : this.listeners) {
            if (!(listener instanceof MojoDiffListener)) continue;
            MojoDiffListener l = (MojoDiffListener)listener;
            l.reportIgnoredDiff(ignoredDiff, reason);
        }
    }

    public void stop() {
        for (Map.Entry<Difference, Map<Object, List<ApiDifference>>> perDifferenceEntry : this.deferredMatchesPerDifference.entrySet()) {
            Difference diff = perDifferenceEntry.getKey();
            Map<Object, List<ApiDifference>> diffsPerId = perDifferenceEntry.getValue();
            for (List<ApiDifference> apiDiffs : diffsPerId.values()) {
                if (!diff.resolveDefferedMatches(apiDiffs)) {
                    for (ApiDifference apiDiff : apiDiffs) {
                        this.reportDiff_(apiDiff);
                    }
                    continue;
                }
                for (ApiDifference apiDiff : apiDiffs) {
                    this.reportIgnoredDiff(apiDiff, diff);
                }
            }
        }
        for (DiffListener listener : this.listeners) {
            listener.stop();
        }
    }

    private Difference getReasonToIgnoreDiff(ApiDifference apiDiff) {
        if (this.ignored == null) {
            return null;
        }
        boolean someDeferred = false;
        boolean matched = false;
        Difference reason = null;
        for (Difference difference : this.ignored) {
            if (difference == null) continue;
            Difference.Result res = difference.matches(apiDiff);
            switch (res.getCode()) {
                case 0: {
                    if (reason == null) {
                        reason = difference;
                    }
                    matched = true;
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    List<ApiDifference> diffs;
                    Map<Object, List<ApiDifference>> diffsPerDifferentiator = this.deferredMatchesPerDifference.get(difference);
                    if (diffsPerDifferentiator == null) {
                        diffsPerDifferentiator = new HashMap<Object, List<ApiDifference>>();
                        this.deferredMatchesPerDifference.put(difference, diffsPerDifferentiator);
                    }
                    if ((diffs = diffsPerDifferentiator.get(res.getDifferentiator())) == null) {
                        diffs = new ArrayList<ApiDifference>();
                        diffsPerDifferentiator.put(res.getDifferentiator(), diffs);
                    }
                    diffs.add(apiDiff);
                    if (reason == null) {
                        reason = difference;
                    }
                    someDeferred = true;
                }
            }
        }
        if (matched || someDeferred) {
            return reason;
        }
        return null;
    }
}

