/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.codenarc;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class HelpMojo
extends AbstractMojo {
    private boolean detail;
    private String goal;
    private int lineLength;
    private int indentSize;

    public void execute() throws MojoExecutionException {
        if (this.lineLength <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'lineLength' should be positive, using '80' as default.");
            this.lineLength = 80;
        }
        if (this.indentSize <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'indentSize' should be positive, using '2' as default.");
            this.indentSize = 2;
        }
        StringBuffer sb = new StringBuffer();
        this.append(sb, "org.codehaus.mojo:codenarc-maven-plugin:0.22-1", 0);
        this.append(sb, "", 0);
        this.append(sb, "CodeNarc Maven Plugin", 0);
        this.append(sb, "This Plug-In generates reports based on the CodeNarc Analyzer", 1);
        this.append(sb, "", 0);
        if (this.goal == null || this.goal.length() <= 0) {
            this.append(sb, "This plugin has 2 goals:", 0);
            this.append(sb, "", 0);
        }
        if (this.goal == null || this.goal.length() <= 0 || "codenarc".equals(this.goal)) {
            this.append(sb, "codenarc:codenarc", 0);
            this.append(sb, "Create a CodeNarc Report.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "codeNarcVersion (Default: 0.22)", 2);
                this.append(sb, "The CodeNarc version to use for the plugin", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludes", 2);
                this.append(sb, "The comma-separated list of Ant-style file patterns specifying files that must be excluded. See the CodeNarc Command-Line Parameters for the default behavior.", 3);
                this.append(sb, "", 0);
                this.append(sb, "groovyVersion (Default: 1.7.5)", 2);
                this.append(sb, "The Groovy version to use for the plugin", 3);
                this.append(sb, "", 0);
                this.append(sb, "includes", 2);
                this.append(sb, "The comma-separated list of Ant-style file patterns specifying files that must be included. See the CodeNarc Command-Line Parameters for the default behavior.", 3);
                this.append(sb, "", 0);
                this.append(sb, "log4jConfigFile", 2);
                this.append(sb, "The CodeNarc log4j config file. Each path may be optionally prefixed by any of the valid java.net.URL prefixes, such as 'file:' (to load from a relative or absolute filesystem path), or 'http:'.", 3);
                this.append(sb, "", 0);
                this.append(sb, "log4jVersion (Default: 1.2.13)", 2);
                this.append(sb, "The log4j version to use for the plugin", 3);
                this.append(sb, "", 0);
                this.append(sb, "maxHeap (Default: 512)", 2);
                this.append(sb, "Maximum Java heap size in megabytes (default=512).", 3);
                this.append(sb, "", 0);
                this.append(sb, "maxPriority1Violations (Default: -1)", 2);
                this.append(sb, "The maximum number of priority 1 violations allowed before failing the build.", 3);
                this.append(sb, "", 0);
                this.append(sb, "maxPriority2Violations (Default: -1)", 2);
                this.append(sb, "The maximum number of priority 2 violations allowed before failing the build.", 3);
                this.append(sb, "", 0);
                this.append(sb, "maxPriority3Violations (Default: -1)", 2);
                this.append(sb, "The maximum number of priority 3 violations allowed before failing the build.", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory (Default: ${project.reporting.outputDirectory})", 2);
                this.append(sb, "Location where generated html will be created.", 3);
                this.append(sb, "", 0);
                this.append(sb, "rulesetfiles", 2);
                this.append(sb, "The CodeNarc rulesets to use. See the CodeNarc Rule Index for a list of some included. Defaults to the 'rulesets/basic.xml,rulesets/exceptions.xml,rulesets/imports.xml'", 3);
                this.append(sb, "", 0);
                this.append(sb, "skip (Default: false)", 2);
                this.append(sb, "Skip entire check.", 3);
                this.append(sb, "", 0);
                this.append(sb, "sourceDirectory (Default: ${project.build.sourceDirectory})", 2);
                this.append(sb, "Specifies the location of the source directory to be used for CodeNarc.", 3);
                this.append(sb, "", 0);
                this.append(sb, "xmlOutputDirectory (Default: ${project.build.directory})", 2);
                this.append(sb, "Specifies the directory where the xml output will be generated.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "help".equals(this.goal)) {
            this.append(sb, "codenarc:help", 0);
            this.append(sb, "Display help information on codenarc-maven-plugin.\nCall\n\u00a0\u00a0mvn\u00a0codenarc:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "detail (Default: false)", 2);
                this.append(sb, "If true, display all settable properties for each goal.", 3);
                this.append(sb, "", 0);
                this.append(sb, "goal", 2);
                this.append(sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3);
                this.append(sb, "", 0);
                this.append(sb, "indentSize (Default: 2)", 2);
                this.append(sb, "The number of spaces per indentation level, should be positive.", 3);
                this.append(sb, "", 0);
                this.append(sb, "lineLength (Default: 80)", 2);
                this.append(sb, "The maximum length of a display line, should be positive.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)sb.toString());
        }
    }

    private static String repeat(String str, int repeat) {
        StringBuffer buffer = new StringBuffer(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    private void append(StringBuffer sb, String description, int indent) {
        Iterator it = HelpMojo.toLines(description, indent, this.indentSize, this.lineLength).iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append('\n');
        }
    }

    private static List toLines(String text, int indent, int indentSize, int lineLength) {
        ArrayList lines = new ArrayList();
        String ind = HelpMojo.repeat("\t", indent);
        String[] plainLines = text.split("(\r\n)|(\r)|(\n)");
        for (int i = 0; i < plainLines.length; ++i) {
            HelpMojo.toLines(lines, ind + plainLines[i], indentSize, lineLength);
        }
        return lines;
    }

    private static void toLines(List lines, String line, int indentSize, int lineLength) {
        int lineIndent = HelpMojo.getIndentLevel(line);
        StringBuffer buf = new StringBuffer(256);
        String[] tokens = line.split(" +");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (i > 0) {
                if (buf.length() + token.length() >= lineLength) {
                    lines.add(buf.toString());
                    buf.setLength(0);
                    buf.append(HelpMojo.repeat(" ", lineIndent * indentSize));
                } else {
                    buf.append(' ');
                }
            }
            for (int j = 0; j < token.length(); ++j) {
                char c = token.charAt(j);
                if (c == '\t') {
                    buf.append(HelpMojo.repeat(" ", indentSize - buf.length() % indentSize));
                    continue;
                }
                if (c == '\u00a0') {
                    buf.append(' ');
                    continue;
                }
                buf.append(c);
            }
        }
        lines.add(buf.toString());
    }

    private static int getIndentLevel(String line) {
        int i;
        int level = 0;
        for (i = 0; i < line.length() && line.charAt(i) == '\t'; ++i) {
            ++level;
        }
        for (i = level + 1; i <= level + 4 && i < line.length(); ++i) {
            if (line.charAt(i) != '\t') continue;
            ++level;
            break;
        }
        return level;
    }
}

