/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.dashboard.report.plugin.beans;

import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.codehaus.mojo.dashboard.report.plugin.beans.AbstractReportBean;
import org.codehaus.mojo.dashboard.report.plugin.beans.IDashBoardReportBean;

public class TagListReportBean
extends AbstractReportBean {
    private Map tags = new HashMap();
    private int nbTotal = 0;
    private int nbClasses;

    public TagListReportBean() {
    }

    public TagListReportBean(Date dateGeneration) {
        super(dateGeneration);
    }

    public Map getTags() {
        return this.tags;
    }

    public void setTag(String name, Integer count) {
        this.tags.put(name, count);
        this.nbTotal += count.intValue();
    }

    public void addAllEntries(Map entries) {
        if (this.tags.isEmpty()) {
            this.tags.putAll(entries);
        } else {
            Iterator iter = entries.keySet().iterator();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                Integer newValuetoAdd = (Integer)entries.get(key);
                if (this.tags.containsKey(key)) {
                    Integer oldCount = (Integer)this.tags.get(key);
                    this.tags.put(key, new Integer(oldCount + newValuetoAdd));
                    continue;
                }
                this.tags.put(key, newValuetoAdd);
            }
        }
    }

    public void merge(IDashBoardReportBean dashboardReport) {
        if (dashboardReport != null && dashboardReport instanceof TagListReportBean) {
            this.nbTotal += ((TagListReportBean)dashboardReport).getNbTotal();
            this.nbClasses += ((TagListReportBean)dashboardReport).getNbClasses();
            this.addAllEntries(((TagListReportBean)dashboardReport).getTags());
        }
    }

    protected Object clone() {
        TagListReportBean clone = new TagListReportBean(this.getDateGeneration());
        clone.setNbTotal(this.nbTotal);
        clone.setNbClasses(this.nbClasses);
        clone.addAllEntries(this.tags);
        return clone;
    }

    public int getNbTotal() {
        return this.nbTotal;
    }

    public void setNbTotal(int nbTotal) {
        this.nbTotal = nbTotal;
    }

    public int getNbClasses() {
        return this.nbClasses;
    }

    public void setNbClasses(int nbClasses) {
        this.nbClasses = nbClasses;
    }
}

