/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.dashboard.report.plugin.utils;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Date;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.dashboard.report.plugin.beans.CheckstyleError;
import org.codehaus.mojo.dashboard.report.plugin.beans.DashBoardMavenProject;
import org.codehaus.mojo.dashboard.report.plugin.beans.XRefPackageBean;
import org.codehaus.mojo.dashboard.report.plugin.utils.DashXStreamUtilsException;

public class DashXStreamUtils {
    private static DashXStreamUtils xstreamUtils = null;
    XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver());

    private DashXStreamUtils() {
        this.xstream.setMode(1001);
        this.xstream.alias("MavenProject", DashBoardMavenProject.class);
        this.xstream.alias("xrefpackage", XRefPackageBean.class);
        this.xstream.alias("checkstyleerror", CheckstyleError.class);
        this.xstream.useAttributeFor("id", Long.class);
        this.xstream.useAttributeFor("artifactId", String.class);
        this.xstream.useAttributeFor("groupId", String.class);
        this.xstream.useAttributeFor("version", String.class);
        this.xstream.useAttributeFor("projectName", String.class);
        this.xstream.useAttributeFor("generatedDate", Date.class);
        this.xstream.useAttributeFor("averageAfferentCoupling", String.class);
        this.xstream.useAttributeFor("nbPackages", String.class);
        this.xstream.useAttributeFor("sumAC", String.class);
    }

    public static DashXStreamUtils getInstance() {
        if (xstreamUtils == null) {
            xstreamUtils = new DashXStreamUtils();
        }
        return xstreamUtils;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DashBoardMavenProject readXMLDashBoardReport(MavenProject project, String dashboardDataFile) throws DashXStreamUtilsException {
        DashBoardMavenProject mavenProject = null;
        try {
            File fichier = new File(project.getBuild().getDirectory(), dashboardDataFile);
            FileInputStream fis = new FileInputStream(fichier);
            try {
                mavenProject = (DashBoardMavenProject)this.xstream.fromXML((InputStream)fis);
            }
            finally {
                fis.close();
            }
        }
        catch (FileNotFoundException e) {
            System.out.println("readXMLDashBoardReport() for project " + project.getName() + " failed :" + e.getMessage());
            throw new DashXStreamUtilsException("readXMLDashBoardReport() for project " + project.getName() + " failed .", e.fillInStackTrace());
        }
        catch (IOException ioe) {
            throw new DashXStreamUtilsException("readXMLDashBoardReport() for project " + project.getName() + " failed .", ioe.fillInStackTrace());
        }
        return mavenProject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveXMLDashBoardReport(MavenProject project, DashBoardMavenProject mavenProject, String dashboardDataFile) throws DashXStreamUtilsException {
        try {
            File dir = new File(project.getBuild().getDirectory());
            if (!dir.exists()) {
                dir.mkdirs();
            }
            File fichier = new File(dir, dashboardDataFile);
            FileOutputStream fos = new FileOutputStream(fichier);
            OutputStreamWriter output = new OutputStreamWriter((OutputStream)fos, "UTF-8");
            try {
                output.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                this.xstream.toXML((Object)mavenProject, (Writer)output);
            }
            finally {
                fos.close();
            }
        }
        catch (FileNotFoundException e) {
            throw new DashXStreamUtilsException("saveXMLDashBoardReport() for project " + project.getName() + " failed .", e.fillInStackTrace());
        }
        catch (IOException ioe) {
            throw new DashXStreamUtilsException("saveXMLDashBoardReport() for project " + project.getName() + " failed .", ioe.fillInStackTrace());
        }
    }
}

