/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.enforcer;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Collections;
import java.util.HashSet;
import org.apache.maven.enforcer.rule.api.EnforcerRule;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.enforcer.AbstractMojoHausEnforcerRule;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.StringUtils;
import org.freebsd.file.FileEncoding;

public class RequireEncoding
extends AbstractMojoHausEnforcerRule {
    private String encoding = "";
    private String includes = "";
    private String excludes = "";
    private boolean useDefaultExcludes = true;
    private boolean failFast = true;
    private boolean acceptAsciiSubset = false;

    public void execute(EnforcerRuleHelper helper) throws EnforcerRuleException {
        try {
            if (StringUtils.isBlank((String)this.encoding)) {
                this.encoding = (String)helper.evaluate("${project.build.sourceEncoding}");
            }
            Log log = helper.getLog();
            HashSet<String> acceptedEncodings = new HashSet<String>(Collections.singletonList(this.encoding));
            if (this.encoding.equals(StandardCharsets.US_ASCII.name())) {
                log.warn((CharSequence)"Encoding US-ASCII is hard to detect. Use UTF-8 or ISO-8859-1");
            }
            if (this.acceptAsciiSubset && (this.encoding.equals(StandardCharsets.ISO_8859_1.name()) || this.encoding.equals(StandardCharsets.UTF_8.name()))) {
                acceptedEncodings.add(StandardCharsets.US_ASCII.name());
            }
            String basedir = (String)helper.evaluate("${basedir}");
            DirectoryScanner ds = new DirectoryScanner();
            ds.setBasedir(basedir);
            if (StringUtils.isNotBlank((String)this.includes)) {
                ds.setIncludes(this.includes.split("[,|]"));
            }
            if (StringUtils.isNotBlank((String)this.excludes)) {
                ds.setExcludes(this.excludes.split("[,|]"));
            }
            if (this.useDefaultExcludes) {
                ds.addDefaultExcludes();
            }
            ds.scan();
            StringBuilder filesInMsg = new StringBuilder();
            for (String file : ds.getIncludedFiles()) {
                String fileEncoding = this.getEncoding(this.encoding, new File(basedir, file), log);
                if (log.isDebugEnabled()) {
                    log.debug((CharSequence)(file + "==>" + fileEncoding));
                }
                if (fileEncoding == null || acceptedEncodings.contains(fileEncoding)) continue;
                filesInMsg.append(file);
                filesInMsg.append("==>");
                filesInMsg.append(fileEncoding);
                filesInMsg.append("\n");
                if (!this.failFast) continue;
                throw new EnforcerRuleException(filesInMsg.toString());
            }
            if (filesInMsg.length() > 0) {
                throw new EnforcerRuleException("Files not encoded in " + this.encoding + ":\n" + filesInMsg);
            }
        }
        catch (IOException ex) {
            throw new EnforcerRuleException("Reading Files", (Exception)ex);
        }
        catch (ExpressionEvaluationException e) {
            throw new EnforcerRuleException("Unable to lookup an expression " + e.getLocalizedMessage(), (Exception)((Object)e));
        }
    }

    protected String getEncoding(String requiredEncoding, File file, Log log) throws IOException {
        FileEncoding fileEncoding = new FileEncoding();
        if (!fileEncoding.guessFileEncoding(Files.readAllBytes(file.toPath()))) {
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug((CharSequence)String.format("%s: (%s) %s; charset=%s", file, fileEncoding.getCode(), fileEncoding.getType(), fileEncoding.getCodeMime()));
        }
        return fileEncoding.getCodeMime().toUpperCase();
    }

    public String getCacheId() {
        return null;
    }

    public boolean isCacheable() {
        return false;
    }

    public boolean isResultValid(EnforcerRule cachedRule) {
        return false;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getIncludes() {
        return this.includes;
    }

    public void setIncludes(String includes) {
        this.includes = includes;
    }

    public String getExcludes() {
        return this.excludes;
    }

    public void setExcludes(String excludes) {
        this.excludes = excludes;
    }

    public boolean isUseDefaultExcludes() {
        return this.useDefaultExcludes;
    }

    public void setUseDefaultExcludes(boolean useDefaultExcludes) {
        this.useDefaultExcludes = useDefaultExcludes;
    }
}

