/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.extraenforcer.model;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.enforcer.rule.api.AbstractEnforcerRule;
import org.apache.maven.enforcer.rule.api.EnforcerRuleError;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.project.MavenProject;

@Named(value="requireProjectUrl")
public class RequireProjectUrl
extends AbstractEnforcerRule {
    private String regex = "^.+$";
    private final MavenProject project;

    @Inject
    RequireProjectUrl(MavenProject project) {
        this.project = Objects.requireNonNull(project);
    }

    public void execute() throws EnforcerRuleException {
        try {
            if (this.project.getUrl() == null) {
                throw new EnforcerRuleException("The project URL is not defined");
            }
            Matcher matcher = Pattern.compile(this.regex).matcher(this.project.getUrl());
            if (!matcher.matches()) {
                throw new EnforcerRuleException("The project URL " + this.project.getUrl() + " does not match the required regex: " + this.regex);
            }
        }
        catch (PatternSyntaxException e) {
            throw new EnforcerRuleError("Invalid regex \"" + this.regex + "\": " + e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public String toString() {
        return String.format("RequireProjectUrl[regex=%s]", this.regex);
    }
}

