/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.findbugs;

import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.DetectorFactory;
import edu.umd.cs.findbugs.DetectorFactoryCollection;
import edu.umd.cs.findbugs.FindBugs;
import edu.umd.cs.findbugs.Project;
import edu.umd.cs.findbugs.config.UserPreferences;
import edu.umd.cs.findbugs.filter.FilterException;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.DefaultArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.siterenderer.Renderer;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.AbstractMavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.mojo.findbugs.EffortParameter;
import org.codehaus.mojo.findbugs.Reporter;
import org.codehaus.mojo.findbugs.ThresholdParameter;
import org.codehaus.mojo.findbugs.XDocsReporter;
import org.codehaus.plexus.util.FileUtils;

public final class FindBugsMojo
extends AbstractMavenReport {
    private static final String PLUGIN_NAME = "findbugs";
    private static final String BUNDLE_NAME = "findbugs";
    private static final String NAME_KEY = "report.findbugs.name";
    private static final String DESCRIPTION_KEY = "report.findbugs.description";
    private static final String SOURCE_ROOT_KEY = "report.findbugs.sourceRoot";
    private static final String JAVA_SOURCES_KEY = "report.findbugs.javasources";
    private static final String JAVA_REGEX_PATTERN = "**/*.class";
    private static final String JXR_ARTIFACT_ID_KEY = "report.findbugs.jxrplugin.artifactid";
    private static final String FINDBUGS_COREPLUGIN = "report.findbugs.coreplugin";
    private String outputDirectory;
    private boolean xmlOutput;
    private File xmlOutputDirectory;
    private Renderer siteRenderer;
    private File classFilesDirectory;
    private ArrayList pluginArtifacts;
    private DefaultArtifactRepository localRepository;
    private List remoteArtifactRepositories;
    private MavenProject project;
    private String threshold;
    private ArtifactResolver artifactResolver;
    private String includeFilterFile;
    private String excludeFilterFile;
    private String effort;
    private Boolean debug;
    private String visitors;
    private String omitVisitors;
    private String pluginList;
    private BugReporter bugReporter;
    private static boolean pluginLoaded = false;
    static /* synthetic */ Class class$org$codehaus$mojo$findbugs$FindBugsMojo;

    public boolean canGenerateReport() {
        return this.classFilesDirectory.exists();
    }

    public String getDescription(Locale pLocale) {
        ResourceBundle bundle = FindBugsMojo.getBundle(pLocale);
        String description = bundle.getString(DESCRIPTION_KEY);
        return description;
    }

    public String getName(Locale pLocale) {
        ResourceBundle bundle = FindBugsMojo.getBundle(pLocale);
        String name = bundle.getString(NAME_KEY);
        return name;
    }

    public String getOutputName() {
        return "findbugs";
    }

    protected void addClasspathEntriesToFindBugsProject(Project findBugsProject) throws DependencyResolutionRequiredException {
        List entries = this.getProject().getCompileClasspathElements();
        Iterator iterator = entries.iterator();
        while (iterator.hasNext()) {
            String currentEntry = (String)iterator.next();
            this.getLog().debug((CharSequence)("  Adding " + currentEntry + " to auxilary classpath"));
            findBugsProject.addAuxClasspathEntry(currentEntry);
        }
    }

    protected void addFiltersToFindBugs(FindBugs findBugs) throws IOException, FilterException {
        if (this.includeFilterFile != null) {
            if (new File(this.includeFilterFile).exists()) {
                findBugs.addFilter(this.includeFilterFile, true);
                this.getLog().debug((CharSequence)("  Using bug include filter " + this.includeFilterFile));
            } else {
                this.getLog().debug((CharSequence)("  No bug include filter " + this.includeFilterFile + " found"));
            }
        } else {
            this.getLog().info((CharSequence)"  No bug include filter.");
        }
        if (this.excludeFilterFile != null) {
            if (new File(this.excludeFilterFile).exists()) {
                findBugs.addFilter(this.excludeFilterFile, false);
                this.getLog().debug((CharSequence)("  Using bug exclude filter " + this.excludeFilterFile));
            } else {
                this.getLog().debug((CharSequence)("  No bug exclude filter " + this.excludeFilterFile + " found"));
            }
        } else {
            this.getLog().debug((CharSequence)"  No bug exclude filter.");
        }
    }

    protected void addJavaSourcesToFindBugsProject(List pSourceFiles, Project findBugsProject) {
        Iterator iterator = pSourceFiles.iterator();
        while (iterator.hasNext()) {
            File currentSourceFile = (File)iterator.next();
            String filePath = currentSourceFile.getAbsolutePath();
            findBugsProject.addFile(filePath);
        }
    }

    protected void addPluginsToFindBugs(Locale pLocale) throws ArtifactNotFoundException, ArtifactResolutionException, MavenReportException {
        URL[] plugins;
        URL corepluginpath = null;
        try {
            corepluginpath = this.getCorePluginPath(pLocale).toURL();
        }
        catch (MalformedURLException pException) {
            throw new MavenReportException("The core plugin has an invalid URL", (Exception)pException);
        }
        this.getLog().debug((CharSequence)("  coreplugin Jar is located at " + corepluginpath.toString()));
        if (this.pluginList != null) {
            this.getLog().debug((CharSequence)"  Adding Plugins ");
            String[] pluginJars = this.pluginList.split(",");
            plugins = new URL[pluginJars.length + 1];
            for (int i = 0; i < pluginJars.length; ++i) {
                String pluginFile = pluginJars[i].trim();
                if (!pluginFile.endsWith(".jar")) {
                    throw new IllegalArgumentException("Plugin File is not a Jar file: " + pluginFile);
                }
                try {
                    plugins[i + 1] = new File(pluginFile).toURL();
                }
                catch (MalformedURLException pException) {
                    throw new MavenReportException("The addin plugin has an invalid URL", (Exception)pException);
                }
                this.getLog().debug((CharSequence)("  Adding Plugin: " + plugins[i + 1].toString()));
            }
        } else {
            plugins = new URL[]{corepluginpath};
        }
        DetectorFactoryCollection.rawInstance().setPluginList(plugins);
        this.getLog().debug((CharSequence)"  Done Adding Plugins");
    }

    protected void addVisitorsToFindBugs(UserPreferences preferences) {
        if (this.visitors != null || this.omitVisitors != null) {
            String[] visitorList;
            boolean enableVisitor = true;
            if (this.omitVisitors != null) {
                enableVisitor = false;
                visitorList = this.omitVisitors.split(",");
                this.getLog().debug((CharSequence)("  Omitting visitors : " + this.omitVisitors));
            } else {
                visitorList = this.visitors.split(",");
                this.getLog().debug((CharSequence)("  Including visitors : " + this.visitors));
                preferences.enableAllDetectors(false);
            }
            for (int i = 0; i < visitorList.length; ++i) {
                String visitorName = visitorList[i].trim();
                DetectorFactory factory = DetectorFactoryCollection.instance().getFactory(visitorName);
                if (factory == null) {
                    throw new IllegalArgumentException("Unknown detector: " + visitorName);
                }
                preferences.enableDetector(factory, enableVisitor);
            }
        }
    }

    protected void debugJavaSources(Locale pLocale, List pSourceFiles) {
        ResourceBundle bundle = FindBugsMojo.getBundle(pLocale);
        String javaSourceMessage = bundle.getString(JAVA_SOURCES_KEY);
        this.getLog().debug((CharSequence)("  " + javaSourceMessage));
        Iterator iterator = pSourceFiles.iterator();
        while (iterator.hasNext()) {
            File currentFile = (File)iterator.next();
            this.getLog().debug((CharSequence)("    " + currentFile.getAbsolutePath()));
        }
    }

    protected void debugSourceDirectory(Locale pLocale, File pSourceDirectory) {
        ResourceBundle bundle = FindBugsMojo.getBundle(pLocale);
        String sourceRootMessage = bundle.getString(SOURCE_ROOT_KEY);
        this.getLog().debug((CharSequence)("  " + sourceRootMessage));
        this.getLog().debug((CharSequence)("    " + pSourceDirectory.getAbsolutePath()));
    }

    protected void executeReport(Locale pLocale) throws MavenReportException {
        FindBugs findBugs = null;
        this.debugSourceDirectory(pLocale, this.classFilesDirectory);
        try {
            findBugs = this.initialiseFindBugs(pLocale, this.getJavaSources(pLocale, this.classFilesDirectory));
        }
        catch (IOException pException) {
            throw new MavenReportException("A java source file could not be added", (Exception)pException);
        }
        catch (DependencyResolutionRequiredException pException) {
            throw new MavenReportException("Failed executing FindBugs", (Exception)((Object)pException));
        }
        catch (FilterException pException) {
            throw new MavenReportException("Failed adding filters to FindBugs", (Exception)((Object)pException));
        }
        catch (ArtifactNotFoundException pException) {
            throw new MavenReportException("Did not find coreplugin", (Exception)((Object)pException));
        }
        catch (ArtifactResolutionException pException) {
            throw new MavenReportException("Failed to resolve coreplugin", (Exception)((Object)pException));
        }
        try {
            findBugs.execute();
        }
        catch (IOException pException) {
            throw new MavenReportException("Failed executing FindBugs", (Exception)pException);
        }
        catch (InterruptedException pException) {
            throw new MavenReportException("Failed executing FindBugs", (Exception)pException);
        }
        catch (Exception pException) {
            throw new MavenReportException("Failed executing FindBugs", pException);
        }
    }

    protected String getCorePlugin(Locale pLocale) {
        ResourceBundle bundle = FindBugsMojo.getBundle(pLocale);
        String corePluginName = bundle.getString(FINDBUGS_COREPLUGIN);
        return corePluginName;
    }

    protected File getCorePluginPath(Locale pLocale) throws ArtifactNotFoundException, ArtifactResolutionException {
        Iterator it = ((AbstractList)this.pluginArtifacts).iterator();
        while (it.hasNext()) {
            Artifact artifact = (Artifact)it.next();
            if (!artifact.getArtifactId().equals(this.getCorePlugin(pLocale))) continue;
            this.artifactResolver.resolve(artifact, this.remoteArtifactRepositories, (ArtifactRepository)this.localRepository);
            return artifact.getFile();
        }
        return null;
    }

    protected EffortParameter getEffortParameter() {
        EffortParameter effortParameter = EffortParameter.DEFAULT;
        if (this.effort == null) {
            this.getLog().info((CharSequence)"  No effort provided, using default effort.");
        } else if (this.effort.equals(EffortParameter.MAX.getName())) {
            effortParameter = EffortParameter.MAX;
            this.getLog().info((CharSequence)"  Using maximum effort.");
        } else if (this.effort.equals(EffortParameter.DEFAULT.getName())) {
            effortParameter = EffortParameter.DEFAULT;
            this.getLog().info((CharSequence)"  Using normal effort.");
        } else if (this.effort.equals(EffortParameter.MIN.getName())) {
            effortParameter = EffortParameter.MIN;
            this.getLog().info((CharSequence)"  Using minimum effort.");
        } else {
            this.getLog().info((CharSequence)"  Effort not recognised, using default effort");
        }
        return effortParameter;
    }

    protected List getJavaSources(Locale pLocale, File pSourceDirectory) throws IOException {
        ArrayList sourceFiles = new ArrayList();
        if (pSourceDirectory.exists() && pSourceDirectory.isDirectory()) {
            List files = FileUtils.getFiles((File)pSourceDirectory, (String)JAVA_REGEX_PATTERN, null);
            sourceFiles.addAll(files);
        }
        this.debugJavaSources(pLocale, sourceFiles);
        return sourceFiles;
    }

    protected String getOutputDirectory() {
        new File(this.outputDirectory).mkdirs();
        return this.outputDirectory;
    }

    protected MavenProject getProject() {
        return this.project;
    }

    protected Renderer getSiteRenderer() {
        return this.siteRenderer;
    }

    protected ThresholdParameter getThresholdParameter() {
        ThresholdParameter thresholdParameter = ThresholdParameter.DEFAULT;
        if (this.threshold == null) {
            this.getLog().info((CharSequence)"  No threshold provided, using default threshold.");
        } else if (this.threshold.equals(ThresholdParameter.HIGH.getName())) {
            thresholdParameter = ThresholdParameter.HIGH;
            this.getLog().info((CharSequence)"  Using high threshold.");
        } else if (this.threshold.equals(ThresholdParameter.NORMAL.getName())) {
            thresholdParameter = ThresholdParameter.NORMAL;
            this.getLog().info((CharSequence)"  Using normal threshold.");
        } else if (this.threshold.equals(ThresholdParameter.LOW.getName())) {
            thresholdParameter = ThresholdParameter.LOW;
            this.getLog().info((CharSequence)"  Using low threshold.");
        } else if (this.threshold.equals(ThresholdParameter.EXP.getName())) {
            thresholdParameter = ThresholdParameter.EXP;
            this.getLog().info((CharSequence)"  Using exp threshold.");
        } else if (this.threshold.equals(ThresholdParameter.IGNORE.getName())) {
            thresholdParameter = ThresholdParameter.IGNORE;
            this.getLog().info((CharSequence)"  Using ignore threshold.");
        } else {
            this.getLog().info((CharSequence)"  Threshold not recognised, using default threshold");
        }
        return thresholdParameter;
    }

    protected FindBugs initialiseFindBugs(Locale pLocale, List pSourceFiles) throws DependencyResolutionRequiredException, IOException, FilterException, ArtifactNotFoundException, ArtifactResolutionException, MavenReportException {
        Sink sink = this.getSink();
        ResourceBundle bundle = FindBugsMojo.getBundle(pLocale);
        Log log = this.getLog();
        EffortParameter effortParameter = this.getEffortParameter();
        Project findBugsProject = new Project();
        this.bugReporter = this.initialiseReporter(sink, bundle, log, effortParameter);
        if (this.xmlOutput) {
            this.getLog().info((CharSequence)"  Using the xdoc format");
            if (!this.xmlOutputDirectory.exists() && !this.xmlOutputDirectory.mkdirs()) {
                throw new MavenReportException("Cannot create xml output directory");
            }
            BugReporter htmlBugReporter = this.bugReporter;
            this.bugReporter = new XDocsReporter(htmlBugReporter);
            ((XDocsReporter)this.bugReporter).setOutputWriter(new FileWriter(new File(this.xmlOutputDirectory + "/findbugs.xml")));
            ((XDocsReporter)this.bugReporter).setResourceBundle(bundle);
            ((XDocsReporter)this.bugReporter).setLog(log);
            ((XDocsReporter)this.bugReporter).setEffort(this.getEffortParameter());
            ((XDocsReporter)this.bugReporter).setThreshold(this.getThresholdParameter());
        }
        this.addJavaSourcesToFindBugsProject(pSourceFiles, findBugsProject);
        this.addClasspathEntriesToFindBugsProject(findBugsProject);
        FindBugs findBugs = new FindBugs(this.bugReporter, findBugsProject);
        if (!pluginLoaded) {
            this.addPluginsToFindBugs(pLocale);
            pluginLoaded = true;
        }
        UserPreferences preferences = UserPreferences.createDefaultUserPreferences();
        this.addVisitorsToFindBugs(preferences);
        findBugs.setUserPreferences(preferences);
        findBugs.setAnalysisFeatureSettings(effortParameter.getValue());
        findBugs.setDetectorFactoryCollection(DetectorFactoryCollection.rawInstance());
        this.setFindBugsDebug(findBugs);
        this.addFiltersToFindBugs(findBugs);
        return findBugs;
    }

    protected Reporter initialiseReporter(Sink pSink, ResourceBundle pBundle, Log pLog, EffortParameter pEffortParameter) {
        ThresholdParameter thresholdParameter = this.getThresholdParameter();
        boolean isJXRPluginEnabled = this.isJXRPluginEnabled(pBundle);
        Reporter bugReporter = new Reporter(pSink, pBundle, pLog, thresholdParameter, isJXRPluginEnabled, pEffortParameter);
        bugReporter.setPriorityThreshold(thresholdParameter.getValue());
        return bugReporter;
    }

    protected boolean isJXRPluginEnabled(ResourceBundle pBundle) {
        boolean isEnabled = false;
        String artifactId = pBundle.getString(JXR_ARTIFACT_ID_KEY);
        List reportPlugins = this.getProject().getReportPlugins();
        Iterator iterator = reportPlugins.iterator();
        while (iterator.hasNext()) {
            ReportPlugin currentPlugin = (ReportPlugin)iterator.next();
            String currentArtifactId = currentPlugin.getArtifactId();
            if (!artifactId.equals(currentArtifactId)) continue;
            isEnabled = true;
        }
        return isEnabled;
    }

    protected void setFindBugsDebug(FindBugs findBugs) {
        System.setProperty("findbugs.classpath.debug", this.debug.toString());
        System.setProperty("findbugs.debug", this.debug.toString());
        if (this.debug.booleanValue()) {
            this.getLog().info((CharSequence)"  Debugging is On");
        } else {
            this.getLog().info((CharSequence)"  Debugging is Off");
        }
    }

    protected static ResourceBundle getBundle(Locale pLocale) {
        ClassLoader loader = (class$org$codehaus$mojo$findbugs$FindBugsMojo == null ? (class$org$codehaus$mojo$findbugs$FindBugsMojo = FindBugsMojo.class$("org.codehaus.mojo.findbugs.FindBugsMojo")) : class$org$codehaus$mojo$findbugs$FindBugsMojo).getClassLoader();
        ResourceBundle bundle = ResourceBundle.getBundle("findbugs", pLocale, loader);
        return bundle;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

