/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.findbugs;

import edu.umd.cs.findbugs.AbstractBugReporter;
import edu.umd.cs.findbugs.AnalysisError;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugPattern;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BugReporterObserver;
import edu.umd.cs.findbugs.DelegatingBugReporter;
import edu.umd.cs.findbugs.SortedBugCollection;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import java.io.Writer;
import java.util.Iterator;
import java.util.ResourceBundle;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.mojo.findbugs.EffortParameter;
import org.codehaus.mojo.findbugs.FindbugsXdocSink;
import org.codehaus.mojo.findbugs.ThresholdParameter;

public final class XDocsReporter
extends DelegatingBugReporter {
    private static final String NOLINE_KEY = "report.findbugs.noline";
    private FindbugsXdocSink sink = null;
    private ResourceBundle resourceBundle = null;
    private Log log = null;
    private ThresholdParameter threshold = null;
    private EffortParameter effort = null;
    private String currentClassName;
    private boolean isCurrentClassReportOpened = false;
    private SortedBugCollection bugCollection = new SortedBugCollection();
    private Writer outputWriter;

    public XDocsReporter(BugReporter realBugReporter) {
        super(realBugReporter);
        realBugReporter.addObserver(new BugReporterObserver(){

            public void reportBug(BugInstance bugInstance) {
                XDocsReporter.this.addBugReport(bugInstance);
            }
        });
    }

    public void finish() {
        this.printErrors();
        this.getSink().body_();
        this.getSink().flush();
        this.getSink().close();
        super.finish();
    }

    public EffortParameter getEffort() {
        return this.effort;
    }

    public Log getLog() {
        return this.log;
    }

    public Writer getOutputWriter() {
        return this.outputWriter;
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public FindbugsXdocSink getSink() {
        if (this.sink == null) {
            this.sink = new FindbugsXdocSink(this.getOutputWriter());
            this.initialiseReport();
        }
        return this.sink;
    }

    public ThresholdParameter getThreshold() {
        return this.threshold;
    }

    public void logError(String message) {
        this.bugCollection.addError(message);
        super.logError(message);
    }

    public void logError(String message, Throwable e) {
        this.bugCollection.addError(message);
        super.logError(message, e);
    }

    public void observeClass(ClassDescriptor classDescriptor) {
        this.currentClassName = classDescriptor.toDottedClassName();
        if (this.isCurrentClassReportOpened) {
            this.closeClassReportSection();
        }
        this.isCurrentClassReportOpened = false;
        super.observeClass(classDescriptor);
    }

    public void reportMissingClass(ClassDescriptor classDescriptor) {
        this.bugCollection.addMissingClass(classDescriptor.toDottedClassName());
        super.reportMissingClass(classDescriptor);
    }

    public void reportMissingClass(ClassNotFoundException ex) {
        String missingClassName = AbstractBugReporter.getMissingClassName((ClassNotFoundException)ex);
        this.bugCollection.addMissingClass(missingClassName);
        super.reportMissingClass(ex);
    }

    public void setEffort(EffortParameter effort) {
        this.effort = effort;
    }

    public void setLog(Log log) {
        this.log = log;
    }

    public void setOutputWriter(Writer outputWriter) {
        this.outputWriter = outputWriter;
    }

    public void setResourceBundle(ResourceBundle resourceBundle) {
        this.resourceBundle = resourceBundle;
    }

    public void setThreshold(ThresholdParameter threshold) {
        this.threshold = threshold;
    }

    private void initialiseReport() {
        this.getSink().head();
        this.getSink().head_();
        this.getSink().body(this.getFindBugsVersion(), this.threshold.getName(), this.effort.getName());
    }

    protected void addBugReport(BugInstance bugInstance) {
        SourceLineAnnotation line = bugInstance.getPrimarySourceLineAnnotation();
        BugPattern pattern = bugInstance.getBugPattern();
        String lineNumber = this.valueForLine(line);
        String category = pattern.getCategory();
        String type = pattern.getType();
        String priority = this.evaluateThresholdParameter(bugInstance.getPriority());
        String message = bugInstance.getMessage();
        if (!this.isCurrentClassReportOpened) {
            this.getSink().classTag(this.currentClassName);
            this.isCurrentClassReportOpened = true;
        }
        this.getSink().bugInstance(type, priority, category, message, lineNumber);
    }

    protected void closeClassReportSection() {
        this.getSink().classTag_();
    }

    protected String evaluateThresholdParameter(int thresholdValue) {
        String thresholdName;
        switch (thresholdValue) {
            case 1: {
                thresholdName = ThresholdParameter.HIGH.getName();
                break;
            }
            case 2: {
                thresholdName = ThresholdParameter.NORMAL.getName();
                break;
            }
            case 3: {
                thresholdName = ThresholdParameter.LOW.getName();
                break;
            }
            case 4: {
                thresholdName = ThresholdParameter.EXP.getName();
                break;
            }
            case 5: {
                thresholdName = ThresholdParameter.IGNORE.getName();
                break;
            }
            default: {
                thresholdName = "Invalid Priority";
            }
        }
        return thresholdName;
    }

    protected String getFindBugsVersion() {
        return "1.1.1";
    }

    protected void printErrors() {
        this.log.info((CharSequence)"There are Errors");
        this.getSink().errorTag();
        this.log.info((CharSequence)"Printing Errors");
        Iterator i = this.bugCollection.errorIterator();
        while (i.hasNext()) {
            AnalysisError analysisError = (AnalysisError)i.next();
            this.getSink().analysisErrorTag(analysisError.getMessage());
        }
        this.log.info((CharSequence)"Printing Missing classes");
        i = this.bugCollection.missingClassIterator();
        while (i.hasNext()) {
            String missingClass = (String)i.next();
            this.getSink().missingClassTag(missingClass);
        }
        this.getSink().errorTag_();
    }

    protected String valueForLine(SourceLineAnnotation pLine) {
        int endLine;
        int startLine;
        String value = null;
        value = pLine == null ? this.resourceBundle.getString(NOLINE_KEY) : ((startLine = pLine.getStartLine()) == (endLine = pLine.getEndLine()) ? (startLine == -1 ? this.resourceBundle.getString(NOLINE_KEY) : String.valueOf(startLine)) : String.valueOf(startLine) + "-" + String.valueOf(endLine));
        return value;
    }
}

