/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.findbugs;

import java.io.Writer;
import org.apache.maven.doxia.module.HtmlTools;
import org.apache.maven.doxia.sink.SinkAdapter;
import org.apache.maven.doxia.util.LineBreaker;

public final class FindbugsXdocSink
extends SinkAdapter {
    private static final String EOL = System.getProperty("line.separator");
    private LineBreaker out;

    public FindbugsXdocSink(Writer out) {
        this.out = new LineBreaker(out);
    }

    public void analysisErrorTag(String className) {
        this.markup("<AnalysisError>");
        this.markup(className);
        this.markup(" </AnalysisError>" + EOL);
    }

    public void body() {
        this.markup("<BugCollection>" + EOL);
    }

    public void body(String version, String threshold, String effort) {
        this.markup("<BugCollection");
        this.markup(" version=\"" + version + '\"');
        this.markup(" threshold=\"" + threshold + '\"');
        this.markup(" effort=\"" + effort + '\"');
        this.markup(" >" + EOL);
    }

    public void body_() {
        this.markup("</BugCollection>" + EOL);
        this.out.flush();
    }

    public void bugInstance(String type, String priority, String category, String message, String lineNumber) {
        this.markup("<BugInstance");
        this.markup(" type=\"" + HtmlTools.escapeHTML((String)type) + '\"');
        this.markup(" priority=\"" + HtmlTools.escapeHTML((String)priority) + '\"');
        this.markup(" category=\"" + HtmlTools.escapeHTML((String)category) + '\"');
        this.markup(" message=\"" + HtmlTools.escapeHTML((String)message) + '\"');
        this.markup(" lineNumber=\"" + HtmlTools.escapeHTML((String)lineNumber) + '\"');
        this.markup(" />" + EOL);
    }

    public void classTag(String className) {
        this.markup("<file");
        this.markup(" classname=\"" + className + '\"');
        this.markup(" >" + EOL);
    }

    public void classTag_() {
        this.markup("</file>" + EOL);
    }

    public void close() {
        this.out.close();
    }

    public void errorTag() {
        this.markup("<Errors>" + EOL);
    }

    public void errorTag_() {
        this.markup("</Errors>" + EOL);
    }

    public void flush() {
        this.out.flush();
    }

    public void head() {
        this.markup("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>" + EOL);
    }

    public void missingClassTag(String className) {
        this.markup("<MissingClass>");
        this.markup(className);
        this.markup(" </MissingClass>" + EOL);
    }

    protected void markup(String text) {
        this.out.write(text, true);
    }
}

