/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.findbugs;

import edu.umd.cs.findbugs.AnalysisError;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugPattern;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.SortedBugCollection;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.TextUIBugReporter;
import edu.umd.cs.findbugs.Version;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.Set;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.mojo.findbugs.EffortParameter;
import org.codehaus.mojo.findbugs.ThresholdParameter;

public final class Reporter
extends TextUIBugReporter {
    private static final String NOLINE_KEY = "report.findbugs.noline";
    private static final String COLUMN_LINE_KEY = "report.findbugs.column.line";
    private static final String COLUMN_BUG_KEY = "report.findbugs.column.bug";
    private static final String COLUMN_BUGS_KEY = "report.findbugs.column.bugs";
    private static final String COLUMN_CATEGORY_KEY = "report.findbugs.column.category";
    private static final String COLUMN_DETAILS_KEY = "report.findbugs.column.details";
    private static final String REPORT_TITLE_KEY = "report.findbugs.reporttitle";
    private static final String LINKTITLE_KEY = "report.findbugs.linktitle";
    private static final String LINK_KEY = "report.findbugs.link";
    private static final String NAME_KEY = "report.findbugs.name";
    private static final String FILES_KEY = "report.findbugs.files";
    private static final String THRESHOLD_KEY = "report.findbugs.threshold";
    private static final String URL_SEPARATOR = "/";
    private static final String JXR_PATHPREFIX_KEY = "report.findbugs.jxrplugin.pathprefix";
    private static final String EFFORT_KEY = "report.findbugs.effort";
    private static final String DETAILSLINK_KEY = "report.findbugs.detailslink";
    private static final String VERSIONTITLE_KEY = "report.findbugs.versiontitle";
    private static final String SUMMARY_KEY = "report.findbugs.summary";
    private static final String COLUMN_CLASS_KEY = "report.findbugs.column.class";
    private static final String COLUMN_CLASSES_KEY = "report.findbugs.column.classes";
    private static final String COLUMN_ERRORS_KEY = "report.findbugs.column.errors";
    private static final String COLUMN_FILES_KEY = "report.findbugs.column.files";
    private static final String COLUMN_MISSINGCLASSES_KEY = "report.findbugs.column.missingclasses";
    private final Sink sink;
    private final ResourceBundle bundle;
    private final Log mavenLog;
    private final ThresholdParameter threshold;
    private final EffortParameter effort;
    private String currentClassName;
    private boolean mIsCurrentClassReportOpened = false;
    private boolean isJXRReportEnabled = false;
    private SortedBugCollection bugCollection = new SortedBugCollection();
    private int bugCount;
    private int missingClassCount;
    private int fileCount;
    private Set missingClassSet = new HashSet();
    private int errorCount;

    public Reporter(Sink pSink, ResourceBundle pBundle, Log pLog, ThresholdParameter pThreshold, boolean isJXRReportEnabled, EffortParameter pEffort) {
        if (pSink == null) {
            throw new IllegalArgumentException("pSink not allowed to be null");
        }
        if (pBundle == null) {
            throw new IllegalArgumentException("pBundle not allowed to be null");
        }
        if (pLog == null) {
            throw new IllegalArgumentException("pLog not allowed to be null");
        }
        if (pThreshold == null) {
            throw new IllegalArgumentException("pThreshold not allowed to be null");
        }
        if (pEffort == null) {
            throw new IllegalArgumentException("pEffort not allowed to be null");
        }
        this.sink = pSink;
        this.bundle = pBundle;
        this.mavenLog = pLog;
        this.threshold = pThreshold;
        this.isJXRReportEnabled = isJXRReportEnabled;
        this.effort = pEffort;
        this.currentClassName = "";
        this.bugCount = 0;
        this.missingClassCount = 0;
        this.errorCount = 0;
        this.fileCount = 0;
        this.initialiseReport();
    }

    private Reporter() {
        this.sink = null;
        this.bundle = null;
        this.mavenLog = null;
        this.threshold = null;
        this.effort = null;
    }

    public void finish() {
        this.mavenLog.debug((CharSequence)"Finished searching for bugs!");
        this.printSummary();
        this.printFilesSummary();
        this.mIsCurrentClassReportOpened = false;
        Iterator i = this.bugCollection.iterator();
        while (i.hasNext()) {
            BugInstance bugInstance = (BugInstance)i.next();
            this.mavenLog.debug((CharSequence)("Annotation Class is " + bugInstance.getPrimarySourceLineAnnotation().getClassName()));
            this.mavenLog.debug((CharSequence)("Class is " + this.currentClassName));
            this.mavenLog.debug((CharSequence)" ");
            if (!bugInstance.getPrimarySourceLineAnnotation().getClassName().equals(this.currentClassName)) {
                this.currentClassName = bugInstance.getPrimarySourceLineAnnotation().getClassName();
                if (this.mIsCurrentClassReportOpened) {
                    this.closeClassReportSection();
                    this.mIsCurrentClassReportOpened = false;
                }
            }
            this.printBug(bugInstance);
        }
        if (this.mIsCurrentClassReportOpened) {
            this.closeClassReportSection();
        }
        this.sink.section1_();
        this.sink.body_();
        this.sink.flush();
        this.sink.close();
        this.mavenLog.debug((CharSequence)("bugCount = " + this.bugCount));
        this.mavenLog.debug((CharSequence)("errorCount = " + this.errorCount));
        this.mavenLog.debug((CharSequence)("missingClassCount = " + this.missingClassCount));
    }

    public BugReporter getRealBugReporter() {
        return this;
    }

    public void observeClass(ClassDescriptor clazz) {
        this.mavenLog.debug((CharSequence)("Observe class: " + clazz.getClassName()));
        ++this.fileCount;
    }

    public void reportAnalysisError(AnalysisError analysisError) {
        this.mavenLog.debug((CharSequence)("  Found an analysisError: " + analysisError.getMessage()));
        this.bugCollection.addError(analysisError.getMessage());
        ++this.errorCount;
        super.reportAnalysisError(analysisError);
    }

    public void logError(String message) {
        this.mavenLog.debug((CharSequence)("  Found an analysisError: " + message));
        this.bugCollection.addError(message);
        ++this.errorCount;
        super.logError(message);
    }

    public void logError(String message, Throwable e) {
        this.mavenLog.debug((CharSequence)("  Found an analysisError: " + message));
        this.bugCollection.addError(message);
        ++this.errorCount;
        super.logError(message, e);
    }

    public void reportMissingClass(String missingClass) {
        this.mavenLog.debug((CharSequence)("Found a missing class: " + missingClass));
        if (this.missingClassSet.add(missingClass)) {
            ++this.missingClassCount;
        }
        super.reportMissingClass(missingClass);
    }

    public void reportMissingClass(ClassNotFoundException ex) {
        this.mavenLog.debug((CharSequence)("Found a missing class: " + ex.getMessage()));
        if (this.missingClassSet.add(ex.getMessage())) {
            ++this.missingClassCount;
        }
        super.reportMissingClass(ex);
    }

    public void reportMissingClass(ClassDescriptor classDescriptor) {
        this.reportMissingClass(classDescriptor.toDottedClassName());
    }

    private void initialiseReport() {
        this.sink.head();
        this.sink.title();
        this.sink.text(this.getReportTitle());
        this.sink.title_();
        this.sink.head_();
        this.sink.body();
        this.sink.section1();
        this.sink.sectionTitle1();
        this.sink.text(this.getReportTitle());
        this.sink.sectionTitle1_();
        this.sink.paragraph();
        this.sink.text(this.getReportLinkTitle() + " ");
        this.sink.link(this.getFindBugsLink());
        this.sink.text(this.getFindBugsName());
        this.sink.link_();
        this.sink.paragraph_();
        this.sink.paragraph();
        this.sink.text(this.getVersionTitle() + " ");
        this.sink.italic();
        this.sink.text(this.getFindBugsVersion());
        this.sink.italic_();
        this.sink.paragraph_();
        this.sink.paragraph();
        this.sink.text(this.getThresholdTitle() + " ");
        this.sink.italic();
        this.sink.text(this.threshold.getName());
        this.sink.italic_();
        this.sink.paragraph_();
        this.sink.paragraph();
        this.sink.text(this.getEffortTitle() + " ");
        this.sink.italic();
        this.sink.text(this.effort.getName());
        this.sink.italic_();
        this.sink.paragraph_();
        this.sink.section1_();
    }

    protected void printBug(BugInstance bugInstance) {
        SourceLineAnnotation line = bugInstance.getPrimarySourceLineAnnotation();
        BugPattern pattern = bugInstance.getBugPattern();
        String lineNumber = this.valueForLine(line);
        String category = pattern.getCategory();
        String type = pattern.getType();
        this.mavenLog.debug((CharSequence)("Bug line = " + line.getClassName()));
        this.mavenLog.debug((CharSequence)("Bug pattern = " + pattern.getShortDescription()));
        this.mavenLog.debug((CharSequence)("Bug line Number = " + lineNumber));
        this.mavenLog.debug((CharSequence)("Bug Category = " + category));
        this.mavenLog.debug((CharSequence)("Bug Type = " + type));
        this.mavenLog.debug((CharSequence)" ");
        if (!this.mIsCurrentClassReportOpened) {
            this.openClassReportSection();
            this.mIsCurrentClassReportOpened = true;
        }
        this.sink.tableRow();
        this.sink.tableCell();
        this.sink.text(bugInstance.getMessageWithoutPrefix());
        this.sink.tableCell_();
        this.sink.tableCell();
        this.sink.text(category);
        this.sink.tableCell_();
        this.sink.tableCell();
        this.sink.link(this.getDetailsLink(type));
        this.sink.text(type);
        this.sink.link_();
        this.sink.tableCell_();
        this.sink.tableCell();
        if (this.isJXRReportEnabled) {
            this.sink.rawText(this.assembleJXRHyperlink(line, lineNumber));
        } else {
            this.sink.text(lineNumber);
        }
        this.sink.tableCell_();
        this.sink.tableRow_();
    }

    protected String assembleJXRHyperlink(SourceLineAnnotation pLine, String pLineNumber) {
        String hyperlink = null;
        String prefix = this.bundle.getString(JXR_PATHPREFIX_KEY);
        String path = prefix + URL_SEPARATOR + this.currentClassName.replaceAll("[.]", URL_SEPARATOR).replaceAll("[$].*", "");
        hyperlink = pLine == null ? "<a href=" + path + ".html>" + pLineNumber + "</a>" : "<a href=" + path + ".html#" + pLine.getStartLine() + ">" + pLineNumber + "</a>";
        return hyperlink;
    }

    protected void closeClassReportSection() {
        this.mavenLog.debug((CharSequence)"Closing report Section");
        this.sink.table_();
        this.sink.section2_();
    }

    protected void doReportBug(BugInstance bugInstance) {
        this.mavenLog.debug((CharSequence)("  Found a bug: " + bugInstance.getMessage()));
        if (this.bugCollection.add(bugInstance)) {
            ++this.bugCount;
            this.notifyObservers(bugInstance);
        }
    }

    protected String getDetailsLink(String pType) {
        String link = this.bundle.getString(DETAILSLINK_KEY) + "#" + pType;
        return link;
    }

    protected String getEffortTitle() {
        String effortTitle = this.bundle.getString(EFFORT_KEY);
        return effortTitle;
    }

    protected String getFilesTitle() {
        String fileTitle = this.bundle.getString(FILES_KEY);
        return fileTitle;
    }

    protected String getSummaryTitle() {
        String summaryTitle = this.bundle.getString(SUMMARY_KEY);
        return summaryTitle;
    }

    protected String getFindBugsLink() {
        String link = this.bundle.getString(LINK_KEY);
        return link;
    }

    protected String getFindBugsName() {
        String name = this.bundle.getString(NAME_KEY);
        return name;
    }

    protected String getFindBugsVersion() {
        return Version.RELEASE;
    }

    protected String getReportLinkTitle() {
        String reportLink = this.bundle.getString(LINKTITLE_KEY);
        return reportLink;
    }

    protected String getReportTitle() {
        String reportTitle = this.bundle.getString(REPORT_TITLE_KEY);
        return reportTitle;
    }

    protected String getThresholdTitle() {
        String threshholdTitle = this.bundle.getString(THRESHOLD_KEY);
        return threshholdTitle;
    }

    protected String getVersionTitle() {
        String versionTitle = this.bundle.getString(VERSIONTITLE_KEY);
        return versionTitle;
    }

    protected void openClassReportSection() {
        String columnBugText = this.bundle.getString(COLUMN_BUG_KEY);
        String columnBugCategory = this.bundle.getString(COLUMN_CATEGORY_KEY);
        String columnDescriptionLink = this.bundle.getString(COLUMN_DETAILS_KEY);
        String columnLineText = this.bundle.getString(COLUMN_LINE_KEY);
        this.mavenLog.debug((CharSequence)"Opening Class Report Section");
        this.sink.anchor(this.currentClassName);
        this.sink.anchor_();
        this.sink.section2();
        this.sink.sectionTitle2();
        this.sink.text(this.currentClassName);
        this.sink.sectionTitle2_();
        this.sink.table();
        this.sink.tableRow();
        this.sink.tableHeaderCell();
        this.sink.text(columnBugText);
        this.sink.tableHeaderCell_();
        this.sink.tableHeaderCell();
        this.sink.text(columnBugCategory);
        this.sink.tableHeaderCell_();
        this.sink.tableHeaderCell();
        this.sink.text(columnDescriptionLink);
        this.sink.tableHeaderCell_();
        this.sink.tableHeaderCell();
        this.sink.text(columnLineText);
        this.sink.tableHeaderCell_();
        this.sink.tableRow_();
    }

    protected String valueForLine(SourceLineAnnotation pLine) {
        int endLine;
        int startLine;
        String value = null;
        value = pLine == null ? this.bundle.getString(NOLINE_KEY) : ((startLine = pLine.getStartLine()) == (endLine = pLine.getEndLine()) ? (startLine == -1 ? this.bundle.getString(NOLINE_KEY) : String.valueOf(startLine)) : String.valueOf(startLine) + "-" + String.valueOf(endLine));
        return value;
    }

    protected void printSummary() {
        this.sink.sectionTitle1();
        this.sink.text(this.getSummaryTitle());
        this.sink.sectionTitle1_();
        this.sink.table();
        this.sink.tableRow();
        this.sink.tableHeaderCell();
        this.sink.text(this.bundle.getString(COLUMN_CLASSES_KEY));
        this.sink.tableHeaderCell_();
        this.sink.tableHeaderCell();
        this.sink.text(this.bundle.getString(COLUMN_BUGS_KEY));
        this.sink.tableHeaderCell_();
        this.sink.tableHeaderCell();
        this.sink.text(this.bundle.getString(COLUMN_ERRORS_KEY));
        this.sink.tableHeaderCell_();
        this.sink.tableHeaderCell();
        this.sink.text(this.bundle.getString(COLUMN_MISSINGCLASSES_KEY));
        this.sink.tableHeaderCell_();
        this.sink.tableRow_();
        this.sink.tableRow();
        this.sink.tableCell();
        this.sink.text(Integer.toString(this.fileCount));
        this.sink.tableCell_();
        this.sink.tableCell();
        this.sink.text(Integer.toString(this.bugCount));
        this.sink.tableCell_();
        this.sink.tableCell();
        this.sink.text(Integer.toString(this.errorCount));
        this.sink.tableCell_();
        this.sink.tableCell();
        this.sink.text(Integer.toString(this.missingClassCount));
        this.sink.tableCell_();
        this.sink.tableRow_();
        this.sink.table_();
        this.sink.paragraph_();
        this.sink.section1_();
    }

    protected void printFilesSummary() {
        this.sink.sectionTitle1();
        this.sink.text(this.getFilesTitle());
        this.sink.sectionTitle1_();
        int classBugs = 0;
        this.sink.table();
        this.sink.tableRow();
        this.sink.tableHeaderCell();
        this.sink.text(this.bundle.getString(COLUMN_CLASS_KEY));
        this.sink.tableHeaderCell_();
        this.sink.tableHeaderCell();
        this.sink.text(this.bundle.getString(COLUMN_BUGS_KEY));
        this.sink.tableHeaderCell_();
        this.sink.tableRow_();
        Iterator i = this.bugCollection.iterator();
        while (i.hasNext()) {
            BugInstance bugInstance = (BugInstance)i.next();
            this.mavenLog.debug((CharSequence)("Annotation Class is " + bugInstance.getPrimarySourceLineAnnotation().getClassName()));
            this.mavenLog.debug((CharSequence)("Class is " + this.currentClassName));
            this.mavenLog.debug((CharSequence)" ");
            if (bugInstance.getPrimarySourceLineAnnotation().getClassName().equals(this.currentClassName)) {
                ++classBugs;
                continue;
            }
            if (this.currentClassName.length() > 0) {
                this.printFilesSummaryLine(classBugs);
            }
            classBugs = 1;
            this.currentClassName = bugInstance.getPrimarySourceLineAnnotation().getClassName();
        }
        this.printFilesSummaryLine(classBugs);
        this.sink.table_();
    }

    protected void printFilesSummaryLine(int classBugs) {
        this.sink.tableRow();
        this.sink.tableCell();
        this.sink.link("#" + this.currentClassName);
        this.sink.text(this.currentClassName);
        this.sink.link_();
        this.sink.tableCell_();
        this.sink.tableCell();
        this.sink.text(Integer.toString(classBugs));
        this.sink.tableCell_();
        this.sink.tableRow_();
    }
}

