package org.codehaus.mojo.findbugs;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

/**
 * Display help information on findbugs-maven-plugin.<br/> Call <pre>  mvn findbugs:help -Ddetail=true -Dgoal=&lt;goal-name&gt;</pre> to display parameter details.
 *
 * @version generated on Tue Jan 17 10:39:46 EST 2012
 * @author org.apache.maven.tools.plugin.generator.PluginHelpGenerator (version 2.6)
 * @goal help
 * @requiresProject false
 */
public class HelpMojo
    extends AbstractMojo
{
    /**
     * If <code>true</code>, display all settable properties for each goal.
     * 
     * @parameter expression="${detail}" default-value="false"
     */
    private boolean detail;

    /**
     * The name of the goal for which to show help. If unspecified, all goals will be displayed.
     * 
     * @parameter expression="${goal}"
     */
    private java.lang.String goal;

    /**
     * The maximum length of a display line, should be positive.
     * 
     * @parameter expression="${lineLength}" default-value="80"
     */
    private int lineLength;

    /**
     * The number of spaces per indentation level, should be positive.
     * 
     * @parameter expression="${indentSize}" default-value="2"
     */
    private int indentSize;


    /** {@inheritDoc} */
    public void execute()
        throws MojoExecutionException
    {
        if ( lineLength <= 0 )
        {
            getLog().warn( "The parameter 'lineLength' should be positive, using '80' as default." );
            lineLength = 80;
        }
        if ( indentSize <= 0 )
        {
            getLog().warn( "The parameter 'indentSize' should be positive, using '2' as default." );
            indentSize = 2;
        }

        StringBuffer sb = new StringBuffer();

        append( sb, "org.codehaus.mojo:findbugs-maven-plugin:2.4.0", 0 );
        append( sb, "", 0 );

        append( sb, "FindBugs Maven Plugin", 0 );
        append( sb, "This Plug-In generates reports based on the FindBugs Library", 1 );
        append( sb, "", 0 );

        if ( goal == null || goal.length() <= 0 )
        {
            append( sb, "This plugin has 4 goals:", 0 );
            append( sb, "", 0 );
        }

        if ( goal == null || goal.length() <= 0 || "check".equals( goal ) )
        {
            append( sb, "findbugs:check", 0 );
            append( sb, "Fail the build if there were any FindBugs violations in the source code. An XML report is put out by default in the target directory with the errors. To see more documentation about FindBugs\' options, please see the FindBugs Manual..", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "classFilesDirectory (Default: ${project.build.outputDirectory})", 2 );
                append( sb, "Directory containing the class files for FindBugs to analyze.", 3 );
                append( sb, "", 0 );

                append( sb, "debug (Default: false)", 2 );
                append( sb, "turn on Findbugs debugging", 3 );
                append( sb, "", 0 );

                append( sb, "effort (Default: Default)", 2 );
                append( sb, "Effort of the bug finders. Valid values are Min, Default and Max.", 3 );
                append( sb, "", 0 );

                append( sb, "excludeFilterFile", 2 );
                append( sb, "File name of the exclude filter. Bugs matching the filters are not reported.\n\nPotential values are a filesystem path, a URL, or a classpath resource.\n\nThis parameter is resolved as resource, URL, then file. If successfully resolved, the contents of the configuration is copied into the ${project.build.directory} directory before being passed to Findbugs as a filter file.\n", 3 );
                append( sb, "", 0 );

                append( sb, "failOnError (Default: true)", 2 );
                append( sb, "Fail the build on an error.", 3 );
                append( sb, "", 0 );

                append( sb, "findbugsXmlOutput (Default: false)", 2 );
                append( sb, "This has been deprecated and is on by default.", 3 );
                append( sb, "", 0 );

                append( sb, "findbugsXmlOutputDirectory (Default: ${project.build.directory})", 2 );
                append( sb, "Specifies the directory where the findbugs native xml output will be generated.", 3 );
                append( sb, "", 0 );

                append( sb, "fork (Default: true)", 2 );
                append( sb, "Fork a VM for FindBugs analysis. This will allow you to set timeouts and heap size", 3 );
                append( sb, "", 0 );

                append( sb, "includeFilterFile", 2 );
                append( sb, "File name of the include filter. Only bugs in matching the filters are reported.\n\nPotential values are a filesystem path, a URL, or a classpath resource.\n\nThis parameter is resolved as resource, URL, then file. If successfully resolved, the contents of the configuration is copied into the ${project.build.directory} directory before being passed to Findbugs as a filter file.\n", 3 );
                append( sb, "", 0 );

                append( sb, "includeTests (Default: false)", 2 );
                append( sb, "Run Findbugs on the tests.", 3 );
                append( sb, "", 0 );

                append( sb, "maxHeap (Default: 512)", 2 );
                append( sb, "Maximum Java heap size in megabytes (default=512). This only works if the fork parameter is set true.", 3 );
                append( sb, "", 0 );

                append( sb, "nested (Default: false)", 2 );
                append( sb, "This option enables or disables scanning of nested jar and zip files found in the list of files and directories to be analyzed.", 3 );
                append( sb, "", 0 );

                append( sb, "omitVisitors", 2 );
                append( sb, "The visitor list to omit. This is a comma-delimited list.", 3 );
                append( sb, "", 0 );

                append( sb, "onlyAnalyze", 2 );
                append( sb, "Restrict analysis to the given comma-separated list of classes and packages.", 3 );
                append( sb, "", 0 );

                append( sb, "outputDirectory (Default: ${project.reporting.outputDirectory})", 2 );
                append( sb, "Location where generated html will be created.", 3 );
                append( sb, "", 0 );

                append( sb, "outputEncoding (Default: ${project.reporting.outputEncoding})", 2 );
                append( sb, "The file encoding to use when creating the HTML reports. If the property project.reporting.outputEncoding is not set, the platform default encoding is used.", 3 );
                append( sb, "", 0 );

                append( sb, "pluginList", 2 );
                append( sb, "The plugin list to include in the report. This is a comma-delimited list.\n\nPotential values are a filesystem path, a URL, or a classpath resource.\n\nThis parameter is resolved as resource, URL, then file. If successfully resolved, the contents of the configuration is copied into the ${project.build.directory} directory before being passed to Findbugs as a plugin file.\n", 3 );
                append( sb, "", 0 );

                append( sb, "relaxed (Default: false)", 2 );
                append( sb, "Relaxed reporting mode. For many detectors, this option suppresses the heuristics used to avoid reporting false positives.", 3 );
                append( sb, "", 0 );

                append( sb, "skip (Default: false)", 2 );
                append( sb, "Skip entire check.", 3 );
                append( sb, "", 0 );

                append( sb, "sourceEncoding (Default: ${project.build.sourceEncoding})", 2 );
                append( sb, "The file encoding to use when reading the source files. If the property project.build.sourceEncoding is not set, the platform default encoding is used.", 3 );
                append( sb, "", 0 );

                append( sb, "testClassFilesDirectory (Default: ${project.build.testOutputDirectory})", 2 );
                append( sb, "Directory containing the test class files for FindBugs to analyze.", 3 );
                append( sb, "", 0 );

                append( sb, "threshold (Default: Default)", 2 );
                append( sb, "Threshold of minimum bug severity to report. Valid values are High, Default, Low, Ignore, and Exp (for experimental).", 3 );
                append( sb, "", 0 );

                append( sb, "timeout (Default: 600000)", 2 );
                append( sb, "Specifies the amount of time, in milliseconds, that FindBugs may run before it is assumed to be hung and is terminated. The default is 600,000 milliseconds, which is ten minutes. This only works if the fork parameter is set true.", 3 );
                append( sb, "", 0 );

                append( sb, "trace (Default: false)", 2 );
                append( sb, "Prints a trace of detectors run and classes analyzed to standard output. Useful for troubleshooting unexpected analysis failures.", 3 );
                append( sb, "", 0 );

                append( sb, "visitors", 2 );
                append( sb, "The visitor list to run. This is a comma-delimited list.", 3 );
                append( sb, "", 0 );

                append( sb, "xmlOutput (Default: false)", 2 );
                append( sb, "Turn on and off xml output of the Findbugs report.", 3 );
                append( sb, "", 0 );

                append( sb, "xmlOutputDirectory (Default: ${project.build.directory})", 2 );
                append( sb, "Specifies the directory where the xml output will be generated.", 3 );
                append( sb, "", 0 );

                append( sb, "xrefLocation (Default: ${project.reporting.outputDirectory}/xref)", 2 );
                append( sb, "Location of the Xrefs to link to.", 3 );
                append( sb, "", 0 );

                append( sb, "xrefTestLocation (Default: ${project.reporting.outputDirectory}/xref-test)", 2 );
                append( sb, "Location of the Test Xrefs to link to.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "findbugs".equals( goal ) )
        {
            append( sb, "findbugs:findbugs", 0 );
            append( sb, "Generates a FindBugs Report when the site plugin is run. The HTML report is generated for site commands only.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "classFilesDirectory (Default: ${project.build.outputDirectory})", 2 );
                append( sb, "Directory containing the class files for FindBugs to analyze.", 3 );
                append( sb, "", 0 );

                append( sb, "debug (Default: false)", 2 );
                append( sb, "turn on Findbugs debugging", 3 );
                append( sb, "", 0 );

                append( sb, "effort (Default: Default)", 2 );
                append( sb, "Effort of the bug finders. Valid values are Min, Default and Max.", 3 );
                append( sb, "", 0 );

                append( sb, "excludeFilterFile", 2 );
                append( sb, "File name of the exclude filter. Bugs matching the filters are not reported.\n\nPotential values are a filesystem path, a URL, or a classpath resource.\n\nThis parameter is resolved as resource, URL, then file. If successfully resolved, the contents of the configuration is copied into the ${project.build.directory} directory before being passed to Findbugs as a filter file.\nThis is a comma-delimited list.", 3 );
                append( sb, "", 0 );

                append( sb, "failOnError (Default: true)", 2 );
                append( sb, "Fail the build on an error.", 3 );
                append( sb, "", 0 );

                append( sb, "findbugsXmlOutput (Default: false)", 2 );
                append( sb, "This has been deprecated and is on by default.", 3 );
                append( sb, "", 0 );

                append( sb, "findbugsXmlOutputDirectory (Default: ${project.build.directory})", 2 );
                append( sb, "Specifies the directory where the findbugs native xml output will be generated.", 3 );
                append( sb, "", 0 );

                append( sb, "fork (Default: true)", 2 );
                append( sb, "Fork a VM for FindBugs analysis. This will allow you to set timeouts and heap size", 3 );
                append( sb, "", 0 );

                append( sb, "includeFilterFile", 2 );
                append( sb, "File name of the include filter. Only bugs in matching the filters are reported.\n\nPotential values are a filesystem path, a URL, or a classpath resource.\n\nThis parameter is resolved as resource, URL, then file. If successfully resolved, the contents of the configuration is copied into the ${project.build.directory} directory before being passed to Findbugs as a filter file.\nThis is a comma-delimited list.", 3 );
                append( sb, "", 0 );

                append( sb, "includeTests (Default: false)", 2 );
                append( sb, "Run Findbugs on the tests.", 3 );
                append( sb, "", 0 );

                append( sb, "maxHeap (Default: 512)", 2 );
                append( sb, "Maximum Java heap size in megabytes (default=512). This only works if the fork parameter is set true.", 3 );
                append( sb, "", 0 );

                append( sb, "nested (Default: false)", 2 );
                append( sb, "This option enables or disables scanning of nested jar and zip files found in the list of files and directories to be analyzed.", 3 );
                append( sb, "", 0 );

                append( sb, "omitVisitors", 2 );
                append( sb, "The visitor list to omit. This is a comma-delimited list.", 3 );
                append( sb, "", 0 );

                append( sb, "onlyAnalyze", 2 );
                append( sb, "Restrict analysis to the given comma-separated list of classes and packages.", 3 );
                append( sb, "", 0 );

                append( sb, "outputDirectory (Default: ${project.reporting.outputDirectory})", 2 );
                append( sb, "Location where generated html will be created.", 3 );
                append( sb, "", 0 );

                append( sb, "outputEncoding (Default: ${project.reporting.outputEncoding})", 2 );
                append( sb, "The file encoding to use when creating the HTML reports. If the property project.reporting.outputEncoding is not set, the platform default encoding is used.", 3 );
                append( sb, "", 0 );

                append( sb, "pluginList", 2 );
                append( sb, "The plugin list to include in the report. This is a comma-delimited list.\n\nPotential values are a filesystem path, a URL, or a classpath resource.\n\nThis parameter is resolved as resource, URL, then file. If successfully resolved, the contents of the configuration is copied into the ${project.build.directory} directory before being passed to Findbugs as a plugin file.\n", 3 );
                append( sb, "", 0 );

                append( sb, "relaxed (Default: false)", 2 );
                append( sb, "Relaxed reporting mode. For many detectors, this option suppresses the heuristics used to avoid reporting false positives.", 3 );
                append( sb, "", 0 );

                append( sb, "skip (Default: false)", 2 );
                append( sb, "Skip entire check.", 3 );
                append( sb, "", 0 );

                append( sb, "sourceEncoding (Default: ${project.build.sourceEncoding})", 2 );
                append( sb, "The file encoding to use when reading the source files. If the property project.build.sourceEncoding is not set, the platform default encoding is used.", 3 );
                append( sb, "", 0 );

                append( sb, "testClassFilesDirectory (Default: ${project.build.testOutputDirectory})", 2 );
                append( sb, "Directory containing the test class files for FindBugs to analyze.", 3 );
                append( sb, "", 0 );

                append( sb, "threshold (Default: Default)", 2 );
                append( sb, "Threshold of minimum bug severity to report. Valid values are High, Default, Low, Ignore, and Exp (for experimental).", 3 );
                append( sb, "", 0 );

                append( sb, "timeout (Default: 600000)", 2 );
                append( sb, "Specifies the amount of time, in milliseconds, that FindBugs may run before it is assumed to be hung and is terminated. The default is 600,000 milliseconds, which is ten minutes. This only works if the fork parameter is set true.", 3 );
                append( sb, "", 0 );

                append( sb, "trace (Default: false)", 2 );
                append( sb, "Prints a trace of detectors run and classes analyzed to standard output. Useful for troubleshooting unexpected analysis failures.", 3 );
                append( sb, "", 0 );

                append( sb, "visitors", 2 );
                append( sb, "The visitor list to run. This is a comma-delimited list.", 3 );
                append( sb, "", 0 );

                append( sb, "xmlOutput (Default: false)", 2 );
                append( sb, "Turn on and off xml output of the Findbugs report.", 3 );
                append( sb, "", 0 );

                append( sb, "xmlOutputDirectory (Default: ${project.build.directory})", 2 );
                append( sb, "Specifies the directory where the xml output will be generated.", 3 );
                append( sb, "", 0 );

                append( sb, "xrefLocation (Default: ${project.reporting.outputDirectory}/xref)", 2 );
                append( sb, "Location of the Xrefs to link to.", 3 );
                append( sb, "", 0 );

                append( sb, "xrefTestLocation (Default: ${project.reporting.outputDirectory}/xref-test)", 2 );
                append( sb, "Location of the Test Xrefs to link to.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "gui".equals( goal ) )
        {
            append( sb, "findbugs:gui", 0 );
            append( sb, "Launch the Findbugs GUI. It will use all the parameters in the POM fle.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "classFilesDirectory (Default: ${project.build.outputDirectory})", 2 );
                append( sb, "Directory containing the class files for FindBugs to analyze.", 3 );
                append( sb, "", 0 );

                append( sb, "debug (Default: false)", 2 );
                append( sb, "turn on Findbugs debugging", 3 );
                append( sb, "", 0 );

                append( sb, "effort (Default: Default)", 2 );
                append( sb, "Effort of the bug finders. Valid values are Min, Default and Max.", 3 );
                append( sb, "", 0 );

                append( sb, "encoding (Default: ${project.build.sourceEncoding})", 2 );
                append( sb, "The file encoding to use when reading the source files. If the property project.build.sourceEncoding is not set, the platform default encoding is used. Note: This parameter always overrides the property charset from Checkstyle\'s TreeWalker module.", 3 );
                append( sb, "", 0 );

                append( sb, "findbugsXmlOutputDirectory (Default: ${project.build.directory})", 2 );
                append( sb, "Specifies the directory where the findbugs native xml output will be generated.", 3 );
                append( sb, "", 0 );

                append( sb, "maxHeap (Default: 512)", 2 );
                append( sb, "Maximum Java heap size in megabytes (default=512).", 3 );
                append( sb, "", 0 );

                append( sb, "pluginList", 2 );
                append( sb, "The plugin list to include in the report. This is a comma-delimited list.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "help".equals( goal ) )
        {
            append( sb, "findbugs:help", 0 );
            append( sb, "Display help information on findbugs-maven-plugin.\nCall\n\u00a0\u00a0mvn\u00a0findbugs:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "detail (Default: false)", 2 );
                append( sb, "If true, display all settable properties for each goal.", 3 );
                append( sb, "", 0 );

                append( sb, "goal", 2 );
                append( sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3 );
                append( sb, "", 0 );

                append( sb, "indentSize (Default: 2)", 2 );
                append( sb, "The number of spaces per indentation level, should be positive.", 3 );
                append( sb, "", 0 );

                append( sb, "lineLength (Default: 80)", 2 );
                append( sb, "The maximum length of a display line, should be positive.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( getLog().isInfoEnabled() )
        {
            getLog().info( sb.toString() );
        }
    }

    /**
     * <p>Repeat a String <code>n</code> times to form a new string.</p>
     *
     * @param str String to repeat
     * @param repeat number of times to repeat str
     * @return String with repeated String
     * @throws NegativeArraySizeException if <code>repeat < 0</code>
     * @throws NullPointerException if str is <code>null</code>
     */
    private static String repeat( String str, int repeat )
    {
        StringBuffer buffer = new StringBuffer( repeat * str.length() );

        for ( int i = 0; i < repeat; i++ )
        {
            buffer.append( str );
        }

        return buffer.toString();
    }

    /** 
     * Append a description to the buffer by respecting the indentSize and lineLength parameters.
     * <b>Note</b>: The last character is always a new line.
     * 
     * @param sb The buffer to append the description, not <code>null</code>.
     * @param description The description, not <code>null</code>.
     * @param indent The base indentation level of each line, must not be negative.
     */
    private void append( StringBuffer sb, String description, int indent )
    {
        for ( Iterator it = toLines( description, indent, indentSize, lineLength ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( '\n' );
        }
    }

    /** 
     * Splits the specified text into lines of convenient display length.
     * 
     * @param text The text to split into lines, must not be <code>null</code>.
     * @param indent The base indentation level of each line, must not be negative.
     * @param indentSize The size of each indentation, must not be negative.
     * @param lineLength The length of the line, must not be negative.
     * @return The sequence of display lines, never <code>null</code>.
     * @throws NegativeArraySizeException if <code>indent < 0</code>
     */
    private static List toLines( String text, int indent, int indentSize, int lineLength )
    {
        List lines = new ArrayList();

        String ind = repeat( "\t", indent );
        String[] plainLines = text.split( "(\r\n)|(\r)|(\n)" );
        for ( int i = 0; i < plainLines.length; i++ )
        {
            toLines( lines, ind + plainLines[i], indentSize, lineLength );
        }

        return lines;
    }

    /** 
     * Adds the specified line to the output sequence, performing line wrapping if necessary.
     * 
     * @param lines The sequence of display lines, must not be <code>null</code>.
     * @param line The line to add, must not be <code>null</code>.
     * @param indentSize The size of each indentation, must not be negative.
     * @param lineLength The length of the line, must not be negative.
     */
    private static void toLines( List lines, String line, int indentSize, int lineLength )
    {
        int lineIndent = getIndentLevel( line );
        StringBuffer buf = new StringBuffer( 256 );
        String[] tokens = line.split( " +" );
        for ( int i = 0; i < tokens.length; i++ )
        {
            String token = tokens[i];
            if ( i > 0 )
            {
                if ( buf.length() + token.length() >= lineLength )
                {
                    lines.add( buf.toString() );
                    buf.setLength( 0 );
                    buf.append( repeat( " ", lineIndent * indentSize ) );
                }
                else
                {
                    buf.append( ' ' );
                }
            }
            for ( int j = 0; j < token.length(); j++ )
            {
                char c = token.charAt( j );
                if ( c == '\t' )
                {
                    buf.append( repeat( " ", indentSize - buf.length() % indentSize ) );
                }
                else if ( c == '\u00A0' )
                {
                    buf.append( ' ' );
                }
                else
                {
                    buf.append( c );
                }
            }
        }
        lines.add( buf.toString() );
    }

    /** 
     * Gets the indentation level of the specified line.
     * 
     * @param line The line whose indentation level should be retrieved, must not be <code>null</code>.
     * @return The indentation level of the line.
     */
    private static int getIndentLevel( String line )
    {
        int level = 0;
        for ( int i = 0; i < line.length() && line.charAt( i ) == '\t'; i++ )
        {
            level++;
        }
        for ( int i = level + 1; i <= level + 4 && i < line.length(); i++ )
        {
            if ( line.charAt( i ) == '\t' )
            {
                level++;
                break;
            }
        }
        return level;
    }
}
