/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.flatten;

import java.util.HashMap;
import java.util.Map;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.model.Model;
import org.apache.maven.model.ModelBase;
import org.apache.maven.model.building.ModelBuildingRequest;
import org.apache.maven.model.building.ModelProblemCollector;
import org.apache.maven.model.inheritance.DefaultInheritanceAssembler;
import org.codehaus.mojo.flatten.FlattenDependencyMode;

@Singleton
@Named
public class DirectDependenciesInheritanceAssembler
extends DefaultInheritanceAssembler {
    protected DefaultInheritanceAssembler.InheritanceModelMerger merger = new DirectDependenciesInheritanceModelMerger();
    private static final String CHILD_DIRECTORY = "child-directory";
    private static final String CHILD_DIRECTORY_PROPERTY = "project.directory";
    protected FlattenDependencyMode flattenDependencyMode;

    public void assembleModelInheritance(Model child, Model parent, ModelBuildingRequest request, ModelProblemCollector problems) {
        HashMap<String, String> hints = new HashMap<String, String>();
        String childPath = child.getProperties().getProperty(CHILD_DIRECTORY_PROPERTY, child.getArtifactId());
        hints.put(CHILD_DIRECTORY, childPath);
        hints.put("child-path-adjustment", this.getChildPathAdjustment(child, parent, childPath));
        this.merger.merge(child, parent, false, hints);
    }

    private String getChildPathAdjustment(Model child, Model parent, String childDirectory) {
        String adjustment = "";
        if (parent != null) {
            String childName = child.getArtifactId();
            if (child.getProjectDirectory() != null) {
                childName = child.getProjectDirectory().getName();
            }
            for (String module : parent.getModules()) {
                int lastSlash;
                String moduleName;
                if ((module = module.replace('\\', '/')).regionMatches(true, module.length() - 4, ".xml", 0, 4)) {
                    module = module.substring(0, module.lastIndexOf(47) + 1);
                }
                if ((moduleName = module).endsWith("/")) {
                    moduleName = moduleName.substring(0, moduleName.length() - 1);
                }
                if (!(moduleName = moduleName.substring((lastSlash = moduleName.lastIndexOf(47)) + 1)).equals(childName) && !moduleName.equals(childDirectory) || lastSlash < 0) continue;
                adjustment = module.substring(0, lastSlash);
                break;
            }
        }
        return adjustment;
    }

    protected class DirectDependenciesInheritanceModelMerger
    extends DefaultInheritanceAssembler.InheritanceModelMerger {
        protected DirectDependenciesInheritanceModelMerger() {
        }

        public void merge(Model target, Model source, boolean sourceDominant, Map<?, ?> hints) {
            super.merge(target, source, sourceDominant, hints);
        }

        protected void mergeModelBase_Dependencies(ModelBase target, ModelBase source, boolean sourceDominant, Map<Object, Object> context) {
            if (DirectDependenciesInheritanceAssembler.this.flattenDependencyMode == FlattenDependencyMode.direct) {
                return;
            }
            super.mergeModelBase_Dependencies(target, source, sourceDominant, context);
        }
    }
}

