/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.flatten.cifriendly;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.plexus.interpolation.InterpolationCycleException;
import org.codehaus.plexus.interpolation.InterpolationException;
import org.codehaus.plexus.interpolation.InterpolationPostProcessor;
import org.codehaus.plexus.interpolation.Interpolator;
import org.codehaus.plexus.interpolation.RecursionInterceptor;
import org.codehaus.plexus.interpolation.SimpleRecursionInterceptor;
import org.codehaus.plexus.interpolation.ValueSource;

public class CiInterpolatorImpl
implements Interpolator {
    private final Map existingAnswers = new HashMap();
    private final List<ValueSource> valueSources = new ArrayList<ValueSource>();
    private final List<InterpolationPostProcessor> postProcessors = new ArrayList<InterpolationPostProcessor>();
    private boolean cacheAnswers = false;
    public static final String DEFAULT_START_EXPR = "${";
    public static final String DEFAULT_END_EXPR = "}";
    private final String startExpr;
    private final String endExpr;

    public CiInterpolatorImpl() {
        this.startExpr = DEFAULT_START_EXPR;
        this.endExpr = DEFAULT_END_EXPR;
    }

    public CiInterpolatorImpl(String startExpr, String endExpr) {
        this.startExpr = startExpr;
        this.endExpr = endExpr;
    }

    public void addValueSource(ValueSource valueSource) {
        this.valueSources.add(valueSource);
    }

    public void removeValuesSource(ValueSource valueSource) {
        this.valueSources.remove(valueSource);
    }

    public void addPostProcessor(InterpolationPostProcessor postProcessor) {
        this.postProcessors.add(postProcessor);
    }

    public void removePostProcessor(InterpolationPostProcessor postProcessor) {
        this.postProcessors.remove(postProcessor);
    }

    public String interpolate(String input, String thisPrefixPattern) throws InterpolationException {
        return this.interpolate(input, (RecursionInterceptor)new SimpleRecursionInterceptor());
    }

    public String interpolate(String input, String thisPrefixPattern, RecursionInterceptor recursionInterceptor) throws InterpolationException {
        return this.interpolate(input, recursionInterceptor);
    }

    public String interpolate(String input) throws InterpolationException {
        return this.interpolate(input, (RecursionInterceptor)new SimpleRecursionInterceptor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String interpolate(String input, RecursionInterceptor recursionInterceptor) throws InterpolationException {
        try {
            String string = this.interpolate(input, recursionInterceptor, new HashSet<String>());
            return string;
        }
        finally {
            if (!this.cacheAnswers) {
                this.existingAnswers.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String interpolate(String input, RecursionInterceptor recursionInterceptor, Set<String> unresolvable) throws InterpolationException {
        int startIdx;
        if (input == null) {
            return "";
        }
        StringBuilder result = new StringBuilder(input.length() * 2);
        int endIdx = -1;
        while ((startIdx = input.indexOf(this.startExpr, endIdx + 1)) > -1) {
            result.append(input, endIdx + 1, startIdx);
            endIdx = input.indexOf(this.endExpr, startIdx + 1);
            if (endIdx < 0) break;
            String wholeExpr = input.substring(startIdx, endIdx + this.endExpr.length());
            String realExpr = wholeExpr.substring(this.startExpr.length(), wholeExpr.length() - this.endExpr.length());
            boolean resolved = false;
            if (!unresolvable.contains(wholeExpr)) {
                if (realExpr.startsWith(".")) {
                    realExpr = realExpr.substring(1);
                }
                if (recursionInterceptor.hasRecursiveExpression(realExpr)) {
                    throw new InterpolationCycleException(recursionInterceptor, realExpr, wholeExpr);
                }
                recursionInterceptor.expressionResolutionStarted(realExpr);
                try {
                    Object value = null;
                    if (wholeExpr.equals("${revision}") || wholeExpr.contains("${sha1}") || wholeExpr.contains("${changelist}")) {
                        value = this.existingAnswers.get(realExpr);
                        Object bestAnswer = null;
                        for (ValueSource valueSource : this.valueSources) {
                            if (value != null) break;
                            value = valueSource.getValue(realExpr);
                            if (value == null || !value.toString().contains(wholeExpr)) continue;
                            bestAnswer = value;
                            value = null;
                        }
                        if (value == null && bestAnswer != null) {
                            throw new InterpolationCycleException(recursionInterceptor, realExpr, wholeExpr);
                        }
                    }
                    if (value != null) {
                        value = this.interpolate(String.valueOf(value), recursionInterceptor, unresolvable);
                        if (!this.postProcessors.isEmpty()) {
                            for (InterpolationPostProcessor postProcessor : this.postProcessors) {
                                Object newVal = postProcessor.execute(realExpr, value);
                                if (newVal == null) continue;
                                value = newVal;
                                break;
                            }
                        }
                        result.append(value);
                        resolved = true;
                    } else {
                        unresolvable.add(wholeExpr);
                    }
                }
                finally {
                    recursionInterceptor.expressionResolutionFinished(realExpr);
                }
            }
            if (!resolved) {
                result.append(wholeExpr);
            }
            endIdx += this.endExpr.length() - 1;
        }
        if (endIdx == -1 && startIdx > -1) {
            result.append(input, startIdx, input.length());
        } else if (endIdx < input.length()) {
            result.append(input, endIdx + 1, input.length());
        }
        return result.toString();
    }

    public List getFeedback() {
        ArrayList messages = new ArrayList();
        for (ValueSource vs : this.valueSources) {
            List feedback = vs.getFeedback();
            if (feedback == null || feedback.isEmpty()) continue;
            messages.addAll(feedback);
        }
        return messages;
    }

    public void clearFeedback() {
        for (ValueSource vs : this.valueSources) {
            vs.clearFeedback();
        }
    }

    public boolean isCacheAnswers() {
        return this.cacheAnswers;
    }

    public void setCacheAnswers(boolean cacheAnswers) {
        this.cacheAnswers = cacheAnswers;
    }

    public void clearAnswers() {
        this.existingAnswers.clear();
    }
}

