/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.groovy;

import groovy.lang.GroovyClassLoader;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.model.fileset.FileSet;
import org.apache.maven.shared.model.fileset.util.FileSetManager;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.mojo.pluginsupport.MojoSupport;
import org.codehaus.mojo.pluginsupport.util.ArtifactItem;

public abstract class CompilationMojoSupport
extends MojoSupport {
    private String sourceEncoding;
    private boolean verbose;
    private boolean debug;
    private boolean stacktrace;
    private int tolerance;
    private String scriptBaseClassname;
    private String defaultScriptExtension;
    private ArtifactItem[] classpath;
    protected FileSet[] sources;
    protected MavenProject project = null;
    private ArtifactRepository artifactRepository;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected MavenProject getProject() {
        return this.project;
    }

    protected ArtifactRepository getArtifactRepository() {
        return this.artifactRepository;
    }

    protected abstract List getProjectClasspathElements() throws DependencyResolutionRequiredException;

    protected abstract File getOutputDirectory() throws Exception;

    protected abstract FileSet[] getDefaultSources();

    private CompilerConfiguration createCompilerConfiguration() throws Exception {
        CompilerConfiguration config = new CompilerConfiguration();
        config.setDebug(this.stacktrace);
        config.setSourceEncoding(this.sourceEncoding);
        config.setVerbose(this.verbose);
        config.setDebug(this.debug);
        config.setTolerance(this.tolerance);
        config.setTargetDirectory(this.getOutputDirectory());
        if (this.scriptBaseClassname != null) {
            config.setScriptBaseClass(this.scriptBaseClassname);
        }
        if (this.defaultScriptExtension != null) {
            config.setDefaultScriptExtension(this.defaultScriptExtension);
        }
        return config;
    }

    private URL[] getClasspath() throws Exception {
        int i;
        ArrayList<URL> list = new ArrayList<URL>();
        List classpathFiles = this.getProjectClasspathElements();
        for (i = 0; i < classpathFiles.size(); ++i) {
            list.add(new File((String)classpathFiles.get(i)).toURL());
        }
        if (this.classpath != null) {
            for (i = 0; i < this.classpath.length; ++i) {
                Artifact artifact = this.getArtifact(this.classpath[i]);
                list.add(artifact.getFile().toURL());
            }
        }
        URL[] urls = list.toArray(new URL[list.size()]);
        if (this.log.isDebugEnabled()) {
            this.log.debug((CharSequence)"Classpath:");
            for (int i2 = 0; i2 < urls.length; ++i2) {
                this.log.debug((CharSequence)("    " + urls[i2]));
            }
        }
        return urls;
    }

    private void validateFileSet(FileSet fileSet) throws Exception {
        if (fileSet == null) {
            throw new MojoExecutionException("FileSet contains null element");
        }
        String dirname = fileSet.getDirectory();
        if (dirname == null) {
            throw new MojoExecutionException("FileSet missing <directory> (or resolved to null value)");
        }
        File dir = new File(dirname);
        if (!dir.exists()) {
            throw new MojoExecutionException("FileSet <directory> does not exist: " + dir);
        }
        if (!dir.isDirectory()) {
            throw new MojoExecutionException("FileSet <directory> does not reference a directory: " + dir);
        }
    }

    private void compile(FileSet[] sources) throws Exception {
        if (!$assertionsDisabled && sources == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && sources.length <= 0) {
            throw new AssertionError();
        }
        CompilerConfiguration config = this.createCompilerConfiguration();
        ClassLoader parent = ClassLoader.getSystemClassLoader();
        GroovyClassLoader gcl = new GroovyClassLoader(parent, config);
        URL[] classpath = this.getClasspath();
        for (int i = 0; i < classpath.length; ++i) {
            gcl.addURL(classpath[i]);
        }
        CompilationUnit compilation = new CompilationUnit(config, null, gcl);
        FileSetManager fsm = new FileSetManager(this.log, this.log.isDebugEnabled());
        int count = 0;
        boolean _debug = this.log.isDebugEnabled();
        for (int i = 0; i < sources.length; ++i) {
            this.validateFileSet(sources[i]);
            File basedir = new File(sources[i].getDirectory());
            String[] includes = fsm.getIncludedFiles(sources[i]);
            if (_debug) {
                this.log.debug((CharSequence)("Adding sources from: " + basedir));
            }
            for (int j = 0; j < includes.length; ++j) {
                if (_debug) {
                    this.log.debug((CharSequence)("    " + includes[j]));
                }
                compilation.addSource(new File(basedir, includes[j]));
                ++count;
            }
        }
        if (count > 0) {
            this.log.info((CharSequence)("Compiling " + count + " Groovy source file" + (count > 1 ? "s" : "") + " to " + config.getTargetDirectory()));
            compilation.compile();
        } else {
            this.log.info((CharSequence)"No Groovy sources to compile");
        }
    }

    protected void doExecute() throws Exception {
        this.compile(this.sources != null ? this.sources : this.getDefaultSources());
    }

    static {
        $assertionsDisabled = !CompilationMojoSupport.class.desiredAssertionStatus();
    }
}

