/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.groovy;

import groovy.lang.GroovyCodeSource;
import groovy.lang.GroovyObject;
import groovy.lang.GroovyResourceLoader;
import groovy.lang.GroovyRuntimeException;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.groovy.CodeSource;
import org.codehaus.mojo.pluginsupport.MojoSupport;
import org.codehaus.mojo.pluginsupport.util.ArtifactItem;
import org.codehaus.mojo.pluginsupport.util.ExpressionParser;
import org.codehaus.plexus.component.factory.groovy.GroovyComponentFactory;
import org.codehaus.plexus.component.factory.groovy.GroovyResourceLoaderImpl;

public class ExecuteMojo
extends MojoSupport {
    private CodeSource source;
    private ArtifactItem[] classpath;
    private File[] scriptpath;
    private Map defaults;
    private Map properties;
    private MavenProject project;
    private ArtifactRepository artifactRepository;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected MavenProject getProject() {
        return this.project;
    }

    protected ArtifactRepository getArtifactRepository() {
        return this.artifactRepository;
    }

    protected void doExecute() throws Exception {
        boolean debug = this.log.isDebugEnabled();
        GroovyObject obj = this.loadGroovyObject(this.source);
        obj.setProperty("log", (Object)this.log);
        MavenProject delegate = new MavenProject(this.project){
            private Properties resolvedProperties;

            public Properties getProperties() {
                if (this.resolvedProperties == null) {
                    this.resolvedProperties = ExecuteMojo.this.resolveProperties(ExecuteMojo.this.project.getProperties());
                }
                return this.resolvedProperties;
            }
        };
        obj.setProperty("project", (Object)delegate);
        obj.setProperty("pom", (Object)delegate);
        if (debug) {
            this.log.debug((CharSequence)("Invoking run() on: " + obj));
        }
        try {
            obj.invokeMethod("run", (Object)new Object[0]);
        }
        catch (GroovyRuntimeException e) {
            Throwable cause;
            if (this.log.isDebugEnabled()) {
                this.log.error((CharSequence)"Groovy script execution failure", (Throwable)e);
            }
            if ((cause = e.getCause()) == null) {
                cause = e;
            }
            throw new MojoExecutionException(cause.getMessage(), cause);
        }
    }

    private GroovyObject loadGroovyObject(final CodeSource source) throws Exception {
        GroovyCodeSource gcs;
        if (!$assertionsDisabled && source == null) {
            throw new AssertionError();
        }
        boolean debug = this.log.isDebugEnabled();
        source.validate();
        if (source.getBody() != null) {
            gcs = new GroovyCodeSource(source.getBody(), "script" + System.currentTimeMillis() + ".groovy", "/groovy/script");
        } else {
            URL url = source.getFile() != null ? source.getFile().toURL() : source.getUrl();
            gcs = new GroovyCodeSource(url);
        }
        ClassLoader parent = ((Object)((Object)this)).getClass().getClassLoader();
        URL[] urls = this.getClasspath();
        URLClassLoader classLoader = new URLClassLoader(urls, parent);
        if (this.scriptpath != null) {
            this.log.debug((CharSequence)"Scriptpath:");
            for (int i = 0; i < this.scriptpath.length; ++i) {
                if (this.scriptpath[i] == null) {
                    throw new MojoExecutionException("Null element found in scriptpath at index: " + i);
                }
                if (!debug) continue;
                this.log.debug((CharSequence)("    " + this.scriptpath[i]));
            }
        }
        GroovyResourceLoaderImpl resourceLoader = new GroovyResourceLoaderImpl(classLoader){
            static final /* synthetic */ boolean $assertionsDisabled;

            protected URL resolveGroovySource(String className, ClassLoader classLoader) throws MalformedURLException {
                URL url;
                if (!$assertionsDisabled && className == null) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && classLoader == null) {
                    throw new AssertionError();
                }
                String resource = this.classToResourceName(className);
                if (ExecuteMojo.this.scriptpath != null) {
                    for (int i = 0; i < ExecuteMojo.this.scriptpath.length; ++i) {
                        if (!$assertionsDisabled && ExecuteMojo.this.scriptpath[i] == null) {
                            throw new AssertionError();
                        }
                        File file = new File(ExecuteMojo.this.scriptpath[i], resource);
                        if (!file.exists()) continue;
                        return file.toURL();
                    }
                }
                if ((url = classLoader.getResource(resource)) == null && resource.startsWith("/")) {
                    String tmp = resource.substring(1, resource.length());
                    url = classLoader.getResource(tmp);
                }
                if (url == null) {
                    File file;
                    File script = source.getFile();
                    if (script != null && (file = new File(script.getParentFile(), resource)).exists()) {
                        return file.toURL();
                    }
                } else {
                    return url;
                }
                return super.resolveGroovySource(className, classLoader);
            }

            static {
                $assertionsDisabled = !(class$org$codehaus$mojo$groovy$ExecuteMojo == null ? (class$org$codehaus$mojo$groovy$ExecuteMojo = ExecuteMojo.class$("org.codehaus.mojo.groovy.ExecuteMojo")) : class$org$codehaus$mojo$groovy$ExecuteMojo).desiredAssertionStatus();
            }
        };
        return new GroovyComponentFactory().loadGroovyObject(gcs, (ClassLoader)classLoader, (GroovyResourceLoader)resourceLoader);
    }

    private URL[] getClasspath() throws DependencyResolutionRequiredException, MalformedURLException, MojoExecutionException {
        int i;
        ArrayList<URL> list = new ArrayList<URL>();
        List classpathFiles = this.project.getCompileClasspathElements();
        for (i = 0; i < classpathFiles.size(); ++i) {
            list.add(new File((String)classpathFiles.get(i)).toURL());
        }
        if (this.classpath != null) {
            for (i = 0; i < this.classpath.length; ++i) {
                Artifact artifact = this.getArtifact(this.classpath[i]);
                list.add(artifact.getFile().toURL());
            }
        }
        URL[] urls = list.toArray(new URL[list.size()]);
        if (this.log.isDebugEnabled()) {
            this.log.debug((CharSequence)"Classpath:");
            for (int i2 = 0; i2 < urls.length; ++i2) {
                this.log.debug((CharSequence)("    " + urls[i2]));
            }
        }
        return urls;
    }

    private Properties resolveProperties(Properties source) {
        if (!$assertionsDisabled && source == null) {
            throw new AssertionError();
        }
        Properties dprops = new Properties();
        if (this.defaults != null) {
            dprops.putAll((Map<?, ?>)this.defaults);
        }
        Properties sprops = new Properties(dprops);
        sprops.putAll((Map<?, ?>)System.getProperties());
        Properties props = new Properties(sprops);
        if (this.properties != null) {
            props.putAll((Map<?, ?>)this.properties);
        }
        HashMap<String, MavenProject> vars = new HashMap<String, MavenProject>();
        vars.put("project", this.project);
        ExpressionParser parser = new ExpressionParser(vars);
        Iterator<Object> iter = source.keySet().iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            props.put(name, parser.parse(source.getProperty(name)));
        }
        return props;
    }

    static {
        $assertionsDisabled = !ExecuteMojo.class.desiredAssertionStatus();
    }
}

