/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.gwt;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.maven.model.Resource;
import org.codehaus.mojo.gwt.AbstractGwtMojo;
import org.codehaus.plexus.util.DirectoryScanner;

public abstract class AbstractGwtModuleMojo
extends AbstractGwtMojo {
    private static final String GWT_MODULE_EXTENSION = ".gwt.xml";
    private String module;
    private String[] modules;

    public void setModule(String module) {
        this.modules = new String[]{module};
    }

    public String[] getModules() {
        ArrayList<String> mods = new ArrayList<String>();
        if (this.modules == null) {
            DirectoryScanner scanner = new DirectoryScanner();
            scanner.setBasedir(this.project.getBuild().getSourceDirectory());
            scanner.setIncludes(new String[]{"**/*.gwt.xml"});
            scanner.scan();
            mods.addAll(Arrays.asList(scanner.getIncludedFiles()));
            List resources = this.project.getResources();
            for (Resource resource : resources) {
                scanner = new DirectoryScanner();
                scanner.setBasedir(resource.getDirectory());
                scanner.setIncludes(new String[]{"**/*.gwt.xml"});
                scanner.scan();
                mods.addAll(Arrays.asList(scanner.getIncludedFiles()));
            }
            if (mods.isEmpty()) {
                this.getLog().warn((CharSequence)"GWT plugin is configured to detect modules, but none where found.");
            }
            this.modules = new String[mods.size()];
            int i = 0;
            for (String fileName : mods) {
                String path = fileName.substring(0, fileName.length() - GWT_MODULE_EXTENSION.length());
                this.modules[i++] = path.replace(File.separatorChar, '.');
            }
        }
        return this.modules;
    }
}

